/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.spi;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.typescript.model.api.IConstantValue;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeElementFactory;
import org.eclipse.scout.sdk.core.typescript.model.api.internal.NodeElementFactoryImplementor;
import org.eclipse.scout.sdk.core.typescript.model.spi.ConstantValueDataTypeSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.DataTypeSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.ES6ClassSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.ES6ClassWithTypeArgumentsSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.NodeElementFactorySpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.NodeModuleSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.ObjectLiteralDataTypeSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.ObjectLiteralSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.SimpleCompositeDataTypeSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.SyntheticFieldSpi;
import org.eclipse.scout.sdk.core.util.CompositeObject;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;

public abstract class AbstractNodeElementFactorySpi
implements NodeElementFactorySpi {
    private final Map<Object, Object> m_elements;
    private final FinalValue<INodeElementFactory> m_api;
    private final NodeModuleSpi m_module;

    protected AbstractNodeElementFactorySpi(NodeModuleSpi module) {
        this.m_module = (NodeModuleSpi)Ensure.notNull((Object)module);
        this.m_elements = new ConcurrentHashMap<Object, Object>();
        this.m_api = new FinalValue();
    }

    public NodeModuleSpi containingModule() {
        return this.m_module;
    }

    @Override
    public INodeElementFactory api() {
        return (INodeElementFactory)this.m_api.computeIfAbsentAndGet(() -> new NodeElementFactoryImplementor(this));
    }

    protected <ID, R> R getOrCreate(ID identifier, Function<ID, R> factory) {
        return (R)this.m_elements.computeIfAbsent(identifier, id -> factory.apply(id));
    }

    @Override
    public SyntheticFieldSpi createSyntheticField(String name, DataTypeSpi dataType, ES6ClassSpi declaringClass) {
        return this.getOrCreate(new CompositeObject(new Object[]{name, declaringClass, SyntheticFieldSpi.class}), id -> new SyntheticFieldSpi(this.containingModule(), name, dataType, declaringClass));
    }

    @Override
    public ObjectLiteralDataTypeSpi createObjectLiteralDataType(String name, ObjectLiteralSpi objectLiteral) {
        return this.getOrCreate(new CompositeObject(new Object[]{name, objectLiteral}), id -> new ObjectLiteralDataTypeSpi(this.containingModule(), name, objectLiteral));
    }

    private DataTypeSpi createCompositeDataType(IDataType.DataTypeFlavor flavor, Collection<DataTypeSpi> componentDataTypes) {
        return this.getOrCreate(new CompositeObject(new Object[]{flavor, componentDataTypes}), id -> new SimpleCompositeDataTypeSpi(this.containingModule(), flavor, componentDataTypes, 0));
    }

    @Override
    public ES6ClassSpi createClassWithTypeArgumentsDataType(ES6ClassSpi classSpi, List<DataTypeSpi> arguments) {
        return this.getOrCreate(new AbstractMap.SimpleEntry<ES6ClassSpi, List<DataTypeSpi>>(classSpi, arguments), id -> new ES6ClassWithTypeArgumentsSpi(this.containingModule(), (ES6ClassSpi)id.getKey(), (List)id.getValue()));
    }

    @Override
    public DataTypeSpi createArrayDataType(DataTypeSpi componentDataType, int arrayDimension) {
        if (arrayDimension < 1) {
            return componentDataType;
        }
        int newDimension = arrayDimension;
        DataTypeSpi leafComponentType = componentDataType;
        if (componentDataType != null && componentDataType.flavor() == IDataType.DataTypeFlavor.Array) {
            newDimension += componentDataType.arrayDimension();
            leafComponentType = componentDataType.childTypes().stream().findAny().orElse(null);
        }
        Set componentDataTypes = Optional.ofNullable(leafComponentType).map(Collections::singleton).orElse(Collections.emptySet());
        int dimension = newDimension;
        return this.getOrCreate(new CompositeObject(new Object[]{IDataType.DataTypeFlavor.Array, componentDataTypes, dimension}), id -> new SimpleCompositeDataTypeSpi(this.containingModule(), IDataType.DataTypeFlavor.Array, componentDataTypes, dimension));
    }

    private DataTypeSpi createUnionOrIntersectionDataType(Collection<DataTypeSpi> componentDataTypes, IDataType.DataTypeFlavor unionOrIntersection) {
        if (componentDataTypes == null || componentDataTypes.isEmpty()) {
            return null;
        }
        if (componentDataTypes.size() == 1) {
            return componentDataTypes.iterator().next();
        }
        if (unionOrIntersection != IDataType.DataTypeFlavor.Union && unionOrIntersection != IDataType.DataTypeFlavor.Intersection) {
            return null;
        }
        return this.createCompositeDataType(unionOrIntersection, componentDataTypes.stream().flatMap(componentDataType -> componentDataType.flavor() == unionOrIntersection ? componentDataType.childTypes().stream() : Stream.of(componentDataType)).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    @Override
    public DataTypeSpi createUnionDataType(Collection<DataTypeSpi> componentDataTypes) {
        return this.createUnionOrIntersectionDataType(componentDataTypes, IDataType.DataTypeFlavor.Union);
    }

    @Override
    public DataTypeSpi createIntersectionDataType(Collection<DataTypeSpi> componentDataTypes) {
        return this.createUnionOrIntersectionDataType(componentDataTypes, IDataType.DataTypeFlavor.Intersection);
    }

    @Override
    public DataTypeSpi createConstantValueDataType(IConstantValue constantValue) {
        if (constantValue == null) {
            return null;
        }
        return this.getOrCreate(new CompositeObject(new Object[]{constantValue, ConstantValueDataTypeSpi.class}), id -> new ConstantValueDataTypeSpi(this.containingModule(), constantValue));
    }
}

