/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsil.util;

import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XMLUtil {
    public static String getAttributeValue(Element element, String attrName) {
        String attrValue = null;
        Attr attr = null;
        attr = element.getAttributeNode(attrName);
        if (attr != null) {
            attrValue = attr.getValue();
        }
        return attrValue;
    }

    public static String getAttributeValueNS(Element element, String namespace, String attrName) {
        String attrValue = null;
        Attr attr = null;
        attr = element.getAttributeNodeNS(namespace, attrName);
        if (attr != null) {
            attrValue = attr.getValue();
        }
        return attrValue;
    }

    public static Element getFirstChild(Element element) {
        return XMLUtil.findNextSibling(element.getFirstChild());
    }

    public static Element getNextSibling(Element element) {
        return XMLUtil.findNextSibling(element.getNextSibling());
    }

    protected static Element findNextSibling(Node startNode) {
        Node node = null;
        Element returnElement = null;
        node = startNode;
        while (node != null && returnElement == null) {
            if (node.getNodeType() == 1) {
                returnElement = (Element)node;
            }
            node = node.getNextSibling();
        }
        return returnElement;
    }

    public static String getText(Element element) {
        String text = null;
        Node node = element.getFirstChild();
        while (node != null && text == null) {
            if (node.getNodeType() == 3 || node.getNodeType() == 4) {
                text = ((CharacterData)node).getData();
            }
            node = node.getNextSibling();
        }
        return text;
    }
}

