/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model.provisional;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PresentationContext
implements IPresentationContext {
    private static final String PRESENTATION_CONTEXT_PROPERTIES = "PRESENTATION_CONTEXT_PROPERTIES";
    private static final String BOOLEAN = "BOOLEAN";
    private static final String STRING = "STRING";
    private static final String INTEGER = "INTEGER";
    private static final String PERSISTABLE = "PERSISTABLE";
    private final String fId;
    private final ListenerList<IPropertyChangeListener> fListeners = new ListenerList();
    private final Map<String, Object> fProperties = new HashMap<String, Object>();
    private IWorkbenchWindow fWindow;
    private IWorkbenchPart fPart;

    public PresentationContext(String id) {
        this(id, null, null);
    }

    public PresentationContext(String id, IWorkbenchWindow window) {
        this(id, window, null);
    }

    public PresentationContext(String id, IWorkbenchPart part) {
        this(id, part == null ? null : part.getSite().getWorkbenchWindow(), part);
    }

    public PresentationContext(IWorkbenchPart part) {
        this(part.getSite().getId(), part.getSite().getWorkbenchWindow(), part);
    }

    private PresentationContext(String id, IWorkbenchWindow window, IWorkbenchPart part) {
        this.fId = id;
        this.fWindow = window;
        this.fPart = part;
    }

    @Override
    public String[] getColumns() {
        return (String[])this.getProperty("PROPERTY_COLUMNS");
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        if (!this.fListeners.isEmpty()) {
            final PropertyChangeEvent event = new PropertyChangeEvent((Object)this, property, oldValue, newValue);
            Iterator iterator = this.fListeners.iterator();
            while (iterator.hasNext()) {
                IPropertyChangeListener iPropertyChangeListener;
                final IPropertyChangeListener listener = iPropertyChangeListener = (IPropertyChangeListener)iterator.next();
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        listener.propertyChange(event);
                    }
                });
            }
        }
    }

    public void setColumns(String[] ids) {
        this.setProperty("PROPERTY_COLUMNS", ids);
    }

    @Override
    public void dispose() {
        this.fProperties.clear();
        this.setProperty("PROPERTY_DISPOSED", Boolean.TRUE);
        this.fListeners.clear();
        this.fWindow = null;
        this.fPart = null;
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    @Override
    public String getId() {
        return this.fId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(String property) {
        Map<String, Object> map = this.fProperties;
        synchronized (map) {
            return this.fProperties.get(property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String property, Object value) {
        Object oldValue = null;
        boolean propertySet = false;
        Map<String, Object> map = this.fProperties;
        synchronized (map) {
            oldValue = this.fProperties.get(property);
            if (!this.isEqual(oldValue, value)) {
                propertySet = true;
                this.fProperties.put(property, value);
            }
        }
        if (propertySet) {
            this.firePropertyChange(property, oldValue, value);
        }
    }

    public void initProperties(IMemento memento) {
        IMemento presentationMemento = null;
        IMemento[] iMementoArray = memento.getChildren(PRESENTATION_CONTEXT_PROPERTIES);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento childMemento = iMementoArray[n2];
            if (this.getId().equals(childMemento.getID())) {
                presentationMemento = childMemento;
                break;
            }
            ++n2;
        }
        if (presentationMemento != null) {
            iMementoArray = presentationMemento.getChildren(STRING);
            n = iMementoArray.length;
            n2 = 0;
            while (n2 < n) {
                IMemento stringProperty = iMementoArray[n2];
                this.fProperties.put(stringProperty.getID(), stringProperty.getString(STRING));
                ++n2;
            }
            iMementoArray = presentationMemento.getChildren(INTEGER);
            n = iMementoArray.length;
            n2 = 0;
            while (n2 < n) {
                IMemento integerMemento = iMementoArray[n2];
                this.fProperties.put(integerMemento.getID(), integerMemento.getInteger(INTEGER));
                ++n2;
            }
            iMementoArray = presentationMemento.getChildren(BOOLEAN);
            n = iMementoArray.length;
            n2 = 0;
            while (n2 < n) {
                IMemento booleanMemento = iMementoArray[n2];
                this.fProperties.put(booleanMemento.getID(), booleanMemento.getBoolean(BOOLEAN));
                ++n2;
            }
            iMementoArray = presentationMemento.getChildren(PERSISTABLE);
            n = iMementoArray.length;
            n2 = 0;
            while (n2 < n) {
                IAdaptable element;
                IElementFactory factory;
                IMemento persistableMemento = iMementoArray[n2];
                String factoryID = persistableMemento.getString(PERSISTABLE);
                if (factoryID != null && (factory = PlatformUI.getWorkbench().getElementFactory(factoryID)) != null && (element = factory.createElement(persistableMemento)) != null) {
                    this.fProperties.put(persistableMemento.getID(), element);
                }
                ++n2;
            }
        }
    }

    public void saveProperites(IMemento memento) {
        if (this.fProperties.isEmpty()) {
            return;
        }
        IMemento properties = memento.createChild(PRESENTATION_CONTEXT_PROPERTIES, this.getId());
        for (Map.Entry<String, Object> entry : this.fProperties.entrySet()) {
            IMemento value;
            if (entry.getValue() instanceof String) {
                value = properties.createChild(STRING, entry.getKey());
                value.putString(STRING, (String)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Integer) {
                value = properties.createChild(INTEGER, entry.getKey());
                value.putInteger(INTEGER, ((Integer)entry.getValue()).intValue());
                continue;
            }
            if (entry.getValue() instanceof Boolean) {
                value = properties.createChild(BOOLEAN, entry.getKey());
                value.putBoolean(BOOLEAN, ((Boolean)entry.getValue()).booleanValue());
                continue;
            }
            if (!(entry.getValue() instanceof IPersistableElement)) continue;
            IPersistableElement persistable = (IPersistableElement)entry.getValue();
            IMemento value2 = properties.createChild(PERSISTABLE, entry.getKey());
            value2.putString(PERSISTABLE, persistable.getFactoryId());
            persistable.saveState(value2);
        }
    }

    private boolean isEqual(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getProperties() {
        Map<String, Object> map = this.fProperties;
        synchronized (map) {
            Set<String> keys = this.fProperties.keySet();
            return keys.toArray(new String[keys.size()]);
        }
    }

    @Override
    public IWorkbenchPart getPart() {
        return this.fPart;
    }

    @Override
    public IWorkbenchWindow getWindow() {
        return this.fWindow;
    }
}

