/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.properties.ListPropertySource;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class RepositoryRemotePropertySource
implements IPropertySource {
    private static final String PUSHURL = "pushurl";
    private static final String PUSH = "push";
    private static final String FETCH = "fetch";
    private final StoredConfig myConfig;
    private final String myName;
    private final IPropertyDescriptor[] descriptors;

    public RepositoryRemotePropertySource(StoredConfig config, String remoteName, PropertySheetPage page) {
        this.myConfig = config;
        this.myName = remoteName;
        ArrayList<PropertyDescriptor> resultList = new ArrayList<PropertyDescriptor>();
        PropertyDescriptor desc = new PropertyDescriptor((Object)"url", UIText.RepositoryRemotePropertySource_RemoteFetchURL_label);
        resultList.add(desc);
        desc = new PropertyDescriptor((Object)FETCH, UIText.RepositoryRemotePropertySource_FetchLabel);
        resultList.add(desc);
        desc = new PropertyDescriptor((Object)PUSHURL, UIText.RepositoryRemotePropertySource_RemotePushUrl_label);
        resultList.add(desc);
        desc = new PropertyDescriptor((Object)PUSH, UIText.RepositoryRemotePropertySource_PushLabel);
        resultList.add(desc);
        this.descriptors = resultList.toArray(new IPropertyDescriptor[0]);
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        try {
            this.myConfig.load();
        }
        catch (IOException | ConfigInvalidException e) {
            Activator.handleError(UIText.RepositoryRemotePropertySource_ErrorHeader, e, true);
        }
        return this.descriptors;
    }

    public Object getPropertyValue(Object id) {
        String[] list = this.myConfig.getStringList("remote", this.myName, (String)id);
        if (list != null && list.length > 0) {
            return list.length > 1 ? new ListPropertySource(Arrays.asList(list)) : list[0];
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

