/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.commands.CheckBoundGrammarCommand;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.model.ReferencedGrammarInfo;
import org.eclipse.lemminx.services.extensions.codelens.ICodeLensParticipant;
import org.eclipse.lemminx.services.extensions.codelens.ICodeLensRequest;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class ContentModelCodeLensParticipant
implements ICodeLensParticipant {
    private final ContentModelManager contentModelManager;

    public ContentModelCodeLensParticipant(ContentModelManager contentModelManager) {
        this.contentModelManager = contentModelManager;
    }

    @Override
    public void doCodeLens(ICodeLensRequest request, List<CodeLens> lenses, CancelChecker cancelChecker) {
        this.createReferencedGrammarLenses(request, lenses);
        ContentModelCodeLensParticipant.createBindToGrammarSchemaLenses(request, lenses);
    }

    private void createReferencedGrammarLenses(ICodeLensRequest request, List<CodeLens> lenses) {
        Range range;
        DOMDocument document = request.getDocument();
        if (!document.hasGrammar()) {
            return;
        }
        boolean canSupportOpenUri = ContentModelCodeLensParticipant.canSupportOpenUri(request);
        if (document.getFirstChild() == null) {
            range = new Range();
            range.setStart(new Position(0, 0));
        } else {
            range = XMLPositionUtility.createRange(document.getFirstChild());
        }
        range.setEnd(range.getStart());
        Set<ReferencedGrammarInfo> referencedGrammarInfos = this.contentModelManager.getReferencedGrammarInfos(document);
        for (ReferencedGrammarInfo info : referencedGrammarInfos) {
            lenses.add(this.createReferencedGrammarLens(info, range, canSupportOpenUri));
        }
    }

    private static boolean canSupportOpenUri(ICodeLensRequest request) {
        return request.isSupportedByClient("open.uri");
    }

    private CodeLens createReferencedGrammarLens(ReferencedGrammarInfo info, Range range, boolean canSupportOpenUri) {
        String grammarURI;
        String uri = info.getIdentifierURI();
        StringBuilder title = new StringBuilder(uri != null ? uri : "");
        String bindingKind = ReferencedGrammarInfo.getBindingKindAndResolvedBy(info);
        if (!StringUtils.isEmpty(bindingKind)) {
            title.append(" (");
            title.append(bindingKind);
            title.append(")");
        }
        String string = grammarURI = info.isInCache() ? info.getGrammarCacheInfo().getCachedResolvedUri() : null;
        if (grammarURI == null) {
            grammarURI = info.getResolvedURIInfo().getResolvedURI();
        }
        Command command = new Command(title.toString(), canSupportOpenUri ? "xml.open.uri" : "", canSupportOpenUri ? Arrays.asList(grammarURI) : null);
        return new CodeLens(range, command, null);
    }

    private static void createBindToGrammarSchemaLenses(ICodeLensRequest request, List<CodeLens> lenses) {
        if (!ContentModelCodeLensParticipant.canSupportAssociation(request)) {
            return;
        }
        DOMDocument document = request.getDocument();
        if (!CheckBoundGrammarCommand.canBindWithGrammar(document)) {
            return;
        }
        String documentURI = document.getDocumentURI();
        Range range = document.getDocumentElement() != null ? XMLPositionUtility.selectRootStartTag(document) : XMLPositionUtility.createRange(0, 0, document);
        lenses.add(ContentModelCodeLensParticipant.createAssociateLens(documentURI, "Bind to grammar/schema...", range));
    }

    private static boolean canSupportAssociation(ICodeLensRequest request) {
        if (!request.isSupportedByClient("association")) {
            return false;
        }
        DOMDocument document = request.getDocument();
        return !DOMUtils.isXSD(document) && !DOMUtils.isDTD(document.getDocumentURI()) && !DOMUtils.isRelaxNG(document);
    }

    private static CodeLens createAssociateLens(String documentURI, String title, Range range) {
        Command command = new Command(title, "xml.open.binding.wizard", Arrays.asList(documentURI));
        return new CodeLens(range, command, null);
    }
}

