/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants;

import java.util.List;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.dom.XMLModel;

public class XMLModelUtils {
    public static DOMRange getHrefNode(DOMDocument document, String hrefLocation) {
        if (hrefLocation == null) {
            return null;
        }
        List<XMLModel> xmlModels = document.getXMLModels();
        if (!xmlModels.isEmpty()) {
            String documentURI = document.getDocumentURI();
            for (XMLModel xmlModel : xmlModels) {
                String href = xmlModel.getHref();
                String xmlModelLocation = XMLModelUtils.getResolvedLocation(documentURI, href);
                if (!hrefLocation.equals(xmlModelLocation)) continue;
                return xmlModel.getHrefNode();
            }
        }
        return null;
    }

    private static String getResolvedLocation(String documentURI, String location) {
        if (location == null) {
            return null;
        }
        try {
            return XMLEntityManager.expandSystemId(location, documentURI, false);
        }
        catch (URI.MalformedURIException e) {
            return location;
        }
    }
}

