/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants;

import java.util.Collections;
import java.util.List;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.participants.IRelatedInfoFinder;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSyntaxErrorCode;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;

public class XMLSyntaxRelatedInfoFinder
implements IRelatedInfoFinder {
    private static String CLOSING_TAG_EXPECTED_HERE = "Closing tag expected here";

    @Override
    public List<DiagnosticRelatedInformation> findRelatedInformation(int offset, String errorKey, DOMDocument document) {
        XMLSyntaxErrorCode syntaxCode = XMLSyntaxErrorCode.get(errorKey);
        if (syntaxCode == null) {
            return Collections.emptyList();
        }
        switch (syntaxCode) {
            case ETagRequired: 
            case MarkupEntityMismatch: {
                DOMNode node;
                for (node = document.findNodeAt(offset); node != null && !node.isElement(); node = node.getParentNode()) {
                }
                if (node == null) {
                    return Collections.emptyList();
                }
                if (node == document.getDocumentElement() && ((DOMElement)node).hasEndTag()) {
                    return Collections.emptyList();
                }
                int numChildren = node.getChildren().size();
                int closeTagOffset = numChildren == 0 ? node.getEnd() : node.getChildren().get(numChildren - 1).getEnd();
                Range range = XMLPositionUtility.createRange(closeTagOffset, closeTagOffset, document);
                return Collections.singletonList(new DiagnosticRelatedInformation(new Location(document.getDocumentURI(), range), CLOSING_TAG_EXPECTED_HERE));
            }
        }
        return Collections.emptyList();
    }
}

