/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor.preferences;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.PreferenceMetadata;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.genericeditor.Messages;
import org.eclipse.ui.internal.genericeditor.preferences.GenericEditorPreferenceConstants;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class GenericEditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final ArrayList<SelectionListener> leadFollowerListeners = new ArrayList();
    private final Map<PreferenceMetadata<Boolean>, Button> buttons = new HashMap<PreferenceMetadata<Boolean>, Button>();
    private final Map<PreferenceMetadata<String>, Text> textFields = new HashMap<PreferenceMetadata<String>, Text>();
    private static final int columns = 2;
    private final IPreferenceStore store = GenericEditorPreferenceConstants.getPreferenceStore();

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Control control = this.createAppearancePage(parent);
        Dialog.applyDialogFont((Control)control);
        this.initialize();
        return control;
    }

    public boolean performOk() {
        IPreferenceStore iPreferenceStore = this.store;
        if (iPreferenceStore instanceof ScopedPreferenceStore) {
            ScopedPreferenceStore scopedStore = (ScopedPreferenceStore)iPreferenceStore;
            this.buttons.entrySet().forEach(e -> scopedStore.setValue(((PreferenceMetadata)e.getKey()).identifer(), ((Button)e.getValue()).getSelection()));
            this.textFields.entrySet().forEach(e -> scopedStore.setValue(((PreferenceMetadata)e.getKey()).identifer(), ((Text)e.getValue()).getText()));
            try {
                scopedStore.save();
            }
            catch (IOException e2) {
                Platform.getLog(((Object)((Object)this)).getClass()).error("Cannot to save preferences.", (Throwable)e2);
                return false;
            }
        }
        return true;
    }

    protected void performDefaults() {
        this.buttons.entrySet().forEach(e -> ((Button)e.getValue()).setSelection(this.store.getDefaultBoolean(((PreferenceMetadata)e.getKey()).identifer())));
        this.textFields.entrySet().forEach(e -> ((Text)e.getValue()).setText(this.store.getDefaultString(((PreferenceMetadata)e.getKey()).identifer())));
        this.updateFollower();
        super.performDefaults();
    }

    private Control createAppearancePage(Composite parent) {
        Composite appearanceComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Group contetAssistGroup = GenericEditorPreferencePage.createGroup(appearanceComposite, Messages.ContentAssistant);
        PreferenceMetadata autoActivationMetadata = new PreferenceMetadata(Boolean.class, "contentAssistant.autoActivation", (Object)true, Messages.ContentAssistant_autoActivation, Messages.ContentAssistant_autoActivation_Tooltip);
        Button autoActivation = this.createButton((PreferenceMetadata<Boolean>)autoActivationMetadata, (Composite)contetAssistGroup, 32, 0);
        PreferenceMetadata activationDelay = new PreferenceMetadata(String.class, "contentAssistant.autoActivationDelay", (Object)Integer.toString(10), Messages.ContentAssistant_autoActivationDelay, Messages.ContentAssistant_autoActivationDelay_Tooltip);
        Control[] activationDelayControl = this.createTextField((PreferenceMetadata<String>)activationDelay, (Composite)contetAssistGroup, 4, 20);
        PreferenceMetadata autoActivationOnTypeMetada = new PreferenceMetadata(Boolean.class, "contentAssistant.autoActivationOnType", (Object)true, Messages.ContentAssistant_autoActivationOnType, Messages.ContentAssistant_autoActivationOnType_Tooltip);
        Button autoActivationOnType = this.createButton((PreferenceMetadata<Boolean>)autoActivationOnTypeMetada, (Composite)contetAssistGroup, 32, 20);
        ArrayList<Button> follower = new ArrayList<Button>(3);
        Collections.addAll(follower, activationDelayControl);
        follower.add(autoActivationOnType);
        this.createDependency(autoActivation, autoActivationMetadata.identifer(), follower.toArray(new Control[0]));
        appearanceComposite.setLayout((Layout)layout);
        return appearanceComposite;
    }

    private void initialize() {
        this.buttons.entrySet().forEach(e -> ((Button)e.getValue()).setSelection(this.store.getBoolean(((PreferenceMetadata)e.getKey()).identifer())));
        this.textFields.entrySet().forEach(e -> ((Text)e.getValue()).setText(this.store.getString(((PreferenceMetadata)e.getKey()).identifer())));
    }

    private static Group createGroup(Composite parent, String label) {
        Group group = new Group(parent, 0);
        group.setFont(parent.getFont());
        group.setText(label);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        return group;
    }

    private Button createButton(PreferenceMetadata<Boolean> meta, Composite composite, int style, int horizontalIndent) {
        Button button = new Button(composite, style);
        button.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).indent(horizontalIndent, 0).create());
        button.setData(meta);
        button.setText(meta.name());
        button.setToolTipText(meta.description());
        this.buttons.put(meta, button);
        return button;
    }

    private Control[] createTextField(PreferenceMetadata<String> meta, Composite composite, int textLimit, int horizontalIndent) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(meta.name());
        GridData gd = new GridData(32);
        gd.horizontalIndent = horizontalIndent;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        textControl.setToolTipText(meta.description());
        textControl.addModifyListener(e -> this.updateStatus(GenericEditorPreferencePage.validateDelay(textControl.getText())));
        this.textFields.put(meta, textControl);
        return new Control[]{labelControl, textControl};
    }

    private static String validateDelay(String value) {
        if (value.isEmpty()) {
            return Messages.ContentAssistant_autoActivationDelay_EmptyInput;
        }
        try {
            int integer = GenericEditorPreferencePage.parseInteger(value);
            if (integer < 0) {
                return NLS.bind((String)Messages.ContentAssistant_autoActivationDelay_InvalidInput, (Object)integer);
            }
        }
        catch (NumberFormatException e) {
            return NLS.bind((String)Messages.ContentAssistant_autoActivationDelay_InvalidInput, (Object)value);
        }
        return null;
    }

    private void updateStatus(String errorMessage) {
        this.setValid(errorMessage == null);
        int messageType = errorMessage == null ? 0 : 3;
        this.setMessage(errorMessage, messageType);
        this.setErrorMessage(errorMessage);
    }

    private static int parseInteger(Object value) throws NumberFormatException {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new NumberFormatException(NLS.bind((String)Messages.ContentAssistant_autoActivationDelay_InvalidInput, (Object)value));
    }

    private void createDependency(final Button lead, String leadKey, final Control[] follower) {
        boolean leadState = this.store.getBoolean(leadKey);
        Control[] controlArray = follower;
        int n = follower.length;
        int n2 = 0;
        while (n2 < n) {
            Control f = controlArray[n2];
            f.setEnabled(leadState);
            ++n2;
        }
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean state = lead.getSelection();
                Control[] controlArray = follower;
                int n = follower.length;
                int n2 = 0;
                while (n2 < n) {
                    Control f = controlArray[n2];
                    f.setEnabled(state);
                    ++n2;
                }
            }
        };
        this.leadFollowerListeners.add((SelectionListener)listener);
        lead.addSelectionListener((SelectionListener)listener);
    }

    private void updateFollower() {
        for (SelectionListener listener : this.leadFollowerListeners) {
            listener.widgetSelected(null);
        }
    }
}

