/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.classworlds.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import org.codehaus.plexus.classworlds.launcher.ConfigurationException;
import org.codehaus.plexus.classworlds.launcher.ConfigurationHandler;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;

public class ConfigurationParser {
    public static final String MAIN_PREFIX = "main is";
    public static final String SET_PREFIX = "set";
    public static final String IMPORT_PREFIX = "import";
    public static final String LOAD_PREFIX = "load";
    public static final String OPTIONALLY_PREFIX = "optionally";
    protected static final String FROM_SEPARATOR = " from ";
    protected static final String USING_SEPARATOR = " using ";
    protected static final String DEFAULT_SEPARATOR = " default ";
    private final ConfigurationHandler handler;
    private final Properties systemProperties;

    public ConfigurationParser(ConfigurationHandler handler, Properties systemProperties) {
        this.handler = handler;
        this.systemProperties = systemProperties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(InputStream is) throws IOException, ConfigurationException, DuplicateRealmException, NoSuchRealmException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            int lineNo = 0;
            boolean mainSet = false;
            String curRealm = null;
            block24: while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    return;
                }
                ++lineNo;
                if (this.canIgnore(line = line.trim())) continue;
                char lineFirstChar = line.charAt(0);
                switch (lineFirstChar) {
                    case 'm': {
                        if (!line.startsWith(MAIN_PREFIX)) throw new ConfigurationException("Unhandled configuration", lineNo, line);
                        if (mainSet) {
                            throw new ConfigurationException("Duplicate main configuration", lineNo, line);
                        }
                        int fromLoc = line.indexOf(FROM_SEPARATOR, MAIN_PREFIX.length());
                        if (fromLoc < 0) {
                            throw new ConfigurationException("Missing from clause", lineNo, line);
                        }
                        String mainClassName = this.filter(line.substring(MAIN_PREFIX.length(), fromLoc).trim());
                        String mainRealmName = this.filter(line.substring(fromLoc + FROM_SEPARATOR.length()).trim());
                        this.handler.setAppMain(mainClassName, mainRealmName);
                        mainSet = true;
                        break;
                    }
                    case 's': {
                        File propertiesFile;
                        String value;
                        if (!line.startsWith(SET_PREFIX)) throw new ConfigurationException("Unhandled configuration", lineNo, line);
                        String conf = line.substring(SET_PREFIX.length()).trim();
                        int usingLoc = conf.indexOf(USING_SEPARATOR);
                        String property = null;
                        String propertiesFileName = null;
                        if (usingLoc >= 0) {
                            property = conf.substring(0, usingLoc).trim();
                            conf = propertiesFileName = this.filter(conf.substring(usingLoc + USING_SEPARATOR.length()).trim());
                        }
                        String defaultValue = null;
                        int defaultLoc = conf.indexOf(DEFAULT_SEPARATOR);
                        if (defaultLoc >= 0) {
                            defaultValue = this.filter(conf.substring(defaultLoc + DEFAULT_SEPARATOR.length()).trim());
                            if (property == null) {
                                property = conf.substring(0, defaultLoc).trim();
                            } else {
                                propertiesFileName = conf.substring(0, defaultLoc).trim();
                            }
                        }
                        if ((value = this.systemProperties.getProperty(property)) != null) continue block24;
                        if (propertiesFileName != null && (propertiesFile = new File(propertiesFileName)).exists()) {
                            Properties properties = new Properties();
                            try (InputStream inputStream = Files.newInputStream(Paths.get(propertiesFileName, new String[0]), new OpenOption[0]);){
                                properties.load(inputStream);
                                value = properties.getProperty(property);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (value == null && defaultValue != null) {
                            value = defaultValue;
                        }
                        if (value == null) continue block24;
                        value = this.filter(value);
                        this.systemProperties.setProperty(property, value);
                        break;
                    }
                    case '[': {
                        int rbrack = line.indexOf("]");
                        if (rbrack < 0) {
                            throw new ConfigurationException("Invalid realm specifier", lineNo, line);
                        }
                        String realmName = line.substring(1, rbrack);
                        this.handler.addRealm(realmName);
                        curRealm = realmName;
                        break;
                    }
                    case 'i': {
                        if (!line.startsWith(IMPORT_PREFIX)) throw new ConfigurationException("Unhandled configuration", lineNo, line);
                        if (curRealm == null) {
                            throw new ConfigurationException("Unhandled import", lineNo, line);
                        }
                        int fromLoc = line.indexOf(FROM_SEPARATOR, IMPORT_PREFIX.length());
                        if (fromLoc < 0) {
                            throw new ConfigurationException("Missing from clause", lineNo, line);
                        }
                        String importSpec = line.substring(IMPORT_PREFIX.length(), fromLoc).trim();
                        String relamName = line.substring(fromLoc + FROM_SEPARATOR.length()).trim();
                        this.handler.addImportFrom(relamName, importSpec);
                        break;
                    }
                    case 'l': {
                        if (!line.startsWith(LOAD_PREFIX)) throw new ConfigurationException("Unhandled configuration", lineNo, line);
                        String constituent = line.substring(LOAD_PREFIX.length()).trim();
                        if ((constituent = this.filter(constituent)).contains("*")) {
                            this.loadGlob(constituent, false);
                            break;
                        }
                        File file = new File(constituent);
                        if (file.exists()) {
                            this.handler.addLoadFile(file);
                            break;
                        }
                        try {
                            this.handler.addLoadURL(new URL(constituent));
                            break;
                        }
                        catch (MalformedURLException e) {
                            throw new FileNotFoundException(constituent);
                        }
                    }
                    case 'o': {
                        if (!line.startsWith(OPTIONALLY_PREFIX)) throw new ConfigurationException("Unhandled configuration", lineNo, line);
                        String constituent = line.substring(OPTIONALLY_PREFIX.length()).trim();
                        if ((constituent = this.filter(constituent)).contains("*")) {
                            this.loadGlob(constituent, true);
                            break;
                        }
                        File file = new File(constituent);
                        if (file.exists()) {
                            this.handler.addLoadFile(file);
                            break;
                        }
                        try {
                            this.handler.addLoadURL(new URL(constituent));
                        }
                        catch (MalformedURLException malformedURLException) {}
                        continue block24;
                    }
                    default: {
                        throw new ConfigurationException("Unhandled configuration", lineNo, line);
                    }
                }
            }
        }
    }

    protected void loadGlob(String line, boolean optionally) throws MalformedURLException, FileNotFoundException, ConfigurationException {
        File[] matches;
        File globFile = new File(line);
        File dir = globFile.getParentFile();
        if (!dir.exists()) {
            if (optionally) {
                return;
            }
            throw new FileNotFoundException(dir.toString());
        }
        String localName = globFile.getName();
        int starLoc = localName.indexOf("*");
        String prefix = localName.substring(0, starLoc);
        String suffix = localName.substring(starLoc + 1);
        for (File match : matches = dir.listFiles((dir1, name) -> {
            if (!name.startsWith(prefix)) {
                return false;
            }
            return name.endsWith(suffix);
        })) {
            this.handler.addLoadFile(match);
        }
    }

    protected String filter(String text) throws ConfigurationException {
        int propStart;
        StringBuilder result = new StringBuilder();
        int cur = 0;
        int textLen = text.length();
        while (cur < textLen && (propStart = text.indexOf("${", cur)) >= 0) {
            result.append(text, cur, propStart);
            int propStop = text.indexOf("}", propStart);
            if (propStop < 0) {
                throw new ConfigurationException("Unterminated property: " + text.substring(propStart));
            }
            String propName = text.substring(propStart + 2, propStop);
            String propValue = this.systemProperties.getProperty(propName);
            if (propName.equals("basedir") && (propValue == null || propValue.equals(""))) {
                propValue = new File("").getAbsolutePath();
            }
            if (propValue == null) {
                throw new ConfigurationException("No such property: " + propName);
            }
            result.append(propValue);
            cur = propStop + 1;
        }
        result.append(text.substring(cur));
        return result.toString();
    }

    private boolean canIgnore(String line) {
        return line.isEmpty() || line.startsWith("#");
    }
}

