/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.detachable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Tabulated<T> {
    private final Map<T, Integer> objectToId;
    private final List<T> idToObject;

    public Tabulated() {
        this.objectToId = new HashMap<T, Integer>();
        this.idToObject = new ArrayList<T>();
    }

    public Tabulated(int size) {
        this.objectToId = new HashMap<T, Integer>();
        this.idToObject = Arrays.asList(new Object[size]);
    }

    public Tabulated(ImmutableMap<T, Integer> objectToId, ImmutableList<T> idToObject) {
        this.objectToId = objectToId;
        this.idToObject = idToObject;
    }

    public int getId(T object) {
        Integer id = this.objectToId.get(object);
        if (id == null) {
            id = this.objectToId.size();
            this.objectToId.put(object, id);
            this.idToObject.add(object);
        }
        return id;
    }

    public int tryGetId(T object) {
        return this.objectToId.getOrDefault(object, -1);
    }

    public void set(T object, int id) {
        this.objectToId.put(object, id);
        this.idToObject.set(id, object);
    }

    public boolean contains(T object) {
        return this.objectToId.containsKey(object);
    }

    public T getObject(int id) {
        return this.idToObject.get(id);
    }

    public int size() {
        return this.idToObject.size();
    }

    public ImmutableList<T> getObjects() {
        return ImmutableList.copyOf(this.idToObject);
    }
}

