/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.GraphUtilities;
import org.eclipse.draw2d.graph.GraphVisitor;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Rank;

class LocalOptimizer
extends GraphVisitor {
    LocalOptimizer() {
    }

    boolean shouldSwap(Node current, Node next) {
        int offsetDiff;
        int iNext;
        int iCurrent;
        if (GraphUtilities.isConstrained(current, next)) {
            return false;
        }
        int crossCount = 0;
        int invertedCrossCount = 0;
        int rank = current.rank - 1;
        for (Edge currentEdge : current.incoming) {
            iCurrent = currentEdge.getIndexForRank(rank);
            for (Edge nextEdge : next.incoming) {
                iNext = nextEdge.getIndexForRank(rank);
                if (iNext < iCurrent) {
                    ++crossCount;
                    continue;
                }
                if (iNext > iCurrent) {
                    ++invertedCrossCount;
                    continue;
                }
                offsetDiff = nextEdge.getSourceOffset() - currentEdge.getSourceOffset();
                if (offsetDiff < 0) {
                    ++crossCount;
                    continue;
                }
                if (offsetDiff <= 0) continue;
                ++invertedCrossCount;
            }
        }
        rank = current.rank + 1;
        for (Edge currentEdge : current.outgoing) {
            iCurrent = currentEdge.getIndexForRank(rank);
            for (Edge nextEdge : next.outgoing) {
                iNext = nextEdge.getIndexForRank(rank);
                if (iNext < iCurrent) {
                    ++crossCount;
                    continue;
                }
                if (iNext > iCurrent) {
                    ++invertedCrossCount;
                    continue;
                }
                offsetDiff = nextEdge.getTargetOffset() - currentEdge.getTargetOffset();
                if (offsetDiff < 0) {
                    ++crossCount;
                    continue;
                }
                if (offsetDiff <= 0) continue;
                ++invertedCrossCount;
            }
        }
        return invertedCrossCount < crossCount;
    }

    private static void swapNodes(Node current, Node next, Rank rank) {
        int index = rank.indexOf(current);
        rank.set(index + 1, current);
        rank.set(index, next);
        index = current.index;
        current.index = next.index;
        next.index = index;
    }

    @Override
    public void visit(DirectedGraph g) {
        boolean flag;
        do {
            flag = false;
            for (Rank rank : g.ranks) {
                int n = 0;
                while (n < rank.count() - 1) {
                    Node nextNode;
                    Node currentNode = (Node)rank.get(n);
                    if (this.shouldSwap(currentNode, nextNode = (Node)rank.get(n + 1))) {
                        LocalOptimizer.swapNodes(currentNode, nextNode, rank);
                        flag = true;
                        n = Math.max(0, n - 2);
                    }
                    ++n;
                }
            }
        } while (flag);
    }
}

