/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UncategorizedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskComparator;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskKeyComparator;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;

public class TaskListInterestSorter
extends ViewerComparator {
    private final TaskKeyComparator taskKeyComparator = new TaskKeyComparator();
    private ViewerComparator configuredSorter;

    public void setconfiguredSorter(ViewerComparator configuredSorter) {
        this.configuredSorter = configuredSorter;
    }

    public int compare(Viewer compareViewer, Object o1, Object o2) {
        if (o1 instanceof ITaskContainer && o2 instanceof UnmatchedTaskContainer) {
            return -1;
        }
        if (o2 instanceof ITaskContainer && o1 instanceof UnmatchedTaskContainer) {
            return 1;
        }
        if (o1 instanceof ScheduledTaskContainer) {
            ScheduledTaskContainer dateRangeTaskContainer1 = (ScheduledTaskContainer)o1;
            if (o2 instanceof ScheduledTaskContainer) {
                ScheduledTaskContainer dateRangeTaskContainer2 = (ScheduledTaskContainer)o2;
                return dateRangeTaskContainer1.getDateRange().compareTo(dateRangeTaskContainer2.getDateRange());
            }
        }
        if (o1 instanceof ITaskContainer && o2 instanceof ScheduledTaskContainer) {
            return -1;
        }
        if (o1 instanceof ScheduledTaskContainer && o2 instanceof ITaskContainer) {
            return 1;
        }
        if (o1 instanceof UncategorizedTaskContainer && o2 instanceof ITaskContainer) {
            return -1;
        }
        if (o1 instanceof ITaskContainer && o2 instanceof UncategorizedTaskContainer) {
            return 1;
        }
        if (!(o1 instanceof ITask) && o2 instanceof ITask) {
            return 1;
        }
        if (!(o1 instanceof ITask)) {
            if (!(o2 instanceof ITask)) {
                return ((IRepositoryElement)o1).getSummary().compareToIgnoreCase(((IRepositoryElement)o2).getSummary());
            }
            return -1;
        }
        if (o1 instanceof ITaskContainer) {
            if (!(o2 instanceof ITask)) {
                return -1;
            }
            if (o2 instanceof ITaskContainer) {
                IRepositoryElement element1 = (IRepositoryElement)o1;
                IRepositoryElement element2 = (IRepositoryElement)o2;
                AbstractTask task1 = null;
                AbstractTask task2 = null;
                if (element1 instanceof ITask) {
                    task1 = (AbstractTask)element1;
                }
                if (element2 instanceof ITask) {
                    task2 = (AbstractTask)element2;
                }
                if (task1 == null && task2 == null) {
                    return this.comparePrioritiesAndKeys(element1, element2);
                }
                if (task1 == null) {
                    return 1;
                }
                if (task2 == null) {
                    return -1;
                }
                int complete = this.compareCompleted((ITask)task1, (ITask)task2);
                if (complete != 0) {
                    return complete;
                }
                int due = this.compareDueDates((ITask)task1, (ITask)task2);
                if (due != 0) {
                    return due;
                }
                int today = this.compareScheduledDate(task1, task2);
                if (today != 0) {
                    return today;
                }
            }
        }
        if (this.configuredSorter != null) {
            return this.configuredSorter.compare(compareViewer, o1, o2);
        }
        return 0;
    }

    private int compareDueDates(ITask task1, ITask task2) {
        if (TasksUiPlugin.getTaskActivityManager().isOverdue(task1) && !TasksUiPlugin.getTaskActivityManager().isOverdue(task2)) {
            return -1;
        }
        if (!TasksUiPlugin.getTaskActivityManager().isOverdue(task1) && TasksUiPlugin.getTaskActivityManager().isOverdue(task2)) {
            return 1;
        }
        return 0;
    }

    private int compareScheduledDate(AbstractTask task1, AbstractTask task2) {
        if (this.isToday(task1) && !this.isToday(task2)) {
            return -1;
        }
        if (!this.isToday(task1) && this.isToday(task2)) {
            return 1;
        }
        return 0;
    }

    private boolean isToday(AbstractTask task) {
        return TasksUiPlugin.getTaskActivityManager().isPastReminder(task) || TasksUiPlugin.getTaskActivityManager().isScheduledForToday(task);
    }

    private int compareCompleted(ITask task1, ITask task2) {
        if (task1.isCompleted() && !task2.isCompleted()) {
            return 1;
        }
        if (!task1.isCompleted() && task2.isCompleted()) {
            return -1;
        }
        return 0;
    }

    private int comparePrioritiesAndKeys(IRepositoryElement element1, IRepositoryElement element2) {
        int priority = this.comparePriorities(element1, element2);
        if (priority != 0) {
            return priority;
        }
        int key = this.compareKeys(element1, element2);
        if (key != 0) {
            return key;
        }
        return 0;
    }

    private int compareKeys(IRepositoryElement element1, IRepositoryElement element2) {
        return this.taskKeyComparator.compare(TaskComparator.getSortableFromElement(element1), TaskComparator.getSortableFromElement(element2));
    }

    private int comparePriorities(IRepositoryElement element1, IRepositoryElement element2) {
        if (element1 instanceof AbstractTaskContainer && element2 instanceof AbstractTaskContainer) {
            return ((AbstractTaskContainer)element1).getPriority().compareTo(((AbstractTaskContainer)element2).getPriority());
        }
        return 0;
    }
}

