/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.tokenizer;

class Yytoken {
    public int m_charBegin;
    public int m_length;
    public int m_line;
    public String m_text;
    public String m_type;

    Yytoken(String type) {
        this.m_type = type;
    }

    Yytoken(String type, String text, int line, int charBegin, int length) {
        this.m_type = type;
        this.m_text = new String(text);
        this.m_line = line;
        this.m_charBegin = charBegin;
        this.m_length = length;
    }

    public void delete(int start, int length) {
        int stringStart = start - this.m_charBegin;
        String oldString = this.m_text;
        this.m_text = oldString.substring(0, stringStart);
        this.m_text = String.valueOf(this.m_text) + oldString.substring(stringStart + length);
        this.m_length = this.m_text.length();
        System.out.println("new string = " + this.m_text);
    }

    public boolean equals(Yytoken other) {
        return this.m_type == other.getType() && this.m_text.equals(other.getText()) && this.m_line == other.getStartLine() && this.m_charBegin == other.getStartOffset() && this.m_length == other.getLength();
    }

    public int getEndOffset() {
        return this.m_charBegin + this.m_length;
    }

    public int getLength() {
        return this.m_length;
    }

    public int getStartLine() {
        return this.m_line;
    }

    public int getStartOffset() {
        return this.m_charBegin;
    }

    public String getText() {
        return this.m_text;
    }

    public String getType() {
        return this.m_type;
    }

    public void setStartOffset(int startOffset) {
        this.m_charBegin = startOffset;
    }

    public String toString() {
        return "Text   : " + this.m_text + "\ntype : " + this.m_type + "\nline  : " + this.m_line + "\ncBeg. : " + this.m_charBegin + "\ncEnd. : " + this.getEndOffset() + "\ncLength. : " + this.m_length;
    }

    public void updateOffset(int delta) {
        this.m_charBegin += delta;
    }

    public void updateText(String newText) {
        this.m_text = newText;
        this.m_length = newText.length();
    }
}

