/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.core.ast.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.mwe.core.ConfigurationException;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.issues.IssuesImpl;
import org.eclipse.emf.mwe.internal.core.ast.AbstractASTBase;
import org.eclipse.emf.mwe.internal.core.ast.ComponentAST;
import org.eclipse.emf.mwe.internal.core.ast.InclusionAST;
import org.eclipse.emf.mwe.internal.core.ast.ReferenceAST;
import org.eclipse.emf.mwe.internal.core.ast.SimpleParamAST;
import org.eclipse.emf.mwe.internal.core.ast.util.Injector;
import org.eclipse.emf.mwe.internal.core.ast.util.InjectorFactory;
import org.eclipse.emf.mwe.internal.core.ast.util.VisitorBase;
import org.eclipse.emf.mwe.internal.core.ast.util.WorkflowContainer;
import org.eclipse.emf.mwe.internal.core.ast.util.converter.Converter;

public class VisitorCreator
extends VisitorBase {
    private Map<String, Object> beans = new HashMap<String, Object>();
    private Map<Class<?>, Converter<?>> converter = new HashMap();
    private Object currentBean = null;
    private Issues issues = new IssuesImpl();

    private VisitorCreator cloneWithBean(Object newBean) {
        VisitorCreator newInst = new VisitorCreator(this.issues, this.converter, newBean);
        newInst.beans = this.beans;
        return newInst;
    }

    public VisitorCreator(Issues issues, Map<Class<?>, Converter<?>> converter, Object rootBean) {
        this.issues = issues;
        this.converter = converter;
        this.currentBean = rootBean;
    }

    @Override
    public Object visitInclusionAST(InclusionAST cart) {
        Injector inj2;
        Class<?> type;
        Injector inj;
        if (cart.getImportedElement() == null) {
            this.issues.addError("referenced element not resolved! ", cart);
        }
        if ((inj = InjectorFactory.getInjector(type = this.currentBean.getClass(), cart.getName())) == null) {
            this.issues.addError("no injector could be found in class " + type.getName() + " for property '" + cart.getName() + "'!", cart);
            return cart;
        }
        HashMap<String, Object> beansToPass = new HashMap<String, Object>();
        if (cart.isInheritAll()) {
            beansToPass.putAll(this.beans);
        }
        for (AbstractASTBase o : cart.getChildren()) {
            if (o instanceof InclusionAST) {
                throw new ConfigurationException("Nested inclusions are not supported!");
            }
            if (o instanceof ComponentAST) {
                ComponentAST p = (ComponentAST)o;
                Object bean = this.createBean(p, null);
                beansToPass.put(p.getName(), bean);
                continue;
            }
            if (!(o instanceof ReferenceAST)) continue;
            ReferenceAST ref = (ReferenceAST)o;
            if (this.beans.containsKey(ref.getIdRef())) {
                beansToPass.put(ref.getName(), this.beans.get(ref.getIdRef()));
                continue;
            }
            this.issues.addError("No bean with id " + ref.getIdRef() + " found!", ref);
        }
        WorkflowContainer wc = new WorkflowContainer();
        VisitorCreator vis = this.cloneWithBean(wc);
        vis.beans = beansToPass;
        Object importedElement = cart.getImportedElement().accept(vis);
        this.setValue(importedElement, cart.getName(), cart);
        Injector inj1 = InjectorFactory.getInjector(importedElement.getClass(), "location");
        if (inj1 != null) {
            inj1.setValue(importedElement, cart.getLocation());
        }
        if ((inj2 = InjectorFactory.getInjector(importedElement.getClass(), "ownLocation")) != null) {
            inj2.setValue(importedElement, cart.getImportedElement().getLocation());
        }
        if (cart.getId() != null) {
            this.beans.put(cart.getId(), importedElement);
        }
        return importedElement;
    }

    @Override
    public Object visitComponentAST(ComponentAST comp) {
        Class<?> type = this.currentBean.getClass();
        Injector inj = InjectorFactory.getInjector(type, comp.getName());
        if (inj == null) {
            this.issues.addError("no injector could be found in class " + type.getName() + " for property '" + comp.getName() + "'!", comp);
            return comp;
        }
        Class<?> toLoad = inj.getRequiredType();
        Object bean = this.createBean(comp, toLoad);
        if (bean != null) {
            inj.setValue(this.currentBean, bean);
        }
        return bean;
    }

    private Object createBean(ComponentAST comp, Class<?> toLoad) {
        Object bean = null;
        if (comp.getClazz() != null && (toLoad = this.loader.loadClass(comp.getClazz())) == null) {
            this.issues.addError("Class not found: '" + comp.getClazz() + "'", comp);
            return comp;
        }
        try {
            Injector inj;
            bean = toLoad.newInstance();
            if (comp.getId() != null) {
                this.beans.put(comp.getId(), bean);
                inj = InjectorFactory.getInjector(bean.getClass(), "id");
                if (inj != null) {
                    inj.setValue(bean, comp.getId());
                }
            }
            if (comp.getLocation() != null) {
                Injector inj1;
                inj = InjectorFactory.getInjector(bean.getClass(), "resource");
                if (inj != null) {
                    inj.setValue(bean, comp.getLocation().getResource());
                }
                if ((inj1 = InjectorFactory.getInjector(bean.getClass(), "location")) != null) {
                    inj1.setValue(bean, comp.getLocation());
                }
            }
            VisitorCreator vis = this.cloneWithBean(bean);
            Iterator<AbstractASTBase> iter = comp.getChildren().iterator();
            while (iter.hasNext()) {
                iter.next().accept(vis);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            this.issues.addError("Error creating instance of type '" + comp.getClazz() + "' : " + e.getMessage(), comp);
        }
        return bean;
    }

    private void setValue(Object value, String name, AbstractASTBase ele) {
        Injector inj = InjectorFactory.getInjector(this.currentBean.getClass(), name);
        if (inj == null) {
            this.issues.addError("no setter or adder could be found in class " + this.currentBean.getClass().getName() + " for '" + name + "'!", ele);
        } else {
            inj.setValue(this.currentBean, value);
        }
    }

    @Override
    public Object visitReferenceAST(ReferenceAST ref) {
        if (this.beans.containsKey(ref.getIdRef())) {
            this.setValue(this.beans.get(ref.getIdRef()), ref.getName(), ref);
            return this.beans.get(ref.getIdRef());
        }
        this.issues.addError("Couldn't find bean with id " + ref.getIdRef() + " : ", ref);
        return null;
    }

    @Override
    public Object visitSimpleParamAST(SimpleParamAST param) {
        Injector inj = InjectorFactory.getInjector(this.currentBean.getClass(), param.getName());
        if (inj == null) {
            this.issues.addError("no setter or adder could be found in class " + this.currentBean.getClass().getName() + " for '" + param.getName() + "'!", param);
            return null;
        }
        Converter<?> conv = this.converter.get(inj.getRequiredType());
        if (conv == null) {
            this.issues.addError("No converter found for " + String.valueOf(param) + " converting to " + String.valueOf(inj.getRequiredType()), param);
            return null;
        }
        Object val = conv.convert(param.getValue());
        inj.setValue(this.currentBean, val);
        return val;
    }
}

