/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.index.PointValues;

public interface Component2D {
    public double getMinX();

    public double getMaxX();

    public double getMinY();

    public double getMaxY();

    public boolean contains(double var1, double var3);

    public PointValues.Relation relate(double var1, double var3, double var5, double var7);

    public boolean intersectsLine(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15);

    public boolean intersectsTriangle(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19);

    public boolean containsLine(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15);

    public boolean containsTriangle(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19);

    public WithinRelation withinPoint(double var1, double var3);

    public WithinRelation withinLine(double var1, double var3, double var5, double var7, double var9, double var11, boolean var13, double var14, double var16);

    public WithinRelation withinTriangle(double var1, double var3, double var5, double var7, double var9, double var11, boolean var13, double var14, double var16, boolean var18, double var19, double var21, boolean var23);

    default public boolean intersectsLine(double aX, double aY, double bX, double bY) {
        double minY = StrictMath.min(aY, bY);
        double minX = StrictMath.min(aX, bX);
        double maxY = StrictMath.max(aY, bY);
        double maxX = StrictMath.max(aX, bX);
        return this.intersectsLine(minX, maxX, minY, maxY, aX, aY, bX, bY);
    }

    default public boolean intersectsTriangle(double aX, double aY, double bX, double bY, double cX, double cY) {
        double minY = StrictMath.min(StrictMath.min(aY, bY), cY);
        double minX = StrictMath.min(StrictMath.min(aX, bX), cX);
        double maxY = StrictMath.max(StrictMath.max(aY, bY), cY);
        double maxX = StrictMath.max(StrictMath.max(aX, bX), cX);
        return this.intersectsTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY);
    }

    default public boolean containsLine(double aX, double aY, double bX, double bY) {
        double minY = StrictMath.min(aY, bY);
        double minX = StrictMath.min(aX, bX);
        double maxY = StrictMath.max(aY, bY);
        double maxX = StrictMath.max(aX, bX);
        return this.containsLine(minX, maxX, minY, maxY, aX, aY, bX, bY);
    }

    default public boolean containsTriangle(double aX, double aY, double bX, double bY, double cX, double cY) {
        double minY = StrictMath.min(StrictMath.min(aY, bY), cY);
        double minX = StrictMath.min(StrictMath.min(aX, bX), cX);
        double maxY = StrictMath.max(StrictMath.max(aY, bY), cY);
        double maxX = StrictMath.max(StrictMath.max(aX, bX), cX);
        return this.containsTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY);
    }

    default public WithinRelation withinLine(double aX, double aY, boolean ab, double bX, double bY) {
        double minY = StrictMath.min(aY, bY);
        double minX = StrictMath.min(aX, bX);
        double maxY = StrictMath.max(aY, bY);
        double maxX = StrictMath.max(aX, bX);
        return this.withinLine(minX, maxX, minY, maxY, aX, aY, ab, bX, bY);
    }

    default public WithinRelation withinTriangle(double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
        double minY = StrictMath.min(StrictMath.min(aY, bY), cY);
        double minX = StrictMath.min(StrictMath.min(aX, bX), cX);
        double maxY = StrictMath.max(StrictMath.max(aY, bY), cY);
        double maxX = StrictMath.max(StrictMath.max(aX, bX), cX);
        return this.withinTriangle(minX, maxX, minY, maxY, aX, aY, ab, bX, bY, bc, cX, cY, ca);
    }

    public static boolean disjoint(double minX1, double maxX1, double minY1, double maxY1, double minX2, double maxX2, double minY2, double maxY2) {
        return maxY1 < minY2 || minY1 > maxY2 || maxX1 < minX2 || minX1 > maxX2;
    }

    public static boolean within(double minX1, double maxX1, double minY1, double maxY1, double minX2, double maxX2, double minY2, double maxY2) {
        return minY2 <= minY1 && maxY2 >= maxY1 && minX2 <= minX1 && maxX2 >= maxX1;
    }

    public static boolean containsPoint(double x, double y, double minX, double maxX, double minY, double maxY) {
        return x >= minX && x <= maxX && y >= minY && y <= maxY;
    }

    public static boolean pointInTriangle(double minX, double maxX, double minY, double maxY, double x, double y, double aX, double aY, double bX, double bY, double cX, double cY) {
        if (x >= minX && x <= maxX && y >= minY && y <= maxY) {
            int a = GeoUtils.orient(x, y, aX, aY, bX, bY);
            int b = GeoUtils.orient(x, y, bX, bY, cX, cY);
            if (a == 0 || b == 0 || a < 0 == b < 0) {
                int c = GeoUtils.orient(x, y, cX, cY, aX, aY);
                return c == 0 || c < 0 == (b < 0 || a < 0);
            }
            return false;
        }
        return false;
    }

    public static enum WithinRelation {
        CANDIDATE,
        NOTWITHIN,
        DISJOINT;

    }
}

