/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.ConfigurationAreaBlock;
import org.eclipse.pde.internal.ui.launcher.ConfigurationTemplateBlock;
import org.eclipse.pde.internal.ui.launcher.SoftwareInstallBlock;
import org.eclipse.pde.launching.IPDELauncherConstants;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ConfigurationTab
extends AbstractLauncherTab
implements IPDELauncherConstants {
    private final ConfigurationAreaBlock fConfigurationArea;
    private final ConfigurationTemplateBlock fTemplateArea;
    private final SoftwareInstallBlock fSoftwareInstallArea;
    private final Image fImage = PDEPluginImages.DESC_SETTINGS_OBJ.createImage();
    private final boolean fJUnitConfig;

    public ConfigurationTab() {
        this(false);
    }

    public ConfigurationTab(boolean isJUnitConfig) {
        this.fConfigurationArea = new ConfigurationAreaBlock(this);
        this.fTemplateArea = new ConfigurationTemplateBlock(this);
        this.fSoftwareInstallArea = new SoftwareInstallBlock(this);
        this.fJUnitConfig = isJUnitConfig;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        this.fConfigurationArea.createControl(container);
        this.fTemplateArea.createControl(container);
        this.fSoftwareInstallArea.createControl(container);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.launcher_configuration");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.fConfigurationArea.setDefaults(configuration, this.fJUnitConfig);
        this.fTemplateArea.setDefaults(configuration);
        this.fSoftwareInstallArea.setDefaults(configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fConfigurationArea.initializeFrom(configuration);
            this.fTemplateArea.initializeFrom(configuration);
            this.fSoftwareInstallArea.initializeFrom(configuration);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.fConfigurationArea.performApply(configuration);
        this.fTemplateArea.performApply(configuration);
        this.fSoftwareInstallArea.performApply(configuration);
    }

    public String getName() {
        return PDEUIMessages.ConfigurationTab_name;
    }

    public Image getImage() {
        return this.fImage;
    }

    public void dispose() {
        if (this.fImage != null) {
            this.fImage.dispose();
        }
    }

    @Override
    public void validateTab() {
        String error = this.fConfigurationArea.validate();
        if (error == null) {
            error = this.fTemplateArea.validate();
        }
        if (error == null) {
            error = this.fSoftwareInstallArea.validate();
        }
        this.setErrorMessage(error);
    }

    public String getId() {
        return "org.eclipse.pde.ui.launch.tab.configuration";
    }

    protected void initializeAttributes() {
        super.initializeAttributes();
        this.getAttributesLabelsForPrototype().put("useDefaultConfigArea", PDEUIMessages.ConfigurationTab_AttributeLabel_UseDefaultConfigArea);
        this.getAttributesLabelsForPrototype().put("configLocation", PDEUIMessages.ConfigurationTab_AttributeLabel_ConfigLocation);
        this.getAttributesLabelsForPrototype().put("clearConfig", PDEUIMessages.ConfigurationTab_AttributeLabel_ConfigClearArea);
        this.getAttributesLabelsForPrototype().put("useDefaultConfig", PDEUIMessages.ConfigurationTab_AttributeLabel_ConfigGenerateDefault);
        this.getAttributesLabelsForPrototype().put("templateConfig", PDEUIMessages.ConfigurationTab_AttributeLabel_ConfigTemplateLocation);
        this.getAttributesLabelsForPrototype().put("generateProfile", PDEUIMessages.ConfigurationTab_AttributeLabel_GenerateProfile);
    }
}

