/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.launcher;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.junit.launcher.JUnitLaunchShortcut;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.launching.launcher.LauncherUtils;

public class JUnitWorkbenchLaunchShortcut
extends JUnitLaunchShortcut {
    protected String getLaunchConfigurationTypeId() {
        return "org.eclipse.pde.ui.JunitLaunchConfig";
    }

    protected ILaunchConfigurationWorkingCopy createLaunchConfiguration(IJavaElement element) throws CoreException {
        String vmArgs;
        PDEPreferencesManager launchingStore;
        ILaunchConfigurationWorkingCopy configuration = super.createLaunchConfiguration(element);
        String configName = configuration.getName();
        configuration.setAttribute("run_in_ui_thread", true);
        if (TargetPlatformHelper.usesNewApplicationModel()) {
            configuration.setAttribute("pde.version", "3.3");
        } else if (TargetPlatformHelper.getTargetVersion() >= 3.2) {
            configuration.setAttribute("pde.version", "3.2a");
        }
        configuration.setAttribute("location", LaunchArgumentsHelper.getDefaultWorkspaceLocation((String)configName, (boolean)true));
        configuration.setAttribute("clearws", true);
        configuration.setAttribute("clearwslog", false);
        configuration.setAttribute("askclear", false);
        configuration.setAttribute("append.args", true);
        if (LauncherUtils.requiresUI((ILaunchConfiguration)configuration)) {
            String product = TargetPlatform.getDefaultProduct();
            if (product != null) {
                configuration.setAttribute("useProduct", true);
                configuration.setAttribute("product", product);
            }
        } else {
            configuration.setAttribute("application", "org.eclipse.pde.junit.runtime.coretestapplication");
        }
        if ("testPluginOnly".equals((launchingStore = PDELaunchingPlugin.getDefault().getPreferenceManager()).getString("Preferences.Launching.junitLaunchWith"))) {
            configuration.setAttribute("useCustomFeatures", false);
            IProject project = element.getJavaProject().getProject();
            IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(project);
            configuration.setAttribute("default", model == null);
            if (model != null) {
                HashSet<String> wsplugins = new HashSet<String>();
                this.appendPlugin(wsplugins, model);
                configuration.setAttribute("selected_workspace_bundles", wsplugins);
            }
        } else {
            configuration.setAttribute("default", true);
            configuration.setAttribute("useCustomFeatures", false);
        }
        configuration.setAttribute("automaticIncludeRequirements", launchingStore.getBoolean("Preferences.Launching.junitAutoInclude"));
        configuration.setAttribute("includeOptional", launchingStore.getBoolean("Preferences.Launching.junitIncludeOptional"));
        configuration.setAttribute("automaticAdd", launchingStore.getBoolean("Preferences.Launching.junitAddNewWorkspacePlugins"));
        configuration.setAttribute("automaticValidate", launchingStore.getBoolean("Preferences.Launching.junitValidateLaunch"));
        String programArgs = LaunchArgumentsHelper.getInitialProgramArguments();
        if (programArgs.length() > 0) {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, programArgs);
        }
        if ((vmArgs = LaunchArgumentsHelper.getInitialVMArguments()).length() > 0) {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs);
        }
        configuration.setAttribute("bootstrap", "");
        configuration.setAttribute("useDefaultConfig", true);
        boolean useDefaultArea = LaunchArgumentsHelper.getDefaultJUnitWorkspaceIsContainer();
        configuration.setAttribute("useDefaultConfigArea", useDefaultArea);
        if (!useDefaultArea) {
            configuration.setAttribute("configLocation", LaunchArgumentsHelper.getDefaultJUnitConfigurationLocation());
        }
        configuration.setAttribute("clearConfig", true);
        configuration.setAttribute("checked", "[NONE]");
        configuration.setAttribute("tracing", false);
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.pde.ui.workbenchClasspathProvider");
        return configuration;
    }

    private void appendPlugin(Set<String> plugins, IPluginModelBase model) {
        StringBuilder builder = new StringBuilder();
        builder.append(model.getPluginBase().getId());
        builder.append('*');
        builder.append(model.getPluginBase().getVersion());
        plugins.add(builder.toString());
    }
}

