/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.preferences.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.DESCipherImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.equinox.internal.security.storage.SecurePreferences;
import org.eclipse.equinox.internal.security.storage.SecurePreferencesContainer;
import org.eclipse.equinox.internal.security.storage.SecurePreferencesRoot;
import org.eclipse.equinox.internal.security.storage.SecurePreferencesWrapper;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.preferences.Property;
import org.eclipse.oomph.preferences.util.Messages;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class PreferencesUtil {
    private static final Cipher CIPHER = new Cipher();
    public static final String OPTION_SYNCHRONIZED_PREFERENCES = "SYNCHRONIZED_PREFERENCES";
    public static final String BUNDLE_DEFAULTS_NODE = "bundle_defaults";
    public static final String PREFERENCE_SCHEME = "preference";
    public static final URI ROOT_PREFERENCE_NODE_URI = URI.createURI((String)"preference:/");
    public static final String DEFAULT_NODE = "default";
    public static final String CONFIRGURATION_NODE = "configuration";
    public static final String INSTANCE_NODE = "instance";
    public static final String PROJECT_NODE = "project";
    public static final String SECURE_NODE = "secure";
    public static final Set<String> ALL_CHILD_NODES = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("secure", "bundle_defaults", "default", "configuration", "instance", "project")));
    private static final IEclipsePreferences ROOT = Platform.getPreferencesService().getRootNode();
    private static final Map<ISecurePreferences, ISecurePreferences> WRAPPERS = new HashMap<ISecurePreferences, ISecurePreferences>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISecurePreferences getSecurePreferences() {
        ISecurePreferences defaultSecurePreferences = SecurePreferencesFactory.getDefault();
        if (defaultSecurePreferences instanceof SecurePreferencesWrapper) {
            Map<ISecurePreferences, ISecurePreferences> map = WRAPPERS;
            synchronized (map) {
                Object securePreferences = WRAPPERS.get(defaultSecurePreferences);
                if (securePreferences == null) {
                    try {
                        SecurePreferences node = (SecurePreferences)ReflectUtil.getValue((String)"node", (Object)defaultSecurePreferences);
                        SecurePreferencesContainer container = (SecurePreferencesContainer)ReflectUtil.getValue((String)"container", (Object)defaultSecurePreferences);
                        Map options = (Map)ReflectUtil.getValue((String)"options", (Object)container);
                        SecurePreferencesRoot root = (SecurePreferencesRoot)ReflectUtil.getValue((String)"root", (Object)container);
                        container = new SecurePreferencesContainer(root, options){
                            final Map<SecurePreferences, ISecurePreferences> myWrappers = (Map)ReflectUtil.getValue((String)"wrappers", (Object)((Object)this));

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public ISecurePreferences wrapper(SecurePreferences node) {
                                Map<SecurePreferences, ISecurePreferences> map = this.myWrappers;
                                synchronized (map) {
                                    Object wrapper = this.myWrappers.get(node);
                                    if (wrapper == null) {
                                        wrapper = new AutoRefreshSecurePreferencesWrapper(node, this);
                                        this.myWrappers.put(node, (ISecurePreferences)wrapper);
                                    }
                                    return wrapper;
                                }
                            }
                        };
                        securePreferences = new AutoRefreshSecurePreferencesWrapper(node, container);
                    }
                    catch (RuntimeException ex) {
                        return defaultSecurePreferences;
                    }
                    WRAPPERS.put(defaultSecurePreferences, (ISecurePreferences)securePreferences);
                }
                defaultSecurePreferences = securePreferences;
            }
        }
        return defaultSecurePreferences;
    }

    public static PreferenceNode getRootPreferenceNode() {
        return PreferencesUtil.getRootPreferenceNode(false);
    }

    public static PreferenceNode getRootPreferenceNode(boolean isSynchronized) {
        return PreferencesUtil.getRootPreferenceNode(ALL_CHILD_NODES, isSynchronized);
    }

    public static PreferenceNode getRootPreferenceNode(Set<String> childNodes, boolean isSynchronized) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(ROOT_PREFERENCE_NODE_URI.appendSegment("*.preferences"));
        PreferenceNode root = PreferencesFactory.eINSTANCE.createPreferenceNode();
        resource.getContents().add((Object)root);
        PreferencesUtil.traverse(root, childNodes == ALL_CHILD_NODES ? null : childNodes, (Preferences)ROOT, isSynchronized);
        if (childNodes.size() > 1) {
            int index = 0;
            for (String name : childNodes) {
                PreferenceNode node = root.getNode(name);
                if (node == null) continue;
                root.getChildren().move(index++, (Object)node);
            }
        }
        if (childNodes.contains(SECURE_NODE)) {
            PreferenceNode secureRoot = PreferencesFactory.eINSTANCE.createPreferenceNode();
            ISecurePreferences securePreferences = PreferencesUtil.getSecurePreferences();
            if (securePreferences != null) {
                try {
                    PreferencesUtil.traverse(secureRoot, null, (Preferences)SecurePreferenceWapper.create(securePreferences), false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            secureRoot.setName(SECURE_NODE);
            root.getChildren().add(0, (Object)secureRoot);
        }
        return root;
    }

    public static Collection<? extends IEclipsePreferences> reconcile(PreferenceNode preferenceNode) throws BackingStoreException {
        IEclipsePreferences preferences = PreferencesUtil.getPreferences(preferenceNode);
        if (preferences == null) {
            throw new BackingStoreException(NLS.bind((String)Messages.PreferencesUtil_UnbackedPreferences_exception, (Object)preferenceNode));
        }
        return PreferencesUtil.reconcile(preferenceNode, preferences);
    }

    private static Collection<? extends IEclipsePreferences> reconcile(PreferenceNode preferenceNode, IEclipsePreferences preferences) throws BackingStoreException {
        boolean isModified = false;
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        HashSet<String> childNames = new HashSet<String>(Arrays.asList(preferences.childrenNames()));
        for (PreferenceNode child : preferenceNode.getChildren()) {
            String name = child.getName();
            if (childNames.remove(name)) {
                result.addAll(PreferencesUtil.reconcile(child, (IEclipsePreferences)preferences.node(name)));
                continue;
            }
            if (preferences == ROOT && SECURE_NODE.equals(name)) {
                result.addAll(PreferencesUtil.reconcile(child, SecurePreferenceWapper.create(PreferencesUtil.getSecurePreferences())));
                continue;
            }
            isModified = true;
            PreferencesUtil.create(child, preferences);
        }
        for (String name : childNames) {
            isModified = true;
            preferences.node(name).removeNode();
        }
        HashSet<String> propertyNames = new HashSet<String>(Arrays.asList(preferences.keys()));
        for (Property property : preferenceNode.getProperties()) {
            String name = property.getName();
            String value = property.getSecureValue();
            if (propertyNames.remove(name)) {
                try {
                    String oldValue = preferences.get(name, null);
                    if (ObjectUtil.equals((Object)value, (Object)oldValue)) continue;
                    isModified = true;
                    preferences.put(name, value);
                }
                catch (RuntimeException oldValue) {}
                continue;
            }
            isModified = true;
            if (property.isSecure() && preferences instanceof ISecurePreferences) {
                ISecurePreferences securePreferences = (ISecurePreferences)preferences;
                try {
                    securePreferences.put(name, value, true);
                    continue;
                }
                catch (StorageException ex) {
                    throw new BackingStoreException(ex.getMessage(), (Throwable)ex);
                }
            }
            preferences.put(name, value);
        }
        for (String name : propertyNames) {
            isModified = true;
            preferences.remove(name);
        }
        return isModified ? Collections.singleton(preferences) : result;
    }

    private static void create(PreferenceNode preferenceNode, IEclipsePreferences preferences) {
        IEclipsePreferences childPreferences = (IEclipsePreferences)preferences.node(preferenceNode.getName());
        for (PreferenceNode child : preferenceNode.getChildren()) {
            PreferencesUtil.create(child, childPreferences);
        }
        for (Property property : preferenceNode.getProperties()) {
            String value = property.getSecureValue();
            if (value == null) continue;
            String name = property.getName();
            if (childPreferences instanceof ISecurePreferences) {
                ISecurePreferences securePreferences = (ISecurePreferences)childPreferences;
                try {
                    securePreferences.put(name, value, property.isSecure());
                    continue;
                }
                catch (StorageException ex) {
                    throw new RuntimeException(ex);
                }
            }
            childPreferences.put(name, value);
        }
    }

    private static IEclipsePreferences getPreferences(PreferenceNode preferenceNode) throws BackingStoreException {
        if (preferenceNode == null) {
            return ROOT;
        }
        IEclipsePreferences parentPreferences = PreferencesUtil.getPreferences(preferenceNode.getParent());
        if (parentPreferences != null) {
            String name = preferenceNode.getName();
            if (parentPreferences.nodeExists(name)) {
                return (IEclipsePreferences)parentPreferences.node(name);
            }
            if (parentPreferences == ROOT && SECURE_NODE.equals(name)) {
                return SecurePreferenceWapper.create(PreferencesUtil.getSecurePreferences());
            }
        }
        return null;
    }

    private static void traverse(PreferenceNode preferenceNode, Set<String> childNodes, Preferences node, boolean isSynchronized) {
        try {
            if (isSynchronized && node instanceof IEclipsePreferences) {
                preferenceNode.eAdapters().add((Object)new PreferencesAdapter((IEclipsePreferences)node));
            }
            preferenceNode.setName(node.name());
            EList<PreferenceNode> children = preferenceNode.getChildren();
            Object[] childrenNames = node.childrenNames();
            Arrays.sort(childrenNames);
            Object[] objectArray = childrenNames;
            int n = childrenNames.length;
            int n2 = 0;
            while (n2 < n) {
                Object name = objectArray[n2];
                if (childNodes == null || childNodes.contains(name)) {
                    Preferences childNode = node.node((String)name);
                    PreferenceNode childPreferenceNode = PreferencesFactory.eINSTANCE.createPreferenceNode();
                    children.add((Object)childPreferenceNode);
                    PreferencesUtil.traverse(childPreferenceNode, null, childNode, isSynchronized);
                }
                ++n2;
            }
            EList<Property> properties = preferenceNode.getProperties();
            Object[] keys = node.keys();
            Arrays.sort(keys);
            Object[] objectArray2 = keys;
            int n3 = keys.length;
            int n4 = 0;
            while (n4 < n3) {
                Object name = objectArray2[n4];
                Property property = PreferencesFactory.eINSTANCE.createProperty();
                property.setName((String)name);
                if (node instanceof ISecurePreferences) {
                    ISecurePreferences securePreferences = (ISecurePreferences)node;
                    try {
                        boolean encrypted = securePreferences.isEncrypted((String)name);
                        property.setSecure(encrypted);
                    }
                    catch (StorageException storageException) {
                        // empty catch block
                    }
                }
                String value = null;
                try {
                    value = node.get((String)name, null);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                property.setValue(value == null ? "" : value);
                properties.add((Object)property);
                ++n4;
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static Preferences getPreferences(PreferenceNode preferenceNode, boolean demandCreate) throws BackingStoreException {
        if (preferenceNode == null) {
            return ROOT;
        }
        Preferences parentPreferences = PreferencesUtil.getPreferences(preferenceNode.getParent(), demandCreate);
        if (parentPreferences != null) {
            String name = preferenceNode.getName();
            boolean exists = false;
            if (name != null) {
                try {
                    exists = parentPreferences.nodeExists(name);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (demandCreate || exists) {
                return parentPreferences.node(name);
            }
        }
        return null;
    }

    public static IPath getLocation(Preferences preferences) {
        if (preferences == null) {
            return null;
        }
        try {
            Method getLocationMethod = preferences.getClass().getDeclaredMethod("getLocation", new Class[0]);
            getLocationMethod.setAccessible(true);
            IPath location = (IPath)getLocationMethod.invoke((Object)preferences, new Object[0]);
            return location;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String encrypt(String value) {
        return CIPHER.encrypt(value);
    }

    public static String decrypt(String value) {
        return CIPHER.decrypt(value);
    }

    private static boolean isEncryptedValue(String value) {
        return CIPHER.isEncryptedValue(value);
    }

    private static final class AutoRefreshSecurePreferencesWrapper
    extends SecurePreferencesWrapper {
        private AutoRefreshSecurePreferencesWrapper(SecurePreferences node, SecurePreferencesContainer container) {
            super(node, container);
        }

        public String absolutePath() {
            this.refresh();
            return super.absolutePath();
        }

        public String[] childrenNames() {
            this.refresh();
            return super.childrenNames();
        }

        public void clear() {
            this.refresh();
            super.clear();
        }

        public String[] keys() {
            this.refresh();
            return super.keys();
        }

        public void remove(String key) {
            this.refresh();
            super.remove(key);
        }

        public ISecurePreferences node(String pathName) {
            this.refresh();
            return super.node(pathName);
        }

        public ISecurePreferences parent() {
            this.refresh();
            return super.parent();
        }

        public boolean nodeExists(String pathName) {
            this.refresh();
            return super.nodeExists(pathName);
        }

        public void removeNode() {
            this.refresh();
            super.removeNode();
        }

        public String get(String key, String def) throws StorageException {
            this.refresh();
            return super.get(key, def);
        }

        public void put(String key, String value, boolean encrypt) throws StorageException {
            this.refresh();
            super.put(key, value, encrypt);
        }

        public boolean getBoolean(String key, boolean def) throws StorageException {
            this.refresh();
            return super.getBoolean(key, def);
        }

        public void putBoolean(String key, boolean value, boolean encrypt) throws StorageException {
            this.refresh();
            super.putBoolean(key, value, encrypt);
        }

        public int getInt(String key, int def) throws StorageException {
            this.refresh();
            return super.getInt(key, def);
        }

        public void putInt(String key, int value, boolean encrypt) throws StorageException {
            this.refresh();
            super.putInt(key, value, encrypt);
        }

        public float getFloat(String key, float def) throws StorageException {
            this.refresh();
            return super.getFloat(key, def);
        }

        public void putFloat(String key, float value, boolean encrypt) throws StorageException {
            this.refresh();
            super.putFloat(key, value, encrypt);
        }

        public long getLong(String key, long def) throws StorageException {
            this.refresh();
            return super.getLong(key, def);
        }

        public void putLong(String key, long value, boolean encrypt) throws StorageException {
            this.refresh();
            super.putLong(key, value, encrypt);
        }

        public double getDouble(String key, double def) throws StorageException {
            this.refresh();
            return super.getDouble(key, def);
        }

        public void putDouble(String key, double value, boolean encrypt) throws StorageException {
            this.refresh();
            super.putDouble(key, value, encrypt);
        }

        public byte[] getByteArray(String key, byte[] def) throws StorageException {
            this.refresh();
            return super.getByteArray(key, def);
        }

        public void putByteArray(String key, byte[] value, boolean encrypt) throws StorageException {
            this.refresh();
            super.putByteArray(key, value, encrypt);
        }

        public boolean isEncrypted(String key) throws StorageException {
            this.refresh();
            return super.isEncrypted(key);
        }

        public String getModule(String key) {
            this.refresh();
            return super.getModule(key);
        }

        public boolean passwordChanging(String moduleID) {
            this.refresh();
            return super.passwordChanging(moduleID);
        }

        private void refresh() {
            long timestamp;
            long lastModified;
            Object root = ReflectUtil.invokeMethod((String)"getRoot", (Object)this.node);
            boolean modified = (Boolean)ReflectUtil.invokeMethod((String)"isModified", (Object)root);
            if (!modified && (lastModified = ((Long)ReflectUtil.invokeMethod((String)"getLastModified", (Object)root)).longValue()) != (timestamp = ((Long)ReflectUtil.getValue((String)"timestamp", (Object)root)).longValue())) {
                ReflectUtil.invokeMethod((String)"load", (Object)root);
            }
        }
    }

    private static class Cipher
    extends DESCipherImpl {
        private static final String ENCRYPTION_PREFIX = "#!";

        public Cipher() {
            super(EcoreUtil.generateUUID());
        }

        public boolean isEncryptedValue(String value) {
            return value != null && value.startsWith(ENCRYPTION_PREFIX);
        }

        public String encrypt(String value) {
            if (value == null) {
                return null;
            }
            if ("".equals(value)) {
                return "";
            }
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                OutputStream out = this.encrypt(bytes);
                out.write(value.getBytes());
                out.close();
                return ENCRYPTION_PREFIX + XMLTypeFactory.eINSTANCE.convertBase64Binary(bytes.toByteArray());
            }
            catch (Exception ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }

        public String decrypt(String value) {
            if (value == null) {
                return null;
            }
            if ("".equals(value)) {
                return "";
            }
            if (value.startsWith(ENCRYPTION_PREFIX)) {
                value = value.substring(2);
            }
            ByteArrayInputStream byteValue = new ByteArrayInputStream(XMLTypeFactory.eINSTANCE.createBase64Binary(value));
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                InputStream in = this.decrypt(byteValue);
                IOUtil.copy((InputStream)in, (OutputStream)bytes);
                return new String(bytes.toByteArray());
            }
            catch (Exception ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }
    }

    public static class PreferenceProperty {
        private Preferences node;
        private String property;

        public PreferenceProperty(String preferencePropertyPath) {
            IEclipsePreferences rootNode = Platform.getPreferencesService().getRootNode();
            this.node = rootNode;
            String[] segments = preferencePropertyPath.split("/");
            StringBuilder property = null;
            boolean startProperty = false;
            int i = 0;
            while (i < segments.length - 1) {
                String segment = segments[i];
                if (property != null) {
                    if (startProperty) {
                        property.append('/');
                    } else {
                        startProperty = true;
                    }
                    property.append(segment);
                } else if (i != 0 && segment.length() == 0) {
                    property = new StringBuilder();
                } else if (this.node == rootNode && PreferencesUtil.SECURE_NODE.equals(segment)) {
                    rootNode = SecurePreferenceWapper.create(PreferencesUtil.getSecurePreferences());
                    this.node = rootNode;
                } else {
                    this.node = this.node.node(segment);
                }
                ++i;
            }
            this.property = property == null ? segments[segments.length - 1] : property.append('/').append(segments[segments.length - 1]).toString();
        }

        private PreferenceProperty(Preferences node, String property) {
            this.node = node;
            this.property = property;
        }

        public Preferences getNode() {
            return this.node;
        }

        public String getProperty() {
            return this.property;
        }

        public PreferenceProperty getEffectiveProperty() {
            try {
                String[] stringArray = this.node.keys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    if (key.equals(this.property)) {
                        return this;
                    }
                    ++n2;
                }
            }
            catch (BackingStoreException key) {
                // empty catch block
            }
            IEclipsePreferences rootNode = Platform.getPreferencesService().getRootNode();
            String path = this.nextScope(this.node.absolutePath());
            while (path != null) {
                try {
                    if (rootNode.nodeExists(path)) {
                        return new PreferenceProperty(rootNode.node(path), this.property).getEffectiveProperty();
                    }
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
                path = this.nextScope(path);
            }
            return this;
        }

        public PreferenceProperty getEffectiveDefaultProperty() {
            IEclipsePreferences rootNode = Platform.getPreferencesService().getRootNode();
            String path = this.nextScope(this.node.absolutePath());
            while (path != null) {
                try {
                    if (rootNode.nodeExists(path)) {
                        return new PreferenceProperty(rootNode.node(path), this.property).getEffectiveProperty();
                    }
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
                path = this.nextScope(path);
            }
            return null;
        }

        private String nextScope(String path) {
            if (path.startsWith("/instance/")) {
                return "/default/" + path.substring("/instance/".length());
            }
            if (path.startsWith("/default/")) {
                return "/bundle-defaults/" + path.substring("/default/".length());
            }
            return null;
        }

        public void set(String value) {
            if (value == null) {
                this.remove();
            } else {
                if (this.node instanceof SecurePreferenceWapper) {
                    SecurePreferenceWapper securePreferenceWapper = (SecurePreferenceWapper)this.node;
                    try {
                        boolean encrypted = securePreferenceWapper.preferences.isEncrypted(this.property);
                        if (!encrypted && PreferencesUtil.isEncryptedValue(value)) {
                            encrypted = true;
                        }
                        if (encrypted) {
                            value = PreferencesUtil.decrypt(value);
                        }
                        securePreferenceWapper.preferences.put(this.property, value, encrypted);
                        return;
                    }
                    catch (StorageException ex) {
                        return;
                    }
                }
                this.node.put(this.property, value);
            }
        }

        public String get(String defaultValue) {
            String value = this.node.get(this.property, defaultValue);
            if (this.node instanceof SecurePreferenceWapper) {
                SecurePreferenceWapper securePreferenceWapper = (SecurePreferenceWapper)this.node;
                try {
                    boolean encrypted = securePreferenceWapper.preferences.isEncrypted(this.property);
                    if (encrypted) {
                        return PreferencesUtil.encrypt(value);
                    }
                }
                catch (StorageException ex) {
                    return defaultValue;
                }
            }
            return value;
        }

        public void remove() {
            this.node.remove(this.property);
        }

        public void setInt(int value) {
            this.node.putInt(this.property, value);
        }

        public int getInt(int defaultValue) {
            return this.node.getInt(this.property, defaultValue);
        }

        public void setLong(long value) {
            this.node.putLong(this.property, value);
        }

        public long getLong(long defaultValue) {
            return this.node.getLong(this.property, defaultValue);
        }

        public void setBoolean(boolean value) {
            this.node.putBoolean(this.property, value);
        }

        public boolean getBoolean(boolean defaultValue) {
            return this.node.getBoolean(this.property, defaultValue);
        }

        public void setFloat(float value) {
            this.node.putFloat(this.property, value);
        }

        public float getFloat(float defaultValue) {
            return this.node.getFloat(this.property, defaultValue);
        }

        public void setDouble(double value) {
            this.node.putDouble(this.property, value);
        }

        public double getDouble(double defaultValue) {
            return this.node.getDouble(this.property, defaultValue);
        }

        public void setByteArray(byte[] value) {
            if (value == null) {
                this.remove();
            } else {
                this.node.putByteArray(this.property, value);
            }
        }

        public byte[] getByteArray(byte[] defaultValue) {
            return this.node.getByteArray(this.property, defaultValue);
        }
    }

    private static class PreferencesAdapter
    extends AdapterImpl
    implements IEclipsePreferences.INodeChangeListener,
    IEclipsePreferences.IPreferenceChangeListener {
        protected IEclipsePreferences preferences;

        public PreferencesAdapter(IEclipsePreferences preferences) {
            this.preferences = preferences;
            preferences.addNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
            preferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }

        public boolean isAdapterForType(Object type) {
            return type == PreferencesAdapter.class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (this.target == null) {
                return;
            }
            Resource resource = Thread.currentThread().getStackTrace();
            int n = ((StackTraceElement[])resource).length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = resource[n2];
                String methodName = stackTraceElement.getMethodName();
                if ("initializeDefaultPreferences".equals(methodName)) {
                    return;
                }
                if ("start".equals(methodName) && "org.eclipse.osgi.internal.framework.BundleContextImpl".equals(stackTraceElement.getClassName())) {
                    return;
                }
                if ("createExecutableExtension".equals(methodName) && "org.eclipse.core.internal.registry.ConfigurationElementHandle".equals(stackTraceElement.getClassName())) {
                    return;
                }
                if ("showPage".equals(methodName) && "org.eclipse.ui.internal.dialogs.FilteredPreferenceDialog".equals(stackTraceElement.getClassName())) {
                    return;
                }
                ++n2;
            }
            PreferenceNode preferenceNode = (PreferenceNode)this.target;
            Resource resource2 = preferenceNode.eResource();
            if (resource2 == null) {
                this.handlePreferenceChange(event, preferenceNode);
            } else {
                ResourceSet resourceSet = resource2.getResourceSet();
                resource = resource2;
                synchronized (resource) {
                    ResourceSet resourceSet2 = resourceSet;
                    synchronized (resourceSet2) {
                        this.handlePreferenceChange(event, preferenceNode);
                    }
                }
            }
        }

        private void handlePreferenceChange(IEclipsePreferences.PreferenceChangeEvent event, PreferenceNode preferenceNode) {
            String name = event.getKey();
            Object value = event.getNewValue();
            EList<Property> properties = preferenceNode.getProperties();
            int i = 0;
            int size = properties.size();
            while (i < size) {
                Property property = (Property)properties.get(i);
                int comparison = property.getName().compareTo(name);
                if (comparison == 0) {
                    if (value == null) {
                        properties.remove(i);
                    } else {
                        property.setValue(value.toString());
                    }
                    return;
                }
                if (comparison > 0) {
                    if (value != null) {
                        property = PreferencesFactory.eINSTANCE.createProperty();
                        property.setName(name);
                        property.setValue(value.toString());
                        properties.add(i, (Object)property);
                    }
                    return;
                }
                ++i;
            }
            if (value != null) {
                Property property = PreferencesFactory.eINSTANCE.createProperty();
                property.setName(name);
                property.setValue(value.toString());
                properties.add((Object)property);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void added(IEclipsePreferences.NodeChangeEvent event) {
            PreferenceNode preferenceNode = (PreferenceNode)this.target;
            Resource resource = preferenceNode.eResource();
            if (resource == null) {
                this.handleAdded(event, preferenceNode);
            } else {
                Resource resource2 = resource;
                synchronized (resource2) {
                    ResourceSet resourceSet;
                    ResourceSet resourceSet2 = resourceSet = resource.getResourceSet();
                    synchronized (resourceSet2) {
                        this.handleAdded(event, preferenceNode);
                    }
                }
            }
        }

        private void handleAdded(IEclipsePreferences.NodeChangeEvent event, PreferenceNode preferenceNode) {
            Preferences childNode = event.getChild();
            String name = childNode.name();
            if (preferenceNode.getNode(name) == null) {
                PreferenceNode childPreferenceNode = PreferencesFactory.eINSTANCE.createPreferenceNode();
                childPreferenceNode.setName(name);
                EList<PreferenceNode> children = preferenceNode.getChildren();
                int index = 0;
                int size = children.size();
                while (index < size) {
                    PreferenceNode otherChildPreferenceNode = (PreferenceNode)children.get(index);
                    if (otherChildPreferenceNode.getName().compareTo(name) >= 0) break;
                    ++index;
                }
                children.add(index, (Object)childPreferenceNode);
                PreferencesUtil.traverse(childPreferenceNode, null, childNode, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removed(IEclipsePreferences.NodeChangeEvent event) {
            PreferenceNode preferenceNode = (PreferenceNode)this.target;
            Resource resource = preferenceNode.eResource();
            if (resource == null) {
                this.handleRemoved(event, preferenceNode);
            } else {
                ResourceSet resourceSet = resource.getResourceSet();
                Resource resource2 = resource;
                synchronized (resource2) {
                    ResourceSet resourceSet2 = resourceSet;
                    synchronized (resourceSet2) {
                        this.handleRemoved(event, preferenceNode);
                    }
                }
            }
        }

        private void handleRemoved(IEclipsePreferences.NodeChangeEvent event, PreferenceNode preferenceNode) {
            Preferences childNode = event.getChild();
            String name = childNode.name();
            EList<PreferenceNode> children = preferenceNode.getChildren();
            int i = 0;
            int size = children.size();
            while (i < size) {
                PreferenceNode childPreferenceNode = (PreferenceNode)children.get(i);
                if (childPreferenceNode.getName().equals(name)) {
                    children.remove(i);
                    return;
                }
                ++i;
            }
        }

        public void unsetTarget(Notifier oldTarget) {
            super.unsetTarget(oldTarget);
            this.preferences.removeNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
            this.preferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
    }

    private static class SecurePreferenceWapper
    implements IEclipsePreferences,
    ISecurePreferences {
        private static final WeakHashMap<ISecurePreferences, SecurePreferenceWapper> WRAPPERS = new WeakHashMap();
        private final ISecurePreferences preferences;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static SecurePreferenceWapper create(ISecurePreferences preferences) {
            if (preferences == null) {
                return null;
            }
            WeakHashMap<ISecurePreferences, SecurePreferenceWapper> weakHashMap = WRAPPERS;
            synchronized (weakHashMap) {
                SecurePreferenceWapper securePreferenceWapper = WRAPPERS.get(preferences);
                if (securePreferenceWapper == null) {
                    securePreferenceWapper = new SecurePreferenceWapper(preferences);
                }
                return securePreferenceWapper;
            }
        }

        public void put(String key, String value, boolean encrypt) throws StorageException {
            this.preferences.put(key, value, encrypt);
        }

        public void putInt(String key, int value, boolean encrypt) throws StorageException {
            this.preferences.putInt(key, value, encrypt);
        }

        public void putLong(String key, long value, boolean encrypt) throws StorageException {
            this.preferences.putLong(key, value, encrypt);
        }

        public void putBoolean(String key, boolean value, boolean encrypt) throws StorageException {
            this.preferences.putBoolean(key, value, encrypt);
        }

        public void putFloat(String key, float value, boolean encrypt) throws StorageException {
            this.preferences.putFloat(key, value, encrypt);
        }

        public void putDouble(String key, double value, boolean encrypt) throws StorageException {
            this.preferences.putDouble(key, value, encrypt);
        }

        public void putByteArray(String key, byte[] value, boolean encrypt) throws StorageException {
            this.preferences.putByteArray(key, value, encrypt);
        }

        public SecurePreferenceWapper(ISecurePreferences preferences) {
            this.preferences = preferences;
        }

        public boolean isEncrypted(String key) {
            try {
                return this.preferences.isEncrypted(key);
            }
            catch (StorageException ex) {
                return true;
            }
        }

        protected RuntimeException create(Exception exception) {
            return new RuntimeException(exception);
        }

        public void put(String key, String value) {
            try {
                this.preferences.put(key, value, this.isEncrypted(key));
            }
            catch (StorageException ex) {
                throw this.create((Exception)((Object)ex));
            }
        }

        public String get(String key, String def) {
            try {
                return this.preferences.get(key, def);
            }
            catch (StorageException ex) {
                throw this.create((Exception)((Object)ex));
            }
        }

        public void remove(String key) {
            this.preferences.remove(key);
        }

        public void addNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        }

        public void removeNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        }

        public void clear() {
            this.preferences.clear();
        }

        public void putInt(String key, int value) {
            try {
                this.preferences.putInt(key, value, this.isEncrypted(key));
            }
            catch (StorageException ex) {
                throw this.create((Exception)((Object)ex));
            }
        }

        public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        }

        public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        }

        public int getInt(String key, int def) {
            try {
                return this.preferences.getInt(key, def);
            }
            catch (StorageException ex) {
                throw this.create((Exception)((Object)ex));
            }
        }

        public void removeNode() {
            this.preferences.removeNode();
        }

        public SecurePreferenceWapper node(String path) {
            return SecurePreferenceWapper.create(this.preferences.node(path));
        }

        public void putLong(String key, long value) {
            try {
                this.preferences.putLong(key, value, this.isEncrypted(key));
            }
            catch (StorageException ex) {
                throw this.create((Exception)((Object)ex));
            }
        }

        public void accept(IPreferenceNodeVisitor visitor) throws BackingStoreException {
            if (visitor.visit((IEclipsePreferences)this)) {
                String[] stringArray = this.childrenNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    this.node(name).accept(visitor);
                    ++n2;
                }
            }
        }

        public long getLong(String key, long def) {
            try {
                return this.preferences.getLong(key, def);
            }
            catch (StorageException ex) {
                throw this.create((Exception)((Object)ex));
            }
        }

        public void putBoolean(String key, boolean value) {
            try {
                this.preferences.putBoolean(key, value, this.isEncrypted(key));
            }
            catch (StorageException ex) {
                throw this.create((Exception)((Object)ex));
            }
        }

        public boolean getBoolean(String key, boolean def) {
            try {
                return this.preferences.getBoolean(key, def);
            }
            catch (StorageException ex) {
                throw this.create((Exception)((Object)ex));
            }
        }

        public void putFloat(String key, float value) {
            try {
                this.preferences.putFloat(key, value, this.isEncrypted(key));
            }
            catch (StorageException ex) {
                throw this.create((Exception)((Object)ex));
            }
        }

        public float getFloat(String key, float def) {
            try {
                return this.preferences.getFloat(key, def);
            }
            catch (StorageException ex) {
                throw this.create((Exception)((Object)ex));
            }
        }

        public void putDouble(String key, double value) {
            try {
                this.preferences.putDouble(key, value, this.isEncrypted(key));
            }
            catch (StorageException ex) {
                throw this.create((Exception)((Object)ex));
            }
        }

        public double getDouble(String key, double def) {
            try {
                return this.preferences.getDouble(key, def);
            }
            catch (StorageException ex) {
                throw this.create((Exception)((Object)ex));
            }
        }

        public void putByteArray(String key, byte[] value) {
            try {
                this.preferences.putByteArray(key, value, this.isEncrypted(key));
            }
            catch (StorageException ex) {
                throw this.create((Exception)((Object)ex));
            }
        }

        public byte[] getByteArray(String key, byte[] def) {
            try {
                return this.preferences.getByteArray(key, def);
            }
            catch (StorageException ex) {
                throw this.create((Exception)((Object)ex));
            }
        }

        public String[] keys() {
            return this.preferences.keys();
        }

        public String[] childrenNames() {
            return this.preferences.childrenNames();
        }

        public SecurePreferenceWapper parent() {
            return SecurePreferenceWapper.create(this.preferences.parent());
        }

        public boolean nodeExists(String pathName) {
            return this.preferences.nodeExists(pathName);
        }

        public String name() {
            return this.preferences.name();
        }

        public String absolutePath() {
            return this.preferences.absolutePath();
        }

        public void flush() {
            try {
                this.preferences.flush();
            }
            catch (IOException ex) {
                throw this.create(ex);
            }
        }

        public void sync() throws BackingStoreException {
            this.flush();
        }

        private StringBuilder toString(ISecurePreferences preferences) {
            StringBuilder builder;
            ISecurePreferences parent = preferences.parent();
            if (parent != null) {
                builder = this.toString(parent);
                builder.append('/');
            } else {
                builder = new StringBuilder();
            }
            String name = preferences.name();
            if (name == null) {
                builder.append('/');
                builder.append(PreferencesUtil.SECURE_NODE);
            } else {
                builder.append(name);
            }
            return builder;
        }

        public String toString() {
            return this.toString(this.preferences).toString();
        }
    }
}

