/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.AbstractPickList;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class E4StringPickList
extends AbstractPickList {
    private final Text text;
    private final Button tiReplace;
    private final AbstractComponentEditor<?> editor;
    private final EStructuralFeature feature;

    @Deprecated
    public E4StringPickList(Composite parent, int flags, List<AbstractPickList.PickListFeatures> list, Messages messages, AbstractComponentEditor<?> editor, EStructuralFeature feature) {
        this(parent, flags, list, editor, feature);
    }

    public E4StringPickList(Composite parent, int flags, List<AbstractPickList.PickListFeatures> list, AbstractComponentEditor<?> editor, EStructuralFeature feature) {
        super(parent, flags, Arrays.asList(AbstractPickList.PickListFeatures.NO_PICKER), editor);
        this.editor = editor;
        this.feature = feature;
        this.tiReplace = new Button(this.getToolBar(), 8);
        this.tiReplace.setToolTipText(Messages.E4StringPickList_Replace);
        this.tiReplace.setImage(editor.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.world_edit"));
        this.tiReplace.setFont(this.getButtonFont());
        Composite valueParent = new Composite(this.getToolBar().getParent(), 2048);
        valueParent.setLayout((Layout)new GridLayout(5, false));
        valueParent.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label l = new Label(valueParent, 0);
        l.setText(Messages.E4StringPickList_NewValue);
        l.setToolTipText(Messages.E4StringPickList_ToolTipNewValue);
        this.text = new Text(valueParent, 18436);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.text.setToolTipText(Messages.E4StringPickList_ToolTipNewValue);
        this.tiReplace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                E4StringPickList.this.handleReplaceText();
            }
        });
        this.getList().setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.text.addModifyListener(e -> this.updateUiState());
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                E4StringPickList.this.updateUiState();
            }
        });
        this.updateUiState();
    }

    @Override
    protected void moveUpPressed() {
        IStructuredSelection s;
        if (!this.viewer.getSelection().isEmpty() && (s = (IStructuredSelection)this.viewer.getSelection()).size() == 1) {
            Object obj = s.getFirstElement();
            Object container = this.editor.getMaster().getValue();
            this.tryEObjectMove(obj, (EObject)container, -1);
        }
    }

    @Override
    protected void moveDownPressed() {
        IStructuredSelection s;
        if (!this.viewer.getSelection().isEmpty() && (s = (IStructuredSelection)this.viewer.getSelection()).size() == 1) {
            Object obj = s.getFirstElement();
            Object container = this.editor.getMaster().getValue();
            this.tryEObjectMove(obj, (EObject)container, 1);
        }
    }

    @Override
    protected void removePressed() {
        if (!this.viewer.getSelection().isEmpty()) {
            List keybinding = ((IStructuredSelection)this.viewer.getSelection()).toList();
            Command cmd = RemoveCommand.create((EditingDomain)this.editor.getEditingDomain(), (Object)this.editor.getMaster().getValue(), (Object)this.feature, (Collection)keybinding);
            if (cmd.canExecute()) {
                this.editor.getEditingDomain().getCommandStack().execute(cmd);
            }
        }
    }

    protected void handleReplaceText() {
        if (this.getTextWidget().getText().trim().length() > 0 && !this.viewer.getSelection().isEmpty()) {
            String[] tags = this.getTextWidget().getText().split(";");
            int i = 0;
            while (i < tags.length) {
                tags[i] = tags[i].trim();
                ++i;
            }
            MApplicationElement appEl = (MApplicationElement)this.editor.getMaster().getValue();
            EObject el = (EObject)this.editor.getMaster().getValue();
            List ids = ((IStructuredSelection)this.viewer.getSelection()).toList();
            Object curVal = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
            EObject container = (EObject)this.editor.getMaster().getValue();
            List l = (List)container.eGet(this.feature);
            int idx = l.indexOf(curVal);
            if (idx >= 0) {
                Command cmdRemove = RemoveCommand.create((EditingDomain)this.editor.getEditingDomain(), (Object)el, (Object)this.feature, (Collection)ids);
                Command cmdInsert = AddCommand.create((EditingDomain)this.editor.getEditingDomain(), (Object)appEl, (Object)this.feature, Arrays.asList(tags), (int)idx);
                if (cmdRemove.canExecute() && cmdInsert.canExecute()) {
                    this.editor.getEditingDomain().getCommandStack().execute(cmdRemove);
                    this.editor.getEditingDomain().getCommandStack().execute(cmdInsert);
                }
                this.getTextWidget().setText("");
            }
        }
    }

    @Override
    public void updateUiState() {
        super.updateUiState();
        if (this.text != null) {
            IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
            Object firstViewerElement = sel.getFirstElement();
            String txt = this.text.getText();
            boolean diff = !txt.equals(firstViewerElement);
            this.tiReplace.setEnabled(firstViewerElement != null && !this.getTextWidget().getText().isEmpty() && diff);
            this.tiAdd.setEnabled(txt.length() > 0 && this.text.isFocusControl());
        }
    }

    @Override
    protected int getItemCount() {
        if (this.viewer.getContentProvider() == null || this.viewer.getInput() == null) {
            return 0;
        }
        return ((ObservableListContentProvider)this.viewer.getContentProvider()).getElements(this.viewer.getInput()).length;
    }

    protected Button getReplaceWidget() {
        return this.tiReplace;
    }

    public Text getTextWidget() {
        return this.text;
    }

    protected void tryEObjectMove(Object obj, EObject container, int delta) {
        Command cmd;
        List l = (List)container.eGet(this.feature);
        int idx = l.indexOf(obj) + delta;
        if ((delta > 0 && idx < l.size() || delta < 0 && idx >= 0) && (cmd = MoveCommand.create((EditingDomain)this.editor.getEditingDomain(), (Object)this.editor.getMaster().getValue(), (Object)this.feature, (Object)obj, (int)idx)).canExecute()) {
            this.editor.getEditingDomain().getCommandStack().execute(cmd);
            this.viewer.setSelection((ISelection)new StructuredSelection(obj));
        }
    }
}

