/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.bcpg.sig.Features;
import org.bouncycastle.bcpg.sig.PreferredAEADCiphersuites;
import org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import org.bouncycastle.openpgp.api.MessageEncryptionMechanism;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPMessageGenerator;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;

public abstract class OpenPGPEncryptionNegotiator {
    public abstract MessageEncryptionMechanism negotiateEncryption(OpenPGPMessageGenerator var1);

    static PreferredAEADCiphersuites negotiateAEADCiphersuite(List<OpenPGPCertificate> list, OpenPGPPolicy openPGPPolicy) {
        return new PreferredAEADCiphersuites(false, new PreferredAEADCiphersuites.Combination[]{OpenPGPEncryptionNegotiator.bestAEADCiphersuiteByWeight(list, openPGPPolicy)});
    }

    static boolean allRecipientsSupportSeipd2(List<OpenPGPCertificate> list) {
        return OpenPGPEncryptionNegotiator.allRecipientsSupportEncryptionFeature(list, (byte)8);
    }

    static boolean allRecipientsSupportLibrePGPOED(List<OpenPGPCertificate> list) {
        return OpenPGPEncryptionNegotiator.allRecipientsSupportEncryptionFeature(list, (byte)2);
    }

    static boolean allRecipientsSupportEncryptionFeature(List<OpenPGPCertificate> list, byte by) {
        Iterator<OpenPGPCertificate> iterator = list.iterator();
        while (iterator.hasNext()) {
            List<OpenPGPCertificate.OpenPGPComponentKey> list2 = iterator.next().getEncryptionKeys();
            if (list2.isEmpty()) continue;
            boolean bl = false;
            Iterator<OpenPGPCertificate.OpenPGPComponentKey> iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                Features features = iterator2.next().getFeatures();
                if (features == null || !features.supportsFeature(by)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static PreferredAEADCiphersuites.Combination bestAEADCiphersuiteByWeight(Collection<OpenPGPCertificate> collection, OpenPGPPolicy openPGPPolicy) {
        return OpenPGPEncryptionNegotiator.processCertificates(collection, openPGPPolicy, new KeyProcessor<PreferredAEADCiphersuites, PreferredAEADCiphersuites.Combination>(){

            @Override
            public boolean processKey(OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey, Map<OpenPGPCertificate.OpenPGPComponentKey, PreferredAEADCiphersuites> map) {
                PreferredAEADCiphersuites preferredAEADCiphersuites;
                Features features = openPGPComponentKey.getFeatures();
                if (features != null && features.supportsSEIPDv2() && (preferredAEADCiphersuites = openPGPComponentKey.getAEADCipherSuitePreferences()) != null) {
                    map.put(openPGPComponentKey, preferredAEADCiphersuites);
                    return true;
                }
                return false;
            }

            @Override
            public List<PreferredAEADCiphersuites.Combination> getAlgorithms(PreferredAEADCiphersuites preferredAEADCiphersuites, OpenPGPPolicy openPGPPolicy) {
                ArrayList<PreferredAEADCiphersuites.Combination> arrayList = new ArrayList<PreferredAEADCiphersuites.Combination>();
                for (PreferredAEADCiphersuites.Combination combination : preferredAEADCiphersuites.getAlgorithms()) {
                    if (combination.getSymmetricAlgorithm() == 0 || !openPGPPolicy.isAcceptableSymmetricKeyAlgorithm(combination.getSymmetricAlgorithm())) continue;
                    arrayList.add(combination);
                }
                return arrayList;
            }
        }, PreferredAEADCiphersuites.DEFAULT().getAlgorithms()[0]);
    }

    static int bestSymmetricKeyAlgorithmByWeight(Collection<OpenPGPCertificate> collection, OpenPGPPolicy openPGPPolicy) {
        return OpenPGPEncryptionNegotiator.processCertificates(collection, openPGPPolicy, new KeyProcessor<PreferredAlgorithms, Integer>(){

            @Override
            public boolean processKey(OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey, Map<OpenPGPCertificate.OpenPGPComponentKey, PreferredAlgorithms> map) {
                PreferredAlgorithms preferredAlgorithms;
                Features features = openPGPComponentKey.getFeatures();
                if (features != null && features.supportsModificationDetection() && (preferredAlgorithms = openPGPComponentKey.getSymmetricCipherPreferences()) != null) {
                    map.put(openPGPComponentKey, preferredAlgorithms);
                    return true;
                }
                return false;
            }

            @Override
            public List<Integer> getAlgorithms(PreferredAlgorithms preferredAlgorithms, OpenPGPPolicy openPGPPolicy) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                int[] nArray = preferredAlgorithms.getPreferences();
                for (int i = 0; i < nArray.length; ++i) {
                    int n = nArray[i];
                    if (n == 0 || !openPGPPolicy.isAcceptableSymmetricKeyAlgorithm(n)) continue;
                    arrayList.add(n);
                }
                return arrayList;
            }
        }, 7);
    }

    static int bestOEDEncryptionModeByWeight(Collection<OpenPGPCertificate> collection, OpenPGPPolicy openPGPPolicy) {
        return OpenPGPEncryptionNegotiator.processCertificates(collection, openPGPPolicy, new KeyProcessor<PreferredAlgorithms, Integer>(){

            @Override
            public boolean processKey(OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey, Map<OpenPGPCertificate.OpenPGPComponentKey, PreferredAlgorithms> map) {
                PreferredAlgorithms preferredAlgorithms;
                Features features = openPGPComponentKey.getFeatures();
                if (features != null && features.supportsFeature((byte)2) && (preferredAlgorithms = openPGPComponentKey.getSymmetricCipherPreferences()) != null) {
                    map.put(openPGPComponentKey, preferredAlgorithms);
                    return true;
                }
                return false;
            }

            @Override
            public List<Integer> getAlgorithms(PreferredAlgorithms preferredAlgorithms, OpenPGPPolicy openPGPPolicy) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                int[] nArray = preferredAlgorithms.getPreferences();
                for (int i = 0; i < nArray.length; ++i) {
                    int n = nArray[i];
                    if (!this.isOEDCompatible(n) || !openPGPPolicy.isAcceptableSymmetricKeyAlgorithm(n)) continue;
                    arrayList.add(n);
                }
                return arrayList;
            }

            private boolean isOEDCompatible(int n) {
                switch (n) {
                    case 7: 
                    case 8: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 13: {
                        return true;
                    }
                }
                return false;
            }
        }, 7);
    }

    private static <T, R> R processCertificates(Collection<OpenPGPCertificate> collection, OpenPGPPolicy openPGPPolicy, KeyProcessor<T, R> keyProcessor, R r) {
        HashMap<R, Float> hashMap = new HashMap<R, Float>();
        Iterator<OpenPGPCertificate> iterator = collection.iterator();
        while (iterator.hasNext()) {
            List<OpenPGPCertificate.OpenPGPComponentKey> list = iterator.next().getEncryptionKeys();
            if (list.isEmpty()) continue;
            HashMap hashMap2 = new HashMap();
            Iterator<OpenPGPCertificate.OpenPGPComponentKey> iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                keyProcessor.processKey(iterator2.next(), hashMap2);
            }
            Iterator object = hashMap2.keySet().iterator();
            while (object.hasNext()) {
                Object v = hashMap2.get(object.next());
                List<R> list2 = keyProcessor.getAlgorithms(v, openPGPPolicy);
                for (int i = 0; i < list2.size(); ++i) {
                    R r2 = list2.get(i);
                    float f = hashMap.containsKey(r2) ? ((Float)hashMap.get(r2)).floatValue() : 0.0f;
                    hashMap.put(r2, Float.valueOf(f + 1.0f / (float)(i + 1) / (float)hashMap2.size()));
                }
            }
        }
        iterator = r;
        float f = -1.0f;
        for (Map.Entry entry : hashMap.entrySet()) {
            if (!(((Float)entry.getValue()).floatValue() > f)) continue;
            f = ((Float)entry.getValue()).floatValue();
            iterator = entry.getKey();
        }
        return (R)iterator;
    }

    private static interface KeyProcessor<T, R> {
        public boolean processKey(OpenPGPCertificate.OpenPGPComponentKey var1, Map<OpenPGPCertificate.OpenPGPComponentKey, T> var2);

        public List<R> getAlgorithms(T var1, OpenPGPPolicy var2);
    }
}

