/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.internal.MavenPluginDependenciesValidator;
import org.apache.maven.plugin.internal.PluginDependenciesResolver;
import org.apache.maven.plugin.internal.WagonExcluder;
import org.apache.maven.repository.internal.RelocatedArtifact;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.util.filter.AndDependencyFilter;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;
import org.eclipse.aether.util.graph.manager.DependencyManagerUtils;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;

@Component(role=PluginDependenciesResolver.class)
public class DefaultPluginDependenciesResolver
implements PluginDependenciesResolver {
    private static final String REPOSITORY_CONTEXT = "plugin";
    @Requirement
    private Logger logger;
    @Requirement
    private RepositorySystem repoSystem;
    @Requirement
    private List<MavenPluginDependenciesValidator> dependenciesValidators;

    private Artifact toArtifact(Plugin plugin, RepositorySystemSession session) {
        return new DefaultArtifact(plugin.getGroupId(), plugin.getArtifactId(), null, "jar", plugin.getVersion(), session.getArtifactTypeRegistry().get("maven-plugin"));
    }

    @Override
    public Artifact resolve(Plugin plugin, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        RequestTrace trace = RequestTrace.newChild(null, (Object)plugin);
        Artifact pluginArtifact = this.toArtifact(plugin, session);
        try {
            String requiredMavenVersion;
            DefaultRepositorySystemSession pluginSession = new DefaultRepositorySystemSession(session);
            pluginSession.setArtifactDescriptorPolicy((ArtifactDescriptorPolicy)new SimpleArtifactDescriptorPolicy(true, false));
            ArtifactDescriptorRequest request = new ArtifactDescriptorRequest(pluginArtifact, repositories, REPOSITORY_CONTEXT);
            request.setTrace(trace);
            ArtifactDescriptorResult result = this.repoSystem.readArtifactDescriptor((RepositorySystemSession)pluginSession, request);
            for (MavenPluginDependenciesValidator dependenciesValidator : this.dependenciesValidators) {
                dependenciesValidator.validate(session, pluginArtifact, result);
            }
            pluginArtifact = result.getArtifact();
            if (this.logger.isWarnEnabled() && !result.getRelocations().isEmpty()) {
                String message = pluginArtifact instanceof RelocatedArtifact ? ((RelocatedArtifact)pluginArtifact).getMessage() : null;
                this.logger.warn("The artifact " + result.getRelocations().get(0) + " has been relocated to " + pluginArtifact + (message != null ? ": " + message : ""));
            }
            if ((requiredMavenVersion = (String)result.getProperties().get("prerequisites.maven")) != null) {
                LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(pluginArtifact.getProperties());
                props.put("requiredMavenVersion", requiredMavenVersion);
                pluginArtifact = pluginArtifact.setProperties(props);
            }
        }
        catch (ArtifactDescriptorException e) {
            throw new PluginResolutionException(plugin, e.getResult().getExceptions(), this.logger.isDebugEnabled() ? e : null);
        }
        try {
            ArtifactRequest request = new ArtifactRequest(pluginArtifact, repositories, REPOSITORY_CONTEXT);
            request.setTrace(trace);
            pluginArtifact = this.repoSystem.resolveArtifact(session, request).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new PluginResolutionException(plugin, e.getResult().getExceptions(), this.logger.isDebugEnabled() ? e : null);
        }
        return pluginArtifact;
    }

    public DependencyNode resolveCoreExtension(Plugin plugin, DependencyFilter dependencyFilter, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        return this.resolveInternal(plugin, null, dependencyFilter, repositories, session);
    }

    @Override
    public DependencyNode resolve(Plugin plugin, Artifact pluginArtifact, DependencyFilter dependencyFilter, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        return this.resolveInternal(plugin, pluginArtifact, dependencyFilter, repositories, session);
    }

    private DependencyNode resolveInternal(Plugin plugin, Artifact pluginArtifact, DependencyFilter dependencyFilter, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        DependencyNode node;
        RequestTrace trace = RequestTrace.newChild(null, (Object)plugin);
        if (pluginArtifact == null) {
            pluginArtifact = this.toArtifact(plugin, session);
        }
        ScopeDependencyFilter collectionFilter = new ScopeDependencyFilter(new String[]{"provided", "test"});
        DependencyFilter resolutionFilter = AndDependencyFilter.newInstance((DependencyFilter)collectionFilter, (DependencyFilter)dependencyFilter);
        try {
            DependencySelector selector = AndDependencySelector.newInstance((DependencySelector)session.getDependencySelector(), (DependencySelector)new WagonExcluder());
            DefaultRepositorySystemSession pluginSession = new DefaultRepositorySystemSession(session);
            pluginSession.setDependencySelector(selector);
            pluginSession.setDependencyGraphTransformer(session.getDependencyGraphTransformer());
            CollectRequest request = new CollectRequest();
            request.setRequestContext(REPOSITORY_CONTEXT);
            request.setRepositories(repositories);
            request.setRoot(new Dependency(pluginArtifact, null));
            for (org.apache.maven.model.Dependency dependency : plugin.getDependencies()) {
                Dependency pluginDep = RepositoryUtils.toDependency(dependency, session.getArtifactTypeRegistry());
                if (!"system".equals(pluginDep.getScope())) {
                    pluginDep = pluginDep.setScope("runtime");
                }
                request.addDependency(pluginDep);
            }
            DependencyRequest depRequest = new DependencyRequest(request, resolutionFilter);
            depRequest.setTrace(trace);
            request.setTrace(RequestTrace.newChild((RequestTrace)trace, (Object)depRequest));
            node = this.repoSystem.collectDependencies((RepositorySystemSession)pluginSession, request).getRoot();
            if (this.logger.isDebugEnabled()) {
                node.accept((DependencyVisitor)new GraphLogger());
            }
            depRequest.setRoot(node);
            this.repoSystem.resolveDependencies(session, depRequest);
        }
        catch (DependencyCollectionException e) {
            throw new PluginResolutionException(plugin, e.getResult().getExceptions(), this.logger.isDebugEnabled() ? e : null);
        }
        catch (DependencyResolutionException e) {
            List<Exception> exceptions = Stream.concat(e.getResult().getCollectExceptions().stream(), e.getResult().getArtifactResults().stream().filter(r -> !r.isResolved()).flatMap(r -> r.getExceptions().stream())).collect(Collectors.toList());
            throw new PluginResolutionException(plugin, exceptions, this.logger.isDebugEnabled() ? e : null);
        }
        return node;
    }

    class GraphLogger
    implements DependencyVisitor {
        private String indent = "";

        GraphLogger() {
        }

        public boolean visitEnter(DependencyNode node) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(this.indent);
            Dependency dep = node.getDependency();
            if (dep != null) {
                Artifact art = dep.getArtifact();
                buffer.append(art);
                if (StringUtils.isNotEmpty((String)dep.getScope())) {
                    buffer.append(':').append(dep.getScope());
                }
                if (dep.isOptional()) {
                    buffer.append(" (optional)");
                }
                if ((node.getManagedBits() & 2) == 2) {
                    String premanagedScope = DependencyManagerUtils.getPremanagedScope((DependencyNode)node);
                    buffer.append(" (scope managed from ");
                    buffer.append(Objects.toString(premanagedScope, "default"));
                    buffer.append(')');
                }
                if ((node.getManagedBits() & 1) == 1) {
                    String premanagedVersion = DependencyManagerUtils.getPremanagedVersion((DependencyNode)node);
                    buffer.append(" (version managed from ");
                    buffer.append(Objects.toString(premanagedVersion, "default"));
                    buffer.append(')');
                }
                if ((node.getManagedBits() & 4) == 4) {
                    Boolean premanagedOptional = DependencyManagerUtils.getPremanagedOptional((DependencyNode)node);
                    buffer.append(" (optionality managed from ");
                    buffer.append(Objects.toString(premanagedOptional, "default"));
                    buffer.append(')');
                }
                if ((node.getManagedBits() & 0x10) == 16) {
                    Collection premanagedExclusions = DependencyManagerUtils.getPremanagedExclusions((DependencyNode)node);
                    buffer.append(" (exclusions managed from ");
                    buffer.append(Objects.toString(premanagedExclusions, "default"));
                    buffer.append(')');
                }
                if ((node.getManagedBits() & 8) == 8) {
                    Map premanagedProperties = DependencyManagerUtils.getPremanagedProperties((DependencyNode)node);
                    buffer.append(" (properties managed from ");
                    buffer.append(Objects.toString(premanagedProperties, "default"));
                    buffer.append(')');
                }
            }
            DefaultPluginDependenciesResolver.this.logger.debug(buffer.toString());
            this.indent = this.indent + "   ";
            return true;
        }

        public boolean visitLeave(DependencyNode node) {
            this.indent = this.indent.substring(0, this.indent.length() - 3);
            return true;
        }
    }
}

