/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo;

import java.text.Collator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.ui.internal.tabletree.TreeContentHelper;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.DOMExtensionItem;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.ExtensionDetailsContentProvider;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.custom.DefaultListNodeEditorConfiguration;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.custom.NodeCustomizationRegistry;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.custom.NodeEditorConfiguration;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.custom.NodeEditorProvider;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMExtensionDetailsContentProvider
implements ExtensionDetailsContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String XMLNS = "xmlns";
    private static final String TEXT_NODE_KEY = "text()";

    public Object[] getItems(Object input) {
        HashMap<String, DOMExtensionItem> resultMap = new HashMap<String, DOMExtensionItem>();
        if (input instanceof Element) {
            CMElementDeclaration ed;
            ModelQuery modelQuery;
            Element element = (Element)input;
            NamedNodeMap attributes = element.getAttributes();
            int i = 0;
            while (i < attributes.getLength()) {
                Attr attr = (Attr)attributes.item(i);
                if (!XMLNS.equals(attr.getName()) && !XMLNS.equals(attr.getPrefix())) {
                    resultMap.put(attr.getName(), DOMExtensionItem.createItemForElementAttribute(element, attr));
                }
                ++i;
            }
            String textNodeValue = new TreeContentHelper().getNodeValue((Node)element);
            if (textNodeValue != null) {
                resultMap.put(TEXT_NODE_KEY, DOMExtensionItem.createItemForElementText(element));
            }
            if ((modelQuery = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument())) != null && (ed = modelQuery.getCMElementDeclaration(element)) != null) {
                int contentType;
                List list = modelQuery.getAvailableContent(element, ed, 1);
                Iterator i2 = list.iterator();
                while (i2.hasNext()) {
                    CMAttributeDeclaration ad = (CMAttributeDeclaration)i2.next();
                    if (ad == null || resultMap.get(ad.getNodeName()) != null) continue;
                    resultMap.put(ad.getNodeName(), DOMExtensionItem.createItemForElementAttribute(element, ad));
                }
                if (resultMap.get(TEXT_NODE_KEY) == null && ((contentType = ed.getContentType()) == 4 || contentType == 3)) {
                    resultMap.put(TEXT_NODE_KEY, DOMExtensionItem.createItemForElementText(element));
                }
            }
            Collection collection = resultMap.values();
            Iterator i3 = collection.iterator();
            while (i3.hasNext()) {
                this.initPropertyEditorConfiguration((DOMExtensionItem)i3.next());
            }
            Object[] items = new DOMExtensionItem[collection.size()];
            resultMap.values().toArray(items);
            if (items.length > 0) {
                Comparator comparator = new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        DOMExtensionItem a = (DOMExtensionItem)arg0;
                        DOMExtensionItem b = (DOMExtensionItem)arg1;
                        if (a.isTextValue() && !b.isTextValue()) {
                            return 1;
                        }
                        if (b.isTextValue() && !a.isTextValue()) {
                            return -1;
                        }
                        return Collator.getInstance().compare(a.getName(), b.getName());
                    }
                };
                Arrays.sort(items, comparator);
            }
            return items;
        }
        if (input instanceof Attr) {
            Attr attr = (Attr)input;
            DOMExtensionItem item = DOMExtensionItem.createItemForAttributeText(attr.getOwnerElement(), attr);
            Object[] items = new DOMExtensionItem[]{item};
            return items;
        }
        return EMPTY_ARRAY;
    }

    public String getName(Object item) {
        if (item instanceof DOMExtensionItem) {
            return ((DOMExtensionItem)item).getName();
        }
        return "";
    }

    public String getValue(Object item) {
        if (item instanceof DOMExtensionItem) {
            return ((DOMExtensionItem)item).getValue();
        }
        return "";
    }

    public String[] getPossibleValues(Object item) {
        if (item instanceof DOMExtensionItem) {
            return ((DOMExtensionItem)item).getPossibleValues();
        }
        return EMPTY_STRING_ARRAY;
    }

    protected void initPropertyEditorConfiguration(DOMExtensionItem item) {
        String[] values;
        NodeCustomizationRegistry registry;
        NodeEditorProvider provider;
        String namespace = item.getNamespace();
        String name = item.getName();
        String parentName = item.getParentName();
        NodeEditorConfiguration configuration = null;
        if (namespace != null && (provider = (registry = XSDEditorPlugin.getDefault().getNodeCustomizationRegistry()).getNodeEditorProvider(namespace)) != null && (configuration = provider.getNodeEditorConfiguration(parentName, name)) != null) {
            configuration.setParentNode(item.getParentNode());
            if (item.getNode() != null) {
                configuration.setNode(item.getNode());
            }
        }
        if ((values = item.getPossibleValues()) != null && values.length > 1) {
            configuration = new DefaultListNodeEditorConfiguration(values);
        }
        item.setPropertyEditorConfiguration(configuration);
    }
}

