/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.editor;

import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.xtext.common.types.ui.trace.ITraceForTypeRootProvider;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.JavaClassPathResourceForIEditorInputFactory;
import org.eclipse.xtext.ui.generator.trace.IEclipseTrace;
import org.eclipse.xtext.ui.resource.UriValidator;

public class XbaseResourceForEditorInputFactory
extends JavaClassPathResourceForIEditorInputFactory {
    @Inject
    private UriValidator uriValidator;
    @Inject
    private ITraceForTypeRootProvider typeForTypeRootProvider;

    protected URI getClassFileSourceURI(IClassFile classFile) {
        Iterator iterator;
        IEclipseTrace traceToSource = this.typeForTypeRootProvider.getTraceToSource((ITypeRoot)classFile);
        if (traceToSource != null && (iterator = traceToSource.getAllAssociatedLocations().iterator()).hasNext()) {
            ILocationInResource loc = (ILocationInResource)iterator.next();
            return loc.getAbsoluteResourceURI().getURI();
        }
        return null;
    }

    public Resource createResource(IEditorInput editorInput) {
        Resource resource;
        if (editorInput instanceof IClassFileEditorInput && (resource = this.createResource(((IClassFileEditorInput)editorInput).getClassFile())) != null) {
            return resource;
        }
        return super.createResource(editorInput);
    }

    protected boolean isValidationDisabled(URI uri, IStorage storage) {
        if (storage instanceof IFile) {
            IFile file = (IFile)storage;
            IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
            if (javaProject == null || !javaProject.exists() || !javaProject.isOpen()) {
                return true;
            }
            if (!this.canBuild(uri, storage)) {
                return true;
            }
        }
        return super.isValidationDisabled(uri, storage);
    }

    private boolean canBuild(URI uri, IStorage storage) {
        if (uri == null) {
            return this.uriValidator.canBuild(this.getStorageToUriMapper().getUri(storage), storage);
        }
        return this.uriValidator.canBuild(uri, storage);
    }

    protected boolean isValidationDisabled(IStorage storage) {
        return this.isValidationDisabled(null, storage);
    }

    protected Resource createResource(IClassFile classFile) {
        URI uri = this.getClassFileSourceURI(classFile);
        IProject project = classFile.getJavaProject().getProject();
        ResourceSet resourceSet = this.getResourceSetProvider().get(project);
        XtextResource resource = (XtextResource)this.getResourceFactory().createResource(uri);
        resourceSet.getResources().add((Object)resource);
        resource.setValidationDisabled(true);
        return resource;
    }
}

