/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.archetype;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.ui.internal.archetype.ArchetypeCatalogFactory;
import org.eclipse.m2e.core.ui.internal.archetype.ArchetypePlugin;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class ArchetypeCatalogsWriter {
    private static final Logger log = LoggerFactory.getLogger(ArchetypeCatalogsWriter.class);
    private static final String ELEMENT_CATALOGS = "archetypeCatalogs";
    private static final String ELEMENT_CATALOG = "catalog";
    private static final String ATT_CATALOG_TYPE = "type";
    private static final String ATT_CATALOG_LOCATION = "location";
    public static final String ATT_CATALOG_DESCRIPTION = "description";
    private static final String TYPE_LOCAL = "local";
    private static final String TYPE_REMOTE = "remote";
    private static final String TYPE_SYSTEM = "system";
    public static final String ATT_CATALOG_ID = "id";
    public static final String ATT_CATALOG_ENABLED = "enabled";

    Collection<ArchetypeCatalogFactory> readArchetypeCatalogs(InputStream is, Map<String, ArchetypeCatalogFactory> existingCatalogs, ArchetypePlugin plugin) throws IOException {
        ArrayList<ArchetypeCatalogFactory> catalogs = new ArrayList<ArchetypeCatalogFactory>();
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SAXParser parser = parserFactory.newSAXParser();
            parser.parse(is, (DefaultHandler)new ArchetypeCatalogsContentHandler(catalogs, existingCatalogs, plugin));
        }
        catch (SAXException ex) {
            String msg = Messages.ArchetypeCatalogsWriter_error_parse;
            log.error(msg, (Throwable)ex);
            throw new IOException(NLS.bind((String)msg, (Object)ex.getMessage()));
        }
        catch (ParserConfigurationException ex) {
            String msg = Messages.ArchetypeCatalogsWriter_error_parse;
            log.error(msg, (Throwable)ex);
            throw new IOException(NLS.bind((String)msg, (Object)ex.getMessage()));
        }
        return catalogs;
    }

    public void writeArchetypeCatalogs(Collection<ArchetypeCatalogFactory> catalogs, OutputStream os) throws IOException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new SAXSource(new XMLArchetypeCatalogsWriter(catalogs), new InputSource()), new StreamResult(os));
        }
        catch (TransformerFactoryConfigurationError ex) {
            throw new IOException(NLS.bind((String)Messages.ArchetypeCatalogsWriter_error_write, (Object)ex.getMessage()));
        }
        catch (TransformerException ex) {
            throw new IOException(NLS.bind((String)Messages.ArchetypeCatalogsWriter_error_write, (Object)ex.getMessage()));
        }
    }

    static class ArchetypeCatalogsContentHandler
    extends DefaultHandler {
        private final Collection<ArchetypeCatalogFactory> catalogs;
        private final Map<String, ArchetypeCatalogFactory> existingCatalogs;
        private ArchetypePlugin plugin;

        public ArchetypeCatalogsContentHandler(Collection<ArchetypeCatalogFactory> catalogs, Map<String, ArchetypeCatalogFactory> existingCatalogs, ArchetypePlugin plugin) {
            this.catalogs = catalogs;
            this.plugin = plugin;
            this.existingCatalogs = existingCatalogs == null ? Collections.emptyMap() : existingCatalogs;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (ArchetypeCatalogsWriter.ELEMENT_CATALOG.equals(qName) && attributes != null) {
                boolean enabled;
                String type = attributes.getValue(ArchetypeCatalogsWriter.ATT_CATALOG_TYPE);
                String enabledStr = attributes.getValue(ArchetypeCatalogsWriter.ATT_CATALOG_ENABLED);
                boolean bl = enabled = enabledStr == null || Boolean.parseBoolean(enabledStr);
                if (ArchetypeCatalogsWriter.TYPE_LOCAL.equals(type)) {
                    String path = attributes.getValue(ArchetypeCatalogsWriter.ATT_CATALOG_LOCATION);
                    if (path != null) {
                        String description = attributes.getValue(ArchetypeCatalogsWriter.ATT_CATALOG_DESCRIPTION);
                        this.catalogs.add(this.plugin.newLocalCatalogFactory(path, description, true, enabled));
                    }
                } else if (ArchetypeCatalogsWriter.TYPE_REMOTE.equals(type)) {
                    String url = attributes.getValue(ArchetypeCatalogsWriter.ATT_CATALOG_LOCATION);
                    if (url != null) {
                        String description = attributes.getValue(ArchetypeCatalogsWriter.ATT_CATALOG_DESCRIPTION);
                        this.catalogs.add(this.plugin.newRemoteCatalogFactory(url, description, true, enabled));
                    }
                } else {
                    ArchetypeCatalogFactory catalog;
                    String id = attributes.getValue(ArchetypeCatalogsWriter.ATT_CATALOG_ID);
                    if (id != null && !id.isEmpty() && (catalog = this.existingCatalogs.get(id)) != null) {
                        catalog.setEnabled(enabled);
                    }
                }
            }
        }
    }

    static class XMLArchetypeCatalogsWriter
    extends XMLFilterImpl {
        private final Collection<ArchetypeCatalogFactory> catalogs;

        public XMLArchetypeCatalogsWriter(Collection<ArchetypeCatalogFactory> catalogs) {
            this.catalogs = catalogs;
        }

        @Override
        public void parse(InputSource input) throws SAXException {
            ContentHandler handler = this.getContentHandler();
            handler.startDocument();
            handler.startElement(null, ArchetypeCatalogsWriter.ELEMENT_CATALOGS, ArchetypeCatalogsWriter.ELEMENT_CATALOGS, new AttributesImpl());
            for (ArchetypeCatalogFactory factory : this.catalogs) {
                AttributesImpl attrs = new AttributesImpl();
                if (factory.isEditable()) {
                    if (factory instanceof ArchetypeCatalogFactory.LocalCatalogFactory) {
                        attrs.addAttribute(null, ArchetypeCatalogsWriter.ATT_CATALOG_TYPE, ArchetypeCatalogsWriter.ATT_CATALOG_TYPE, null, ArchetypeCatalogsWriter.TYPE_LOCAL);
                        attrs.addAttribute(null, ArchetypeCatalogsWriter.ATT_CATALOG_LOCATION, ArchetypeCatalogsWriter.ATT_CATALOG_LOCATION, null, factory.getId());
                        attrs.addAttribute(null, ArchetypeCatalogsWriter.ATT_CATALOG_DESCRIPTION, ArchetypeCatalogsWriter.ATT_CATALOG_DESCRIPTION, null, factory.getDescription());
                    } else if (factory instanceof ArchetypeCatalogFactory.RemoteCatalogFactory) {
                        attrs.addAttribute(null, ArchetypeCatalogsWriter.ATT_CATALOG_TYPE, ArchetypeCatalogsWriter.ATT_CATALOG_TYPE, null, ArchetypeCatalogsWriter.TYPE_REMOTE);
                        attrs.addAttribute(null, ArchetypeCatalogsWriter.ATT_CATALOG_LOCATION, ArchetypeCatalogsWriter.ATT_CATALOG_LOCATION, null, factory.getId());
                        attrs.addAttribute(null, ArchetypeCatalogsWriter.ATT_CATALOG_DESCRIPTION, ArchetypeCatalogsWriter.ATT_CATALOG_DESCRIPTION, null, factory.getDescription());
                    }
                } else {
                    attrs.addAttribute(null, ArchetypeCatalogsWriter.ATT_CATALOG_TYPE, ArchetypeCatalogsWriter.ATT_CATALOG_TYPE, null, ArchetypeCatalogsWriter.TYPE_SYSTEM);
                    attrs.addAttribute(null, ArchetypeCatalogsWriter.ATT_CATALOG_ID, ArchetypeCatalogsWriter.ATT_CATALOG_ID, null, factory.getId());
                }
                attrs.addAttribute(null, ArchetypeCatalogsWriter.ATT_CATALOG_ENABLED, ArchetypeCatalogsWriter.ATT_CATALOG_ENABLED, null, Boolean.toString(factory.isEnabled()));
                handler.startElement(null, ArchetypeCatalogsWriter.ELEMENT_CATALOG, ArchetypeCatalogsWriter.ELEMENT_CATALOG, attrs);
                handler.endElement(null, ArchetypeCatalogsWriter.ELEMENT_CATALOG, ArchetypeCatalogsWriter.ELEMENT_CATALOG);
            }
            handler.endElement(null, ArchetypeCatalogsWriter.ELEMENT_CATALOGS, ArchetypeCatalogsWriter.ELEMENT_CATALOGS);
            handler.endDocument();
        }
    }
}

