/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.content;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.m2e.core.internal.content.TextContentDescriber;

class XMLContentDescriber
extends TextContentDescriber {
    private static final QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
    private static final String ENCODING = "encoding=";
    private static final String XML_PREFIX = "<?xml ";

    XMLContentDescriber() {
    }

    @Override
    public int describe(InputStream input, IContentDescription description) throws IOException {
        String charset;
        String fullXMLDecl;
        byte[] xmlPrefixBytes;
        byte[] prefix;
        byte[] bom = this.getByteOrderMark(input);
        Charset xmlDeclEncoding = StandardCharsets.UTF_8;
        input.reset();
        if (bom != null) {
            if (bom == IContentDescription.BOM_UTF_16BE) {
                xmlDeclEncoding = StandardCharsets.UTF_16BE;
            } else if (bom == IContentDescription.BOM_UTF_16LE) {
                xmlDeclEncoding = StandardCharsets.UTF_16LE;
            }
            input.skip(bom.length);
            if (description != null && description.isRequested(IContentDescription.BYTE_ORDER_MARK)) {
                description.setProperty(IContentDescription.BYTE_ORDER_MARK, (Object)bom);
            }
        }
        if (input.read(prefix = new byte[(xmlPrefixBytes = XML_PREFIX.getBytes(xmlDeclEncoding)).length]) < prefix.length) {
            return 1;
        }
        int i = 0;
        while (i < prefix.length) {
            if (prefix[i] != xmlPrefixBytes[i]) {
                return 1;
            }
            ++i;
        }
        if (description == null) {
            return 2;
        }
        if (description.isRequested(IContentDescription.CHARSET) && (fullXMLDecl = this.readFullXMLDecl(input, xmlDeclEncoding)) != null && (charset = this.getCharset(fullXMLDecl)) != null && !"UTF-8".equalsIgnoreCase(charset)) {
            description.setProperty(IContentDescription.CHARSET, (Object)this.getCharset(fullXMLDecl));
        }
        return 2;
    }

    private String readFullXMLDecl(InputStream input, Charset unicodeEncoding) throws IOException {
        byte[] xmlDecl = new byte[100];
        int c = 0;
        int read = 0;
        while (read < xmlDecl.length && (c = input.read()) != -1 && c != 63) {
            xmlDecl[read++] = (byte)c;
        }
        return c == 63 ? new String(xmlDecl, 0, read, unicodeEncoding) : null;
    }

    @Override
    public int describe(Reader input, IContentDescription description) throws IOException {
        BufferedReader reader = new BufferedReader(input);
        String line = reader.readLine();
        if (line == null) {
            return 1;
        }
        if (!line.startsWith(XML_PREFIX)) {
            return 1;
        }
        if (description == null) {
            return 2;
        }
        if (description.isRequested(IContentDescription.CHARSET)) {
            description.setProperty(IContentDescription.CHARSET, (Object)this.getCharset(line));
        }
        return 2;
    }

    private String getCharset(String firstLine) {
        int encodingPos = firstLine.indexOf(ENCODING);
        if (encodingPos == -1) {
            return null;
        }
        int quoteChar = 34;
        int firstQuote = firstLine.indexOf(quoteChar, encodingPos);
        if (firstQuote == -1) {
            quoteChar = 39;
            firstQuote = firstLine.indexOf(quoteChar, encodingPos);
        }
        if (firstQuote == -1 || firstLine.length() == firstQuote - 1) {
            return null;
        }
        int secondQuote = firstLine.indexOf(quoteChar, firstQuote + 1);
        if (secondQuote == -1) {
            return null;
        }
        return firstLine.substring(firstQuote + 1, secondQuote);
    }

    @Override
    public QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }
}

