/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.common.outline;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.jvmmodel.DispatchHelper;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.ide.common.outline.AbstractXtendOutlineTreeBuilder;
import org.eclipse.xtend.ide.common.outline.IXtendOutlineContext;
import org.eclipse.xtend.ide.common.outline.IXtendOutlineTreeBuilder;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class XtendOutlineSourceTreeBuilder
extends AbstractXtendOutlineTreeBuilder
implements IXtendOutlineTreeBuilder {
    @Inject
    @Extension
    private DispatchHelper dispatchHelper;

    protected void _build(XtendFile xtendFile, IXtendOutlineContext context) {
        this.buildPackageAndImportSection(xtendFile, context);
        Consumer<XtendTypeDeclaration> _function = it -> this.buildXtendType((XtendTypeDeclaration)it, context);
        xtendFile.getXtendTypes().forEach(_function);
    }

    protected void _build(XtendTypeDeclaration xtendType, IXtendOutlineContext context) {
        this.buildMembers(xtendType, this._iXtendJvmAssociations.getInferredType(xtendType), context);
    }

    protected void buildXtendType(XtendTypeDeclaration xtendType, IXtendOutlineContext context) {
        JvmDeclaredType inferredType = this._iXtendJvmAssociations.getInferredType(xtendType);
        IXtendOutlineContext xtendTypeContext = this.xtendOutlineNodeBuilder.buildXtendNode((EObject)xtendType, context).markAsProcessed((JvmMember)inferredType);
        this.buildMembers(xtendType, inferredType, xtendTypeContext);
    }

    protected void buildMembers(XtendTypeDeclaration xtendType, JvmDeclaredType inferredType, IXtendOutlineContext context) {
        if (inferredType != null) {
            IXtendOutlineContext membersContext = context.newContext();
            this.buildMembers(xtendType, inferredType, inferredType, membersContext);
        } else {
            Consumer<XtendMember> _function = it -> this.xtendOutlineNodeBuilder.buildEObjectNode((EObject)it, context);
            xtendType.getMembers().forEach(_function);
        }
    }

    protected void buildMembers(XtendTypeDeclaration xtendType, JvmDeclaredType inferredType, JvmDeclaredType baseType, @Extension IXtendOutlineContext context) {
        boolean _isShowInherited;
        if (xtendType != null) {
            EList _members = xtendType.getMembers();
            for (XtendMember member : _members) {
                boolean _not;
                EObject jvmElement = this._iXtendJvmAssociations.getPrimaryJvmElement((EObject)member);
                if (!(jvmElement instanceof JvmMember)) continue;
                boolean _isProcessed = context.isProcessed((JvmMember)jvmElement);
                boolean bl = _not = !_isProcessed;
                if (!_not) continue;
                if (member instanceof XtendTypeDeclaration) {
                    IXtendOutlineContext _xifexpression = null;
                    boolean _isShowInherited2 = context.isShowInherited();
                    _xifexpression = _isShowInherited2 ? context.newContext() : context;
                    this.buildXtendType((XtendTypeDeclaration)member, _xifexpression);
                } else if (jvmElement instanceof JvmFeature) {
                    boolean _not_1;
                    boolean _skipFeature = this.skipFeature((JvmFeature)jvmElement);
                    boolean bl2 = _not_1 = !_skipFeature;
                    if (_not_1) {
                        boolean _isDispatchRelated = this.isDispatchRelated((JvmFeature)jvmElement);
                        if (_isDispatchRelated) {
                            this.buildDispatchers(inferredType, baseType, context);
                        } else {
                            IXtendOutlineContext featureContext = this.buildFeature(inferredType, (JvmFeature)jvmElement, (EObject)member, context);
                            this.buildLocalClasses((JvmFeature)jvmElement, featureContext);
                        }
                    }
                }
                context.markAsProcessed((JvmMember)jvmElement);
            }
        }
        if (_isShowInherited = context.isShowInherited()) {
            this.buildInheritedMembers(inferredType, context);
        }
    }

    protected void buildLocalClasses(JvmFeature jvmFeature, IXtendOutlineContext context) {
        boolean _not;
        boolean _isEmpty = jvmFeature.getLocalClasses().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EList _localClasses = jvmFeature.getLocalClasses();
            for (JvmGenericType jvmGenericType : _localClasses) {
                IXtendOutlineContext typeContext = context.newContext();
                Set _sourceElements = this._iXtendJvmAssociations.getSourceElements((EObject)jvmGenericType);
                for (EObject sourceElement : _sourceElements) {
                    this.buildType(sourceElement, typeContext);
                }
            }
        }
    }

    protected void buildDispatchers(JvmDeclaredType inferredType, JvmDeclaredType baseType, IXtendOutlineContext context) {
        Functions.Function1 _function = it -> this.dispatchHelper.isDispatcherFunction(it);
        Iterable _filter = IterableExtensions.filter((Iterable)inferredType.getDeclaredOperations(), (Functions.Function1)_function);
        for (JvmOperation dispatcher : _filter) {
            List<JvmOperation> dispatchCases = this.getDispatchCases(dispatcher, baseType, context);
            IXtendOutlineContext dispatcherContext = this.xtendOutlineNodeBuilder.buildDispatcherNode(baseType, (JvmFeature)dispatcher, dispatchCases, context).markAsProcessed((JvmMember)dispatcher);
            for (JvmOperation dispatchCase : dispatchCases) {
                Object _elvis = null;
                XtendFunction _xtendFunction = this._iXtendJvmAssociations.getXtendFunction(dispatchCase);
                _elvis = _xtendFunction != null ? _xtendFunction : dispatchCase;
                this.buildFeature(baseType, (JvmFeature)dispatchCase, (EObject)_elvis, dispatcherContext).markAsProcessed((JvmMember)dispatchCase);
            }
        }
    }

    protected List<JvmOperation> getDispatchCases(JvmOperation dispatcher, JvmDeclaredType baseType, IXtendOutlineContext context) {
        List _xifexpression = null;
        boolean _isShowInherited = context.isShowInherited();
        if (_isShowInherited) {
            _xifexpression = this.dispatchHelper.getAllDispatchCases(dispatcher);
        } else {
            Comparator _function = (o1, o2) -> {
                int _indexOf = baseType.getMembers().indexOf(o1);
                int _indexOf_1 = baseType.getMembers().indexOf(o2);
                return _indexOf - _indexOf_1;
            };
            _xifexpression = IterableExtensions.sortWith((Iterable)this.dispatchHelper.getLocalDispatchCases(dispatcher), (Comparator)_function);
        }
        return _xifexpression;
    }

    protected boolean isDispatchRelated(JvmFeature feature) {
        boolean _xifexpression = false;
        if (feature instanceof JvmOperation) {
            _xifexpression = this.dispatchHelper.isDispatcherFunction((JvmOperation)feature) || this.dispatchHelper.isDispatchFunction((JvmOperation)feature);
        }
        return _xifexpression;
    }

    @Override
    protected void buildType(EObject someType, IXtendOutlineContext context) {
        if (someType instanceof XtendTypeDeclaration) {
            this.buildXtendType((XtendTypeDeclaration)someType, context);
        }
    }

    @Override
    @XbaseGenerated
    public void build(EObject xtendType, IXtendOutlineContext context) {
        if (xtendType instanceof XtendTypeDeclaration) {
            this._build((XtendTypeDeclaration)xtendType, context);
            return;
        }
        if (xtendType instanceof XtendFile) {
            this._build((XtendFile)xtendType, context);
            return;
        }
        if (xtendType != null) {
            this._build(xtendType, context);
            return;
        }
        if (xtendType == null) {
            this._build((Void)null, context);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(xtendType, context).toString());
    }
}

