/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Method;
import com.sun.jdi.Value;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaInterfaceType;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIReferenceType;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.core.model.JDIType;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;

public class JDIInterfaceType
extends JDIReferenceType
implements IJavaInterfaceType {
    public JDIInterfaceType(JDIDebugTarget target, InterfaceType type) {
        super(target, type);
    }

    @Override
    public IJavaClassType[] getImplementors() throws DebugException {
        try {
            List<ClassType> implementorList = ((InterfaceType)this.getUnderlyingType()).implementors();
            ArrayList<JDIType> javaClassTypeList = new ArrayList<JDIType>(implementorList.size());
            for (ClassType classType : implementorList) {
                if (classType == null) continue;
                javaClassTypeList.add(JDIType.createType(this.getJavaDebugTarget(), classType));
            }
            IJavaClassType[] javaClassTypeArray = new IJavaClassType[javaClassTypeList.size()];
            javaClassTypeArray = javaClassTypeList.toArray(javaClassTypeArray);
            return javaClassTypeArray;
        }
        catch (RuntimeException re) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIClassType_exception_while_retrieving_superclass, re.toString()), re);
            return new IJavaClassType[0];
        }
    }

    @Override
    public IJavaInterfaceType[] getSubInterfaces() throws DebugException {
        try {
            List<InterfaceType> subList = ((InterfaceType)this.getUnderlyingType()).subinterfaces();
            ArrayList<JDIType> javaInterfaceTypeList = new ArrayList<JDIType>(subList.size());
            for (InterfaceType interfaceType : subList) {
                if (interfaceType == null) continue;
                javaInterfaceTypeList.add(JDIType.createType(this.getJavaDebugTarget(), interfaceType));
            }
            IJavaInterfaceType[] javaInterfaceTypeArray = new IJavaInterfaceType[javaInterfaceTypeList.size()];
            javaInterfaceTypeArray = javaInterfaceTypeList.toArray(javaInterfaceTypeArray);
            return javaInterfaceTypeArray;
        }
        catch (RuntimeException re) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIClassType_exception_while_retrieving_superclass, re.toString()), re);
            return new IJavaInterfaceType[0];
        }
    }

    @Override
    public IJavaInterfaceType[] getSuperInterfaces() throws DebugException {
        try {
            List<InterfaceType> superList = ((InterfaceType)this.getUnderlyingType()).superinterfaces();
            ArrayList<JDIType> javaInterfaceTypeList = new ArrayList<JDIType>(superList.size());
            for (InterfaceType interfaceType : superList) {
                if (interfaceType == null) continue;
                javaInterfaceTypeList.add(JDIType.createType(this.getJavaDebugTarget(), interfaceType));
            }
            IJavaInterfaceType[] javaInterfaceTypeArray = new IJavaInterfaceType[javaInterfaceTypeList.size()];
            javaInterfaceTypeArray = javaInterfaceTypeList.toArray(javaInterfaceTypeArray);
            return javaInterfaceTypeArray;
        }
        catch (RuntimeException re) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIClassType_exception_while_retrieving_superclass, re.toString()), re);
            return new IJavaInterfaceType[0];
        }
    }

    @Override
    public IJavaValue sendMessage(String selector, String signature, IJavaValue[] args, IJavaThread thread) throws DebugException {
        if (this.getUnderlyingType() instanceof InterfaceType) {
            InterfaceType iface = (InterfaceType)this.getUnderlyingType();
            JDIThread javaThread = (JDIThread)thread;
            List<Value> arguments = this.convertArguments(args);
            Method method = null;
            try {
                List<Method> methods = iface.methodsByName(selector, signature);
                if (methods.isEmpty()) {
                    this.requestFailed(MessageFormat.format(JDIDebugModelMessages.JDIClassType_Type_does_not_implement_selector, selector, signature), null);
                } else {
                    method = methods.get(0);
                }
            }
            catch (RuntimeException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIClassType_exception_while_performing_method_lookup_for_selector, e.toString(), selector, signature), e);
            }
            Value result = javaThread.invokeMethod(iface, method, arguments);
            return JDIValue.createValue(this.getJavaDebugTarget(), result);
        }
        this.requestFailed(JDIDebugModelMessages.JDIClassType_Type_is_not_a_class_type, null);
        return null;
    }
}

