/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.launch;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.CoreTraceScopes;
import org.eclipse.buildship.core.internal.TraceScope;
import org.eclipse.buildship.core.internal.configuration.GradleProjectNature;
import org.eclipse.buildship.core.internal.i18n.CoreMessages;
import org.eclipse.buildship.core.internal.launch.GradleRunConfigurationAttributes;
import org.eclipse.buildship.core.internal.util.binding.Validator;
import org.eclipse.buildship.core.internal.util.binding.Validators;
import org.eclipse.buildship.ui.internal.PluginImage;
import org.eclipse.buildship.ui.internal.PluginImages;
import org.eclipse.buildship.ui.internal.launch.LaunchMessages;
import org.eclipse.buildship.ui.internal.util.gradle.GradleDistributionViewModel;
import org.eclipse.buildship.ui.internal.util.widget.GradleDistributionGroup;
import org.eclipse.buildship.ui.internal.util.widget.GradleProjectSettingsComposite;
import org.eclipse.buildship.ui.internal.util.widget.StringListEditor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public final class ProjectSettingsTab
extends AbstractLaunchConfigurationTab {
    private final Validator<GradleDistributionViewModel> distributionValidator = GradleDistributionViewModel.validator();
    private final Validator<File> gradleUserHomeValidator = Validators.optionalDirectoryValidator((String)CoreMessages.Preference_Label_Gradle_User_Home);
    private final Validator<File> javaHomeValidator = Validators.optionalDirectoryValidator((String)CoreMessages.Preference_Label_Java_Home);
    private GradleRunConfigurationAttributes attributes;
    private GradleProjectSettingsComposite gradleProjectSettingsComposite;

    public String getName() {
        return LaunchMessages.Tab_Name_ProjectSettings;
    }

    public Image getImage() {
        return PluginImages.RUN_CONFIG_GRADLE_DISTRIBUTION.withState(PluginImage.ImageState.ENABLED).getImage();
    }

    public void createControl(Composite parent) {
        this.gradleProjectSettingsComposite = GradleProjectSettingsComposite.builder(parent).withOverrideCheckbox(CoreMessages.RunConfiguration_Label_OverrideProjectSettings, "Configure Project Settings").showVariableSelector().build();
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)this.gradleProjectSettingsComposite);
        this.setControl((Control)this.gradleProjectSettingsComposite);
        this.addListeners();
    }

    private void addListeners() {
        DialogUpdater dialogUpdater = new DialogUpdater();
        this.gradleProjectSettingsComposite.getOverrideBuildSettingsCheckbox().addSelectionListener((SelectionListener)dialogUpdater);
        this.gradleProjectSettingsComposite.getOfflineModeCheckbox().addSelectionListener((SelectionListener)dialogUpdater);
        this.gradleProjectSettingsComposite.getBuildScansCheckbox().addSelectionListener((SelectionListener)dialogUpdater);
        this.gradleProjectSettingsComposite.getGradleDistributionGroup().addDistributionChangedListener(dialogUpdater);
        this.gradleProjectSettingsComposite.getAdvancedOptionsGroup().getGradleUserHomeText().addModifyListener((ModifyListener)dialogUpdater);
        this.gradleProjectSettingsComposite.getAdvancedOptionsGroup().getJavaHomeText().addModifyListener((ModifyListener)dialogUpdater);
        this.gradleProjectSettingsComposite.getAdvancedOptionsGroup().getArgumentsEditor().addChangeListener(dialogUpdater);
        this.gradleProjectSettingsComposite.getAdvancedOptionsGroup().getJvmArgumentsEditor().addChangeListener(dialogUpdater);
        this.gradleProjectSettingsComposite.getShowConsoleViewCheckbox().addSelectionListener((SelectionListener)dialogUpdater);
        this.gradleProjectSettingsComposite.getShowConsoleViewCheckbox().addSelectionListener((SelectionListener)dialogUpdater);
        this.gradleProjectSettingsComposite.getShowExecutionsViewCheckbox().addSelectionListener((SelectionListener)dialogUpdater);
        this.gradleProjectSettingsComposite.getParentPreferenceLink().addSelectionListener((SelectionListener)new ProjectPreferenceOpeningSelectionListener());
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.attributes = GradleRunConfigurationAttributes.from((ILaunchConfiguration)configuration);
        this.gradleProjectSettingsComposite.getOverrideBuildSettingsCheckbox().setSelection(this.attributes.isOverrideBuildSettings());
        this.gradleProjectSettingsComposite.getGradleDistributionGroup().setDistribution(GradleDistributionViewModel.from(this.attributes.getGradleDistribution()));
        this.gradleProjectSettingsComposite.getAdvancedOptionsGroup().getGradleUserHomeText().setText(Strings.nullToEmpty((String)this.attributes.getGradleUserHomeHomeExpression()));
        this.gradleProjectSettingsComposite.getAdvancedOptionsGroup().getJavaHomeText().setText(Strings.nullToEmpty((String)this.attributes.getJavaHomeExpression()));
        this.gradleProjectSettingsComposite.getAdvancedOptionsGroup().setArguments((List<String>)this.attributes.getArgumentExpressions());
        this.gradleProjectSettingsComposite.getAdvancedOptionsGroup().setJvmArguments((List<String>)this.attributes.getJvmArgumentExpressions());
        this.gradleProjectSettingsComposite.getOfflineModeCheckbox().setSelection(this.attributes.isOffline());
        this.gradleProjectSettingsComposite.getBuildScansCheckbox().setSelection(this.attributes.isBuildScansEnabled());
        this.gradleProjectSettingsComposite.getShowConsoleViewCheckbox().setSelection(this.attributes.isShowConsoleView());
        this.gradleProjectSettingsComposite.getShowExecutionsViewCheckbox().setSelection(this.attributes.isShowExecutionView());
        this.gradleProjectSettingsComposite.updateEnablement();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        GradleRunConfigurationAttributes.applyOverrideBuildSettings((boolean)this.gradleProjectSettingsComposite.getOverrideBuildSettingsCheckbox().getSelection(), (ILaunchConfigurationWorkingCopy)configuration);
        GradleRunConfigurationAttributes.applyGradleDistribution((GradleDistribution)this.gradleProjectSettingsComposite.getGradleDistributionGroup().getDistribution().toGradleDistribution(), (ILaunchConfigurationWorkingCopy)configuration);
        GradleRunConfigurationAttributes.applyGradleUserHomeExpression((String)this.gradleProjectSettingsComposite.getAdvancedOptionsGroup().getGradleUserHomeText().getText(), (ILaunchConfigurationWorkingCopy)configuration);
        GradleRunConfigurationAttributes.applyJavaHomeExpression((String)this.gradleProjectSettingsComposite.getAdvancedOptionsGroup().getJavaHomeText().getText(), (ILaunchConfigurationWorkingCopy)configuration);
        GradleRunConfigurationAttributes.applyArgumentExpressions(this.gradleProjectSettingsComposite.getAdvancedOptionsGroup().getArguments(), (ILaunchConfigurationWorkingCopy)configuration);
        GradleRunConfigurationAttributes.applyJvmArgumentExpressions(this.gradleProjectSettingsComposite.getAdvancedOptionsGroup().getJvmArguments(), (ILaunchConfigurationWorkingCopy)configuration);
        GradleRunConfigurationAttributes.applyOfflineMode((boolean)this.gradleProjectSettingsComposite.getOfflineModeCheckbox().getSelection(), (ILaunchConfigurationWorkingCopy)configuration);
        GradleRunConfigurationAttributes.applyBuildScansEnabled((boolean)this.gradleProjectSettingsComposite.getBuildScansCheckbox().getSelection(), (ILaunchConfigurationWorkingCopy)configuration);
        GradleRunConfigurationAttributes.applyShowConsoleView((boolean)this.gradleProjectSettingsComposite.getShowConsoleViewCheckbox().getSelection(), (ILaunchConfigurationWorkingCopy)configuration);
        GradleRunConfigurationAttributes.applyShowExecutionView((boolean)this.gradleProjectSettingsComposite.getShowExecutionsViewCheckbox().getSelection(), (ILaunchConfigurationWorkingCopy)configuration);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        GradleDistributionViewModel distribution = this.gradleProjectSettingsComposite.getGradleDistributionGroup().getDistribution();
        Optional error = this.distributionValidator.validate((Object)distribution);
        if (!error.isPresent()) {
            error = this.gradleUserHomeValidator.validate((Object)this.gradleProjectSettingsComposite.getAdvancedOptionsGroup().getGradleUserHome());
        }
        if (!error.isPresent()) {
            error = this.javaHomeValidator.validate((Object)this.gradleProjectSettingsComposite.getAdvancedOptionsGroup().getJavaHome());
        }
        this.setErrorMessage((String)error.orNull());
        return !error.isPresent();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    private class DialogUpdater
    extends SelectionAdapter
    implements ModifyListener,
    GradleDistributionGroup.DistributionChangedListener,
    StringListEditor.StringListChangeListener {
        private DialogUpdater() {
        }

        public void widgetSelected(SelectionEvent e) {
            ProjectSettingsTab.this.updateLaunchConfigurationDialog();
        }

        public void modifyText(ModifyEvent e) {
            ProjectSettingsTab.this.updateLaunchConfigurationDialog();
        }

        @Override
        public void distributionUpdated(GradleDistributionViewModel distributionViewModel) {
            ProjectSettingsTab.this.updateLaunchConfigurationDialog();
        }

        @Override
        public void onChange() {
            ProjectSettingsTab.this.updateLaunchConfigurationDialog();
        }
    }

    private class ProjectPreferenceOpeningSelectionListener
    implements SelectionListener {
        private ProjectPreferenceOpeningSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.openWorkspacePreferences();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.openWorkspacePreferences();
        }

        private void openWorkspacePreferences() {
            try {
                File workingDir = ProjectSettingsTab.this.attributes.getWorkingDir();
                Optional project = CorePlugin.workspaceOperations().findProjectByLocation(workingDir);
                if (project.isPresent() && GradleProjectNature.isPresentOn((IProject)((IProject)project.get()))) {
                    PreferencesUtil.createPropertyDialogOn((Shell)ProjectSettingsTab.this.getShell(), (IAdaptable)((IAdaptable)project.get()), (String)"org.eclipse.buildship.ui.projectproperties", null, null).open();
                }
            }
            catch (Exception e) {
                CorePlugin.logger().trace((TraceScope)CoreTraceScopes.PREFERENCES, "Cannot open project preferences", (Throwable)e);
            }
        }
    }
}

