/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.execution;

import java.text.DecimalFormat;
import org.eclipse.buildship.ui.internal.view.execution.ExecutionViewMessages;
import org.eclipse.buildship.ui.internal.view.execution.OperationItem;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.NLS;
import org.gradle.tooling.events.OperationResult;

public final class ExecutionPageDurationLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private final DecimalFormat durationFormat = new DecimalFormat("#0.000");
    private final String zeroDuration = NLS.bind((String)ExecutionViewMessages.Tree_Item_Operation_Finished_In_0_Sec_Text, (Object)this.durationFormat.format(0L));

    public StyledString getStyledText(Object element) {
        return new StyledString(element instanceof OperationItem ? this.calculateDuration((OperationItem)element) : "");
    }

    private String calculateDuration(OperationItem operationItem) {
        if (operationItem.getFinishEvent() != null) {
            OperationResult result = operationItem.getFinishEvent().getResult();
            String duration = this.formatDuration(result.getStartTime(), result.getEndTime());
            return NLS.bind((String)ExecutionViewMessages.Tree_Item_Operation_Finished_In_0_Sec_Text, (Object)duration);
        }
        if (operationItem.getStartEvent() != null) {
            String duration = this.formatDuration(operationItem.getStartEvent().getEventTime(), System.currentTimeMillis());
            return NLS.bind((String)ExecutionViewMessages.Tree_Item_Operation_Running_For_0_Sec_Text, (Object)duration);
        }
        return this.zeroDuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatDuration(long startTime, long endTime) {
        DecimalFormat decimalFormat = this.durationFormat;
        synchronized (decimalFormat) {
            return this.durationFormat.format((double)(endTime - startTime) / 1000.0);
        }
    }
}

