/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractTaskRepositoryLinkProvider;
import org.osgi.service.prefs.BackingStoreException;

public class ProjectPropertiesLinkProvider
extends AbstractTaskRepositoryLinkProvider {
    private static final String PROPERTY_PREFIX = "project.repository";
    private static final String PROJECT_REPOSITORY_KIND = "project.repository.kind";
    private static final String PROJECT_REPOSITORY_URL = "project.repository.url";

    @Override
    public TaskRepository getTaskRepository(IResource resource, IRepositoryManager repositoryManager) {
        IProject project = resource.getProject();
        if (project == null || !project.isAccessible()) {
            return null;
        }
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.mylyn.tasks.ui");
        if (projectNode != null) {
            String kind = projectNode.get(PROJECT_REPOSITORY_KIND, "");
            String urlString = projectNode.get(PROJECT_REPOSITORY_URL, "");
            return repositoryManager.getRepository(kind, urlString);
        }
        return null;
    }

    @Override
    public boolean canSetTaskRepository(IResource resource) {
        IProject project = resource.getProject();
        return project != null && project.isAccessible();
    }

    @Override
    public boolean setTaskRepository(IResource resource, TaskRepository repository) {
        IProject project = resource.getProject();
        if (project == null || !project.isAccessible()) {
            return false;
        }
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.mylyn.tasks.ui");
        if (projectNode != null) {
            if (repository != null) {
                projectNode.put(PROJECT_REPOSITORY_KIND, repository.getConnectorKind());
                projectNode.put(PROJECT_REPOSITORY_URL, repository.getRepositoryUrl());
            } else {
                projectNode.remove(PROJECT_REPOSITORY_KIND);
                projectNode.remove(PROJECT_REPOSITORY_URL);
            }
            try {
                projectNode.flush();
                return true;
            }
            catch (BackingStoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to save task repository to project association preference", (Throwable)e));
            }
        }
        return false;
    }
}

