/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.RegistryReader;

public class EditorRegistryReader
extends RegistryReader {
    private EditorRegistry editorRegistry;

    protected void addEditors(EditorRegistry registry) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        this.editorRegistry = registry;
        this.readRegistry(extensionRegistry, "org.eclipse.ui", "editors");
    }

    @Override
    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equals("editor")) {
            return this.readEditorElement(element);
        }
        if (element.getName().equals("editorContentTypeBinding")) {
            return this.readEditorContentTypeBinding(element);
        }
        return false;
    }

    private boolean readEditorContentTypeBinding(IConfigurationElement element) {
        IEditorDescriptor descriptor = null;
        String editorId = element.getAttribute("editorId");
        if (editorId == null) {
            EditorRegistryReader.logMissingAttribute(element, "editorId");
        } else {
            descriptor = this.editorRegistry.findEditor(editorId);
            if (descriptor == null) {
                EditorRegistryReader.logError(element, "Unknown editor with id: " + editorId);
            }
        }
        IContentType contentType = null;
        String contentTypeId = element.getAttribute("contentTypeId");
        if (contentTypeId == null) {
            EditorRegistryReader.logMissingAttribute(element, "contentTypeId");
        } else {
            contentType = Platform.getContentTypeManager().getContentType(contentTypeId);
            if (contentType == null) {
                EditorRegistryReader.logError(element, "Unknown content-type with id: " + contentTypeId);
            }
        }
        if (descriptor != null && contentType != null) {
            this.editorRegistry.addContentTypeBindingFromPlugin(contentType, descriptor, false);
        }
        return true;
    }

    private boolean readEditorElement(IConfigurationElement element) {
        IConfigurationElement[] bindings;
        String filenamesString;
        String id = element.getAttribute("id");
        if (id == null) {
            EditorRegistryReader.logMissingAttribute(element, "id");
            return true;
        }
        EditorDescriptor editor = new EditorDescriptor(id, element);
        ArrayList<String> extensionsVector = new ArrayList<String>();
        ArrayList<String> filenamesVector = new ArrayList<String>();
        ArrayList<String> contentTypeVector = new ArrayList<String>();
        boolean defaultEditor = false;
        if (element.getAttribute("name") == null) {
            EditorRegistryReader.logMissingAttribute(element, "name");
            return true;
        }
        String extensionsString = element.getAttribute("extensions");
        if (extensionsString != null) {
            StringTokenizer tokenizer = new StringTokenizer(extensionsString, ",");
            while (tokenizer.hasMoreTokens()) {
                extensionsVector.add(tokenizer.nextToken().trim());
            }
        }
        if ((filenamesString = element.getAttribute("filenames")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(filenamesString, ",");
            while (tokenizer.hasMoreTokens()) {
                filenamesVector.add(tokenizer.nextToken().trim());
            }
        }
        IConfigurationElement[] iConfigurationElementArray = bindings = element.getChildren("contentTypeBinding");
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement binding = iConfigurationElementArray[n2];
            String contentTypeId = binding.getAttribute("contentTypeId");
            if (contentTypeId != null) {
                contentTypeVector.add(contentTypeId);
            }
            ++n2;
        }
        String def = element.getAttribute("default");
        if (def != null) {
            defaultEditor = Boolean.parseBoolean(def);
        }
        this.editorRegistry.addEditorFromPlugin(editor, extensionsVector, filenamesVector, contentTypeVector, defaultEditor);
        return true;
    }

    public void readElement(EditorRegistry editorRegistry, IConfigurationElement element) {
        this.editorRegistry = editorRegistry;
        this.readElement(element);
    }
}

