/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Win32DPIUtils;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;

public final class Region
extends Resource {
    private Map<Integer, RegionHandle> zoomToHandle = new HashMap<Integer, RegionHandle>();
    private List<Operation> operations = new ArrayList<Operation>();
    private boolean isDestroyed;
    private int temporaryHandleZoomHint = 0;

    public Region() {
        this(null);
    }

    public Region(Device device) {
        super(device);
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public void add(int[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        OperationWithArray operation = new OperationWithArray(Operation::add, Arrays.copyOf(pointArray, pointArray.length));
        this.storeAndApplyOperationForAllHandles(operation);
    }

    public void add(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        OperationWithRectangle operation = new OperationWithRectangle(Operation::add, new Rectangle(rect.x, rect.y, rect.width, rect.height));
        this.storeAndApplyOperationForAllHandles(operation);
    }

    public void add(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OperationWithRectangle operation = new OperationWithRectangle(Operation::add, new Rectangle(x, y, width, height));
        this.storeAndApplyOperationForAllHandles(operation);
    }

    public void add(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        if (!region.operations.isEmpty()) {
            this.adoptTemporaryHandleZoomHint(region);
            OperationWithRegion operation = new OperationWithRegion(Operation::add, region.operations);
            this.storeAndApplyOperationForAllHandles(operation);
        }
    }

    private void adoptTemporaryHandleZoomHint(Region region) {
        if (this.temporaryHandleZoomHint == 0 && region.temporaryHandleZoomHint != 0) {
            this.temporaryHandleZoomHint = region.temporaryHandleZoomHint;
        }
    }

    public boolean contains(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.applyUsingAnyHandle(regionHandle -> {
            int zoom = regionHandle.zoom();
            int xInPixels = Win32DPIUtils.pointToPixel(x, zoom);
            int yInPixels = Win32DPIUtils.pointToPixel(y, zoom);
            return this.containsInPixels(regionHandle.handle(), xInPixels, yInPixels);
        });
    }

    boolean containsInPixels(long handle, int x, int y) {
        return OS.PtInRegion(handle, x, y);
    }

    public boolean contains(Point pt) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pt == null) {
            SWT.error(4);
        }
        return this.applyUsingAnyHandle(regionHandle -> {
            int zoom = regionHandle.zoom();
            Point p = Win32DPIUtils.pointToPixel(pt, zoom);
            return this.containsInPixels(regionHandle.handle(), p.x, p.y);
        });
    }

    @Override
    void destroy() {
        this.device.deregisterResourceWithZoomSupport(this);
        this.zoomToHandle.values().forEach(RegionHandle::destroy);
        this.zoomToHandle.clear();
        this.operations.clear();
        this.isDestroyed = true;
    }

    @Override
    void destroyHandlesExcept(Set<Integer> zoomLevels) {
        this.zoomToHandle.entrySet().removeIf(entry -> {
            Integer zoom = (Integer)entry.getKey();
            if (!zoomLevels.contains(zoom)) {
                ((RegionHandle)entry.getValue()).destroy();
                return true;
            }
            return false;
        });
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.applyUsingAnyHandle(regionHandle -> Win32DPIUtils.pixelToPoint(this.getBoundsInPixels(regionHandle.handle()), regionHandle.zoom()));
    }

    private Rectangle getBoundsInPixels(long handle) {
        RECT rect = new RECT();
        OS.GetRgnBox(handle, rect);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void intersect(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        OperationWithRectangle operation = new OperationWithRectangle(Operation::intersect, new Rectangle(rect.x, rect.y, rect.width, rect.height));
        this.storeAndApplyOperationForAllHandles(operation);
    }

    public void intersect(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OperationWithRectangle operation = new OperationWithRectangle(Operation::intersect, new Rectangle(x, y, width, height));
        this.storeAndApplyOperationForAllHandles(operation);
    }

    public void intersect(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        if (!region.operations.isEmpty()) {
            this.adoptTemporaryHandleZoomHint(region);
            OperationWithRegion operation = new OperationWithRegion(Operation::intersect, region.operations);
            this.storeAndApplyOperationForAllHandles(operation);
        }
    }

    public boolean intersects(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.intersects(new Rectangle(x, y, width, height));
    }

    boolean intersectsInPixels(long handle, int x, int y, int width, int height) {
        RECT r = new RECT();
        OS.SetRect(r, x, y, x + width, y + height);
        return OS.RectInRegion(handle, r);
    }

    public boolean intersects(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        return this.applyUsingAnyHandle(regionHandle -> {
            Rectangle r = Win32DPIUtils.pointToPixel(rect, regionHandle.zoom());
            return this.intersectsInPixels(regionHandle.handle(), r.x, r.y, r.width, r.height);
        });
    }

    @Override
    public boolean isDisposed() {
        return this.isDestroyed;
    }

    public boolean isEmpty() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        RECT rect = new RECT();
        return this.applyUsingAnyHandle(regionHandle -> {
            int result = OS.GetRgnBox(regionHandle.handle(), rect);
            if (result == 1) {
                return true;
            }
            if (rECT.right - rECT.left > 0 && rECT.bottom - rECT.top > 0) {
                return false;
            }
            return true;
        });
    }

    void set(Function<Integer, Long> handleForZoomSupplier, int contextZoom) {
        this.temporaryHandleZoomHint = contextZoom;
        OperationWithRegionHandle operation = new OperationWithRegionHandle(Operation::set, handleForZoomSupplier);
        this.storeAndApplyOperationForAllHandles(operation);
    }

    public void subtract(int[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        OperationWithArray operation = new OperationWithArray(Operation::subtract, Arrays.copyOf(pointArray, pointArray.length));
        this.storeAndApplyOperationForAllHandles(operation);
    }

    public void subtract(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        OperationWithRectangle operation = new OperationWithRectangle(Operation::subtract, new Rectangle(rect.x, rect.y, rect.width, rect.height));
        this.storeAndApplyOperationForAllHandles(operation);
    }

    public void subtract(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OperationWithRectangle operation = new OperationWithRectangle(Operation::subtract, new Rectangle(x, y, width, height));
        this.storeAndApplyOperationForAllHandles(operation);
    }

    public void subtract(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        if (!region.operations.isEmpty()) {
            this.adoptTemporaryHandleZoomHint(region);
            OperationWithRegion operation = new OperationWithRegion(Operation::subtract, region.operations);
            this.storeAndApplyOperationForAllHandles(operation);
        }
    }

    public void translate(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OperationWithPoint operation = new OperationWithPoint(Operation::translate, new Point(x, y));
        this.storeAndApplyOperationForAllHandles(operation);
    }

    public void translate(Point pt) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pt == null) {
            SWT.error(4);
        }
        OperationWithPoint operation = new OperationWithPoint(Operation::translate, new Point(pt.x, pt.y));
        this.storeAndApplyOperationForAllHandles(operation);
    }

    private void storeAndApplyOperationForAllHandles(Operation operation) {
        this.operations.add(operation);
        this.zoomToHandle.forEach((zoom, handle) -> operation.apply((RegionHandle)handle));
    }

    private <T> T applyUsingAnyHandle(Function<RegionHandle, T> function) {
        if (this.zoomToHandle.isEmpty()) {
            int temporaryHandleZoom = this.temporaryHandleZoomHint != 0 ? this.temporaryHandleZoomHint : this.device.getDeviceZoom();
            return Region.applyUsingTemporaryHandle(temporaryHandleZoom, this.operations, function);
        }
        return function.apply(this.zoomToHandle.values().iterator().next());
    }

    private static <T> T applyUsingTemporaryHandle(int zoom, List<Operation> operations, Function<RegionHandle, T> function) {
        RegionHandle temporaryHandle = Region.newRegionHandle(zoom, operations);
        try {
            T t = function.apply(temporaryHandle);
            return t;
        }
        finally {
            temporaryHandle.destroy();
        }
    }

    private static RegionHandle newRegionHandle(int zoom, List<Operation> operations) {
        long newHandle = OS.CreateRectRgn(0, 0, 0, 0);
        if (newHandle == 0L) {
            SWT.error(2);
        }
        RegionHandle newRegionHandle = new RegionHandle(newHandle, zoom);
        for (Operation operation : operations) {
            operation.apply(newRegionHandle);
        }
        return newRegionHandle;
    }

    private RegionHandle getRegionHandle(int zoom) {
        if (!this.zoomToHandle.containsKey(zoom)) {
            RegionHandle regionHandle = Region.newRegionHandle(zoom, this.operations);
            this.zoomToHandle.put(zoom, regionHandle);
        }
        return this.zoomToHandle.get(zoom);
    }

    Region copy() {
        Region region = new Region();
        region.temporaryHandleZoomHint = this.temporaryHandleZoomHint;
        region.operations.addAll(this.operations);
        return region;
    }

    public static long win32_getHandle(Region region, int zoom) {
        return region.getRegionHandle(zoom).handle();
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.zoomToHandle.entrySet().stream().map(entry -> String.valueOf(entry.getValue()) + "(zoom:" + String.valueOf(entry.getKey()) + ")").collect(Collectors.joining(","));
    }

    private static abstract class Operation {
        private final OperationStrategy operationStrategy;

        Operation(OperationStrategy operationStrategy) {
            this.operationStrategy = operationStrategy;
        }

        void apply(RegionHandle regionHandle) {
            this.operationStrategy.apply(this, regionHandle.handle(), regionHandle.zoom());
        }

        abstract void set(long var1, int var3);

        abstract void add(long var1, int var3);

        abstract void subtract(long var1, int var3);

        abstract void intersect(long var1, int var3);

        abstract void translate(long var1, int var3);
    }

    @FunctionalInterface
    private static interface OperationStrategy {
        public void apply(Operation var1, long var2, int var4);
    }

    private static class OperationWithArray
    extends Operation {
        private final int[] data;

        public OperationWithArray(OperationStrategy operationStrategy, int[] data) {
            super(operationStrategy);
            this.data = data;
        }

        @Override
        void set(long handle, int zoom) {
            throw new UnsupportedOperationException();
        }

        @Override
        void add(long handle, int zoom) {
            int[] points = this.getScaledPoints(zoom);
            this.addInPixels(handle, points);
        }

        @Override
        void subtract(long handle, int zoom) {
            int[] pointArray = this.getScaledPoints(zoom);
            this.subtractInPixels(handle, pointArray);
        }

        @Override
        void intersect(long handle, int zoom) {
            throw new UnsupportedOperationException();
        }

        @Override
        void translate(long handle, int zoom) {
            throw new UnsupportedOperationException();
        }

        private void addInPixels(long handle, int[] pointArray) {
            long polyRgn = OS.CreatePolygonRgn(pointArray, pointArray.length / 2, 1);
            OS.CombineRgn(handle, handle, polyRgn, 2);
            OS.DeleteObject(polyRgn);
        }

        private void subtractInPixels(long handle, int[] pointArray) {
            long polyRgn = OS.CreatePolygonRgn(pointArray, pointArray.length / 2, 1);
            OS.CombineRgn(handle, handle, polyRgn, 4);
            OS.DeleteObject(polyRgn);
        }

        private int[] getScaledPoints(int zoom) {
            return Win32DPIUtils.pointToPixel(this.data, zoom);
        }
    }

    private static class OperationWithPoint
    extends Operation {
        private final Point data;

        public OperationWithPoint(OperationStrategy operationStrategy, Point data) {
            super(operationStrategy);
            this.data = data;
        }

        @Override
        void set(long handle, int zoom) {
            throw new UnsupportedOperationException();
        }

        @Override
        void add(long handle, int zoom) {
            throw new UnsupportedOperationException();
        }

        @Override
        void subtract(long handle, int zoom) {
            throw new UnsupportedOperationException();
        }

        @Override
        void intersect(long handle, int zoom) {
            throw new UnsupportedOperationException();
        }

        @Override
        void translate(long handle, int zoom) {
            Point pt = Win32DPIUtils.pointToPixel(this.data, zoom);
            OS.OffsetRgn(handle, pt.x, pt.y);
        }
    }

    private static class OperationWithRectangle
    extends Operation {
        private final Rectangle data;

        OperationWithRectangle(OperationStrategy operationStrategy, Rectangle data) {
            super(operationStrategy);
            this.data = data;
        }

        @Override
        void set(long handle, int zoom) {
            throw new UnsupportedOperationException();
        }

        @Override
        void add(long handle, int zoom) {
            Rectangle bounds = this.getScaledRectangle(zoom);
            this.addInPixels(handle, bounds.x, bounds.y, bounds.width, bounds.height);
        }

        @Override
        void subtract(long handle, int zoom) {
            Rectangle bounds = this.getScaledRectangle(zoom);
            this.subtractInPixels(handle, bounds.x, bounds.y, bounds.width, bounds.height);
        }

        @Override
        void intersect(long handle, int zoom) {
            Rectangle bounds = this.getScaledRectangle(zoom);
            this.intersectInPixels(handle, bounds.x, bounds.y, bounds.width, bounds.height);
        }

        @Override
        void translate(long handle, int zoom) {
            throw new UnsupportedOperationException();
        }

        private void addInPixels(long handle, int x, int y, int width, int height) {
            if (width < 0 || height < 0) {
                SWT.error(5);
            }
            long rectRgn = OS.CreateRectRgn(x, y, x + width, y + height);
            OS.CombineRgn(handle, handle, rectRgn, 2);
            OS.DeleteObject(rectRgn);
        }

        private void subtractInPixels(long handle, int x, int y, int width, int height) {
            if (width < 0 || height < 0) {
                SWT.error(5);
            }
            long rectRgn = OS.CreateRectRgn(x, y, x + width, y + height);
            OS.CombineRgn(handle, handle, rectRgn, 4);
            OS.DeleteObject(rectRgn);
        }

        private void intersectInPixels(long handle, int x, int y, int width, int height) {
            if (width < 0 || height < 0) {
                SWT.error(5);
            }
            long rectRgn = OS.CreateRectRgn(x, y, x + width, y + height);
            OS.CombineRgn(handle, handle, rectRgn, 1);
            OS.DeleteObject(rectRgn);
        }

        private Rectangle getScaledRectangle(int zoom) {
            return Win32DPIUtils.pointToPixel(this.data, zoom);
        }
    }

    private static class OperationWithRegion
    extends Operation {
        private final List<Operation> operations;

        OperationWithRegion(OperationStrategy operationStrategy, List<Operation> operations) {
            super(operationStrategy);
            this.operations = List.copyOf(operations);
        }

        @Override
        void set(long handle, int zoom) {
            throw new UnsupportedOperationException();
        }

        @Override
        void add(long handle, int zoom) {
            Region.applyUsingTemporaryHandle(zoom, this.operations, regionHandle -> OS.CombineRgn(handle, handle, regionHandle.handle(), 2));
        }

        @Override
        void subtract(long handle, int zoom) {
            Region.applyUsingTemporaryHandle(zoom, this.operations, regionHandle -> OS.CombineRgn(handle, handle, regionHandle.handle(), 4));
        }

        @Override
        void intersect(long handle, int zoom) {
            Region.applyUsingTemporaryHandle(zoom, this.operations, regionHandle -> OS.CombineRgn(handle, handle, regionHandle.handle(), 1));
        }

        @Override
        void translate(long handle, int zoom) {
            throw new UnsupportedOperationException();
        }
    }

    private static class OperationWithRegionHandle
    extends Operation {
        private final Function<Integer, Long> handleForZoomProvider;

        OperationWithRegionHandle(OperationStrategy operationStrategy, Function<Integer, Long> handleForZoomSupplier) {
            super(operationStrategy);
            this.handleForZoomProvider = handleForZoomSupplier;
        }

        @Override
        void set(long handle, int zoom) {
            OS.CombineRgn(handle, this.handleForZoomProvider.apply(zoom), 0L, 5);
        }

        @Override
        void subtract(long handle, int zoom) {
            throw new UnsupportedOperationException();
        }

        @Override
        void intersect(long handle, int zoom) {
            throw new UnsupportedOperationException();
        }

        @Override
        void translate(long handle, int zoom) {
            throw new UnsupportedOperationException();
        }

        @Override
        void add(long handle, int zoom) {
            throw new UnsupportedOperationException();
        }
    }

    private record RegionHandle(long handle, int zoom) {
        void destroy() {
            OS.DeleteObject(this.handle());
        }
    }
}

