/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.imports;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.java.generator.compilationunit.ICompilationUnitGenerator;
import org.eclipse.scout.sdk.core.java.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.java.imports.IImportCollector;
import org.eclipse.scout.sdk.core.java.imports.TypeReferenceDescriptor;
import org.eclipse.scout.sdk.core.java.imports.WrappedImportCollector;
import org.eclipse.scout.sdk.core.java.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.util.Strings;

public class CompilationUnitScopedImportCollector
extends WrappedImportCollector {
    private final String m_packageName;
    private final Map<String, Boolean> m_existsInSamePackageCache = new HashMap<String, Boolean>();

    public CompilationUnitScopedImportCollector(IImportCollector inner, String packageName) {
        this(inner, packageName, null);
    }

    public CompilationUnitScopedImportCollector(IImportCollector inner, String packageName, ICompilationUnitGenerator<?> cuGenerator) {
        super(inner);
        this.m_packageName = packageName;
        if (cuGenerator != null) {
            this.consumeAllTypeNamesRec(cuGenerator.types());
            this.registerImports(cuGenerator);
        }
    }

    protected void registerImports(ICompilationUnitGenerator<?> cuGenerator) {
        cuGenerator.imports().forEach(this::addImport);
        cuGenerator.staticImports().forEach(this::addStaticImport);
    }

    protected void consumeAllTypeNamesRec(Stream<ITypeGenerator<?>> stream) {
        stream.peek(g -> this.consumeAllTypeNamesRec(g.types())).map(ITypeGenerator::fullyQualifiedName).map(TypeReferenceDescriptor::new).forEach(this::reserveElement);
    }

    @Override
    public String getQualifier() {
        return this.m_packageName;
    }

    @Override
    public String checkCurrentScope(TypeReferenceDescriptor candidate) {
        String q = this.getQualifier();
        if (Objects.equals(q, candidate.getQualifier()) || Strings.isBlank((CharSequence)q) && Strings.isBlank((CharSequence)candidate.getQualifier())) {
            return candidate.getSimpleName();
        }
        IJavaEnvironment env = this.getJavaEnvironment().orElse(null);
        if (env == null) {
            return super.checkCurrentScope(candidate);
        }
        boolean existsInSamePackage = this.m_existsInSamePackageCache.computeIfAbsent(candidate.getSimpleName(), simpleName -> env.exists(Strings.isEmpty((CharSequence)q) ? simpleName : new StringBuilder((CharSequence)q).append('.').append((String)simpleName).toString()));
        if (existsInSamePackage) {
            return candidate.getQualifiedName();
        }
        return super.checkCurrentScope(candidate);
    }
}

