/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class JarUtils {
    private JarUtils() {
    }

    public static void createJarFile(Path jarfile, Manifest man, Path dir, Path ... files) throws IOException {
        Path parent = jarfile.getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        List<Path> entries = JarUtils.findAllRegularFiles(dir, files);
        try (OutputStream out = Files.newOutputStream(jarfile, new OpenOption[0]);
             JarOutputStream jos = new JarOutputStream(out);){
            if (man != null) {
                JarEntry je = new JarEntry("META-INF/MANIFEST.MF");
                jos.putNextEntry(je);
                man.write(jos);
                jos.closeEntry();
            }
            for (Path entry : entries) {
                String name = JarUtils.toJarEntryName(entry);
                jos.putNextEntry(new JarEntry(name));
                Files.copy(dir.resolve(entry), jos);
                jos.closeEntry();
            }
        }
    }

    public static void createJarFile(Path jarfile, Path dir, Path ... files) throws IOException {
        JarUtils.createJarFile(jarfile, null, dir, files);
    }

    public static void createJarFile(Path jarfile, Path dir) throws IOException {
        JarUtils.createJarFile(jarfile, dir, Paths.get(".", new String[0]));
    }

    public static void createJarFile(Path jarfile, Path dir, String ... input) throws IOException {
        Path[] paths = (Path[])Stream.of(input).map(x$0 -> Paths.get(x$0, new String[0])).toArray(Path[]::new);
        JarUtils.createJarFile(jarfile, dir, paths);
    }

    public static void updateJarFile(Path jarfile, Path dir, Path ... files) throws IOException {
        List<Path> entries = JarUtils.findAllRegularFiles(dir, files);
        Set names = entries.stream().map(JarUtils::toJarEntryName).collect(Collectors.toSet());
        Path tmpfile = Files.createTempFile("jar", "jar", new FileAttribute[0]);
        try (OutputStream out = Files.newOutputStream(tmpfile, new OpenOption[0]);
             JarOutputStream jos = new JarOutputStream(out);){
            try (JarFile jf = new JarFile(jarfile.toString());){
                Enumeration<JarEntry> jentries = jf.entries();
                while (jentries.hasMoreElements()) {
                    JarEntry jentry = jentries.nextElement();
                    if (names.contains(jentry.getName())) continue;
                    jos.putNextEntry(JarUtils.copyEntry(jentry));
                    jf.getInputStream(jentry).transferTo(jos);
                }
            }
            for (Path entry : entries) {
                String name = JarUtils.toJarEntryName(entry);
                jos.putNextEntry(new JarEntry(name));
                Files.copy(dir.resolve(entry), jos);
            }
        }
        Files.move(tmpfile, jarfile, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void updateJarFile(Path jarfile, Path dir) throws IOException {
        JarUtils.updateJarFile(jarfile, dir, Paths.get(".", new String[0]));
    }

    @Deprecated
    public static void createJar(String dest, String ... files) throws IOException {
        try (JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(dest), new Manifest());){
            for (String file : files) {
                System.out.println(String.format("Adding %s to %s", file, dest));
                jos.putNextEntry(new JarEntry(file));
                try (FileInputStream fis = new FileInputStream(file);){
                    fis.transferTo(jos);
                }
                catch (FileNotFoundException e) {
                    jos.write(file.getBytes());
                }
            }
        }
        System.out.println();
    }

    @Deprecated
    public static void updateJar(String src, String dest, String ... files) throws IOException {
        HashMap<String, Object> changes = new HashMap<String, Object>();
        boolean update = true;
        for (String file : files) {
            if (file.equals("-")) {
                update = false;
                continue;
            }
            if (update) {
                try {
                    Path p = Paths.get(file, new String[0]);
                    if (Files.exists(p, new LinkOption[0])) {
                        changes.put(file, p);
                        continue;
                    }
                    changes.put(file, file);
                }
                catch (InvalidPathException e) {
                    changes.put(file, file);
                }
                continue;
            }
            changes.put(file, Boolean.FALSE);
        }
        JarUtils.updateJar(src, dest, changes);
    }

    @Deprecated
    public static void updateJar(String src, String dest, Map<String, Object> changes) throws IOException {
        changes = new HashMap<String, Object>(changes);
        System.out.printf("Creating %s from %s...\n", dest, src);
        if (dest.equals(src)) {
            throw new IOException("src and dest cannot be the same");
        }
        try (JarOutputStream jos = new JarOutputStream(new FileOutputStream(dest));){
            try (JarFile srcJarFile = new JarFile(src);){
                Enumeration<JarEntry> entries = srcJarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (changes.containsKey(name)) {
                        System.out.println(String.format("- Update %s", name));
                        JarUtils.updateEntry(jos, name, changes.get(name));
                        changes.remove(name);
                        continue;
                    }
                    System.out.println(String.format("- Copy %s", name));
                    jos.putNextEntry(JarUtils.copyEntry(entry));
                    srcJarFile.getInputStream(entry).transferTo(jos);
                }
            }
            for (Map.Entry<String, Object> e : changes.entrySet()) {
                System.out.println(String.format("- Add %s", e.getKey()));
                JarUtils.updateEntry(jos, e.getKey(), e.getValue());
            }
        }
        System.out.println();
    }

    public static void updateManifest(String src, String dest, Manifest man) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        man.write(bout);
        JarUtils.updateJar(src, dest, Map.of("META-INF/MANIFEST.MF", bout.toByteArray()));
    }

    public static int deleteEntries(Path jarfile, String ... patterns) throws IOException {
        Path tmpfile = Files.createTempFile("jar", "jar", new FileAttribute[0]);
        int count = 0;
        try (OutputStream out = Files.newOutputStream(tmpfile, new OpenOption[0]);
             JarOutputStream jos = new JarOutputStream(out);
             JarFile jf = new JarFile(jarfile.toString());){
            Enumeration<JarEntry> jentries = jf.entries();
            block15: while (jentries.hasMoreElements()) {
                JarEntry jentry = jentries.nextElement();
                String name = jentry.getName();
                for (String pattern : patterns) {
                    if (pattern.endsWith("*")) {
                        if (!name.startsWith(pattern.substring(0, pattern.length() - 1))) continue;
                        ++count;
                        continue block15;
                    }
                    if (!name.equals(pattern)) continue;
                    ++count;
                    continue block15;
                }
                jos.putNextEntry(JarUtils.copyEntry(jentry));
                jf.getInputStream(jentry).transferTo(jos);
            }
        }
        Files.move(tmpfile, jarfile, StandardCopyOption.REPLACE_EXISTING);
        return count;
    }

    private static void updateEntry(JarOutputStream jos, String name, Object content) throws IOException {
        if (content instanceof Boolean) {
            if (((Boolean)content).booleanValue()) {
                throw new RuntimeException("Boolean value must be FALSE");
            }
        } else {
            jos.putNextEntry(new JarEntry(name));
            if (content instanceof Path) {
                Files.newInputStream((Path)content, new OpenOption[0]).transferTo(jos);
            } else if (content instanceof byte[]) {
                jos.write((byte[])content);
            } else if (content instanceof String) {
                jos.write(((String)content).getBytes());
            } else {
                throw new RuntimeException("Unknown type " + String.valueOf(content.getClass()));
            }
        }
    }

    private static String toJarEntryName(Path file) {
        Path normalized = file.normalize();
        return normalized.subpath(0, normalized.getNameCount()).toString().replace(File.separatorChar, '/');
    }

    private static List<Path> findAllRegularFiles(Path dir, Path[] files) throws IOException {
        ArrayList<Path> entries = new ArrayList<Path>();
        for (Path file : files) {
            try (Stream<Path> stream = Files.find(dir.resolve(file), Integer.MAX_VALUE, (p, attrs) -> attrs.isRegularFile(), new FileVisitOption[0]);){
                stream.map(dir::relativize).forEach(entries::add);
            }
        }
        return entries;
    }

    private static JarEntry copyEntry(JarEntry e1) {
        JarEntry e2 = new JarEntry(e1.getName());
        e2.setMethod(e1.getMethod());
        e2.setTime(e1.getTime());
        e2.setComment(e1.getComment());
        e2.setExtra(e1.getExtra());
        if (e1.getMethod() == 0) {
            e2.setSize(e1.getSize());
            e2.setCrc(e1.getCrc());
        }
        return e2;
    }
}

