/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.containers.docker;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import jdk.test.lib.Asserts;
import jdk.test.lib.Utils;
import jdk.test.lib.containers.docker.DockerRunOptions;
import jdk.test.lib.containers.docker.DockerTestUtils;
import jdk.test.lib.process.OutputAnalyzer;

public class Common {
    public static String imageName() {
        String testname = System.getProperty("test.name");
        Asserts.assertNotNull(testname, "must be set by jtreg");
        testname = testname.replace(".java", "");
        testname = testname.replace('/', '-');
        testname = testname.replace('\\', '-');
        return "jdk-internal:test-" + testname;
    }

    public static String imageName(String suffix) {
        return Common.imageName() + "-" + suffix;
    }

    public static void prepareWhiteBox() throws Exception {
        Files.copy(Paths.get(new File("whitebox.jar").getAbsolutePath(), new String[0]), Paths.get(Utils.TEST_CLASSES, "whitebox.jar"), StandardCopyOption.REPLACE_EXISTING);
    }

    public static DockerRunOptions newOpts(String imageName) {
        return new DockerRunOptions(imageName, "/jdk/bin/java", "-version", new String[0]).addJavaOpts("-Xlog:os+container=trace");
    }

    public static DockerRunOptions newOptsShowSettings(String imageName) {
        return new DockerRunOptions(imageName, "/jdk/bin/java", "-version", "-XshowSettings:system");
    }

    public static DockerRunOptions newOpts(String imageName, String testClass) {
        DockerRunOptions opts = new DockerRunOptions(imageName, "/jdk/bin/java", testClass, new String[0]);
        opts.addDockerOpts("--volume", Utils.TEST_CLASSES + ":/test-classes/");
        opts.addJavaOpts("-Xlog:os+container=trace", "-cp", "/test-classes/");
        return opts;
    }

    public static DockerRunOptions addWhiteBoxOpts(DockerRunOptions opts) {
        opts.addJavaOpts("-Xbootclasspath/a:/test-classes/whitebox.jar", "-XX:+UnlockDiagnosticVMOptions", "-XX:+WhiteBoxAPI");
        return opts;
    }

    public static OutputAnalyzer run(DockerRunOptions opts) throws Exception {
        return DockerTestUtils.dockerRunJava(opts).shouldHaveExitValue(0).shouldContain("Initializing Container Support");
    }

    public static void logNewTestCase(String msg) {
        System.out.println("========== NEW TEST CASE:      " + msg);
    }
}

