/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.security.timestamp;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import jdk.test.lib.security.timestamp.SignerEntry;
import jdk.test.lib.security.timestamp.TsaParam;
import jdk.test.lib.security.timestamp.TsaSigner;
import sun.security.util.KnownOIDs;

public class TsaHandler
implements HttpHandler {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public final KeyStore keyStore;
    public final char[] passphrase;

    public TsaHandler(KeyStore keyStore, String passphrase) {
        this.keyStore = keyStore;
        this.passphrase = passphrase == null ? null : passphrase.toCharArray();
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        try {
            byte[] responseData = this.createSigner(exchange).sign();
            exchange.getResponseHeaders().set("Content-Type", "application/timestamp-reply");
            exchange.sendResponseHeaders(200, responseData.length);
            exchange.getResponseBody().write(responseData);
        }
        catch (Exception e) {
            e.printStackTrace();
            exchange.sendResponseHeaders(500, 0L);
        }
        finally {
            exchange.close();
        }
    }

    protected TsaSigner createSigner(HttpExchange exchange) throws Exception {
        TsaParam param = this.getParam(exchange.getRequestURI());
        String alias = this.getSignerAlias(param.alias(), param.sigAlgo());
        SignerEntry signerEntry = this.createSignerEntry(alias);
        byte[] requestData = exchange.getRequestBody().readAllBytes();
        return new TsaSigner(signerEntry, requestData, param);
    }

    protected SignerEntry createSignerEntry(String alias) throws Exception {
        PrivateKey privateKey = (PrivateKey)this.keyStore.getKey(alias, this.passphrase);
        Certificate[] certChain = this.keyStore.getCertificateChain(alias);
        X509Certificate[] x509CertChain = (X509Certificate[])Arrays.copyOf(certChain, certChain.length, X509Certificate[].class);
        SignerEntry signerEntry = new SignerEntry(privateKey, x509CertChain);
        return signerEntry;
    }

    protected TsaParam getParam(URI uri) {
        String query = uri.getQuery();
        TsaParam param = TsaParam.newInstance();
        if (query != null) {
            for (String bufParam : query.split("&")) {
                String[] pair = bufParam.split("=");
                if ("alias".equalsIgnoreCase(pair[0])) {
                    param.alias(pair[1]);
                    System.out.println("alias: " + param.alias());
                    continue;
                }
                if ("sigAlgo".equalsIgnoreCase(pair[0])) {
                    param.sigAlgo(pair[1]);
                    System.out.println("sigAlgo: " + param.sigAlgo());
                    continue;
                }
                if ("version".equalsIgnoreCase(pair[0])) {
                    param.version(Integer.valueOf(pair[1]));
                    System.out.println("version: " + param.version());
                    continue;
                }
                if ("status".equalsIgnoreCase(pair[0])) {
                    param.status(Integer.valueOf(pair[1]));
                    System.out.println("status: " + param.status());
                    continue;
                }
                if ("policyId".equalsIgnoreCase(pair[0])) {
                    param.policyId(pair[1]);
                    System.out.println("policyId: " + param.policyId());
                    continue;
                }
                if ("digestAlgo".equalsIgnoreCase(pair[0])) {
                    param.digestAlgo(pair[1]);
                    System.out.println("digestAlgo: " + param.digestAlgo());
                    continue;
                }
                if ("serialNumber".equalsIgnoreCase(pair[0])) {
                    param.serialNumber(new BigInteger(pair[1]));
                    System.out.println("serialNumber: " + String.valueOf(param.serialNumber()));
                    continue;
                }
                if ("nonce".equalsIgnoreCase(pair[0])) {
                    param.nonce(new BigInteger(pair[1]));
                    System.out.println("nonce: " + String.valueOf(param.nonce()));
                    continue;
                }
                if ("date".equalsIgnoreCase(pair[0])) {
                    Date genTime = Date.from(LocalDate.parse(pair[1], FORMATTER).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
                    param.genTime(genTime);
                    System.out.println("genTime: " + String.valueOf(param.genTime()));
                    continue;
                }
                if (!"certReq".equalsIgnoreCase(pair[0])) continue;
                param.certReq(Boolean.valueOf(pair[1]));
                System.out.println("certReq: " + param.certReq());
            }
        }
        return param;
    }

    protected String getSignerAlias(String alias, String sigAlgo) throws Exception {
        if (alias == null) {
            String lower;
            int pos;
            String keyAlgo = sigAlgo == null ? null : ((pos = (lower = sigAlgo.toLowerCase(Locale.ROOT)).indexOf("with")) < 0 ? sigAlgo : sigAlgo.substring(pos + 4));
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String bufAlias = aliases.nextElement();
                X509Certificate bufCert = (X509Certificate)this.keyStore.getCertificate(bufAlias);
                List<String> eku = bufCert.getExtendedKeyUsage();
                if (eku == null || !eku.contains(KnownOIDs.KP_TimeStamping.value()) || keyAlgo != null && !keyAlgo.equalsIgnoreCase(bufCert.getPublicKey().getAlgorithm())) continue;
                return bufAlias;
            }
        }
        return alias;
    }
}

