/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.dcmd;

import java.util.ArrayList;
import java.util.List;
import jdk.test.lib.dcmd.CommandExecutorException;
import jdk.test.lib.dcmd.JcmdExecutor;
import jdk.test.lib.process.ProcessTools;

public class PidJcmdExecutor
extends JcmdExecutor {
    protected final long pid;
    protected boolean disableStreamingOutput = true;

    public PidJcmdExecutor() {
        this.pid = PidJcmdExecutor.getCurrentPid();
    }

    public PidJcmdExecutor(String target) {
        this.pid = Long.valueOf(target);
        this.disableStreamingOutput = this.pid == PidJcmdExecutor.getCurrentPid();
    }

    private static long getCurrentPid() {
        try {
            return ProcessTools.getProcessId();
        }
        catch (Exception e) {
            throw new CommandExecutorException("Could not determine own pid", e);
        }
    }

    @Override
    protected List<String> createCommandLine(String cmd) throws CommandExecutorException {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.jcmdBinary);
        if (this.disableStreamingOutput) {
            commandLine.add(this.jcmdDisableStreamingOption);
        }
        commandLine.add(Long.toString(this.pid));
        commandLine.add(cmd);
        return commandLine;
    }
}

