/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.management;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.lang.management.ManagementFactory;

public class DynamicVMOption {
    private final HotSpotDiagnosticMXBean mxBean;
    public final String name;

    public DynamicVMOption(String name) {
        this.name = name;
        this.mxBean = ManagementFactory.getPlatformMXBean(HotSpotDiagnosticMXBean.class);
    }

    public final void setValue(String newValue) {
        this.mxBean.setVMOption(this.name, newValue);
    }

    public final String getValue() {
        return this.mxBean.getVMOption(this.name).getValue();
    }

    public final boolean isWriteable() {
        return this.mxBean.getVMOption(this.name).isWriteable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidValue(String value) {
        boolean isValid = true;
        String oldValue = this.getValue();
        try {
            this.setValue(value);
        }
        catch (NullPointerException e) {
            if (value == null) {
                isValid = false;
            }
        }
        catch (IllegalArgumentException e) {
            isValid = false;
        }
        finally {
            this.setValue(oldValue);
        }
        return isValid;
    }

    public static String getString(String name) {
        return new DynamicVMOption(name).getValue();
    }

    public static int getInt(String name) {
        return Integer.parseInt(DynamicVMOption.getString(name));
    }

    public static void setString(String name, String value) {
        new DynamicVMOption(name).setValue(value);
    }

    public static void setInt(String name, int value) {
        new DynamicVMOption(name).setValue(Integer.toString(value));
    }
}

