/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Platform {
    public static final String vmName = System.getProperty("java.vm.name");
    public static final String vmInfo = System.getProperty("java.vm.info");
    private static final String osVersion = System.getProperty("os.version");
    private static int osVersionMajor = -1;
    private static int osVersionMinor = -1;
    private static final String osName = System.getProperty("os.name");
    private static final String dataModel = System.getProperty("sun.arch.data.model");
    private static final String vmVersion = System.getProperty("java.vm.version");
    private static final String jdkDebug = System.getProperty("jdk.debug");
    private static final String osArch = System.getProperty("os.arch");
    private static final String userName = System.getProperty("user.name");
    private static final String compiler = System.getProperty("sun.management.compiler");
    private static final String testJdk = System.getProperty("test.jdk");

    public static boolean isClient() {
        return vmName.endsWith(" Client VM");
    }

    public static boolean isServer() {
        return vmName.endsWith(" Server VM");
    }

    public static boolean isZero() {
        return vmName.endsWith(" Zero VM");
    }

    public static boolean isMinimal() {
        return vmName.endsWith(" Minimal VM");
    }

    public static boolean isEmbedded() {
        return vmName.contains("Embedded");
    }

    public static boolean isStatic() {
        return vmInfo.contains("static");
    }

    public static boolean isEmulatedClient() {
        return vmInfo.contains(" emulated-client");
    }

    public static boolean isTieredSupported() {
        return compiler != null && compiler.contains("Tiered Compilers");
    }

    public static boolean isInt() {
        return vmInfo.contains("interpreted");
    }

    public static boolean isMixed() {
        return vmInfo.contains("mixed");
    }

    public static boolean isComp() {
        return vmInfo.contains("compiled");
    }

    public static boolean is32bit() {
        return dataModel.equals("32");
    }

    public static boolean is64bit() {
        return dataModel.equals("64");
    }

    public static boolean isAix() {
        return Platform.isOs("aix");
    }

    public static boolean isLinux() {
        return Platform.isOs("linux");
    }

    public static boolean isBusybox(String tool) {
        try {
            Path toolpath = Paths.get(tool, new String[0]);
            return !Platform.isWindows() && Files.isSymbolicLink(toolpath) && Paths.get("/bin/busybox", new String[0]).equals(Files.readSymbolicLink(toolpath));
        }
        catch (IOException ignore) {
            return false;
        }
    }

    public static boolean isOSX() {
        return Platform.isOs("mac");
    }

    public static boolean isWindows() {
        return Platform.isOs("win");
    }

    private static boolean isOs(String osname) {
        return osName.toLowerCase(Locale.ROOT).startsWith(osname.toLowerCase(Locale.ROOT));
    }

    public static String getOsName() {
        return osName;
    }

    private static void init_version() {
        String[] osVersionTokens = osVersion.split("\\.");
        try {
            if (osVersionTokens.length > 0) {
                osVersionMajor = Integer.parseInt(osVersionTokens[0]);
                if (osVersionTokens.length > 1) {
                    osVersionMinor = Integer.parseInt(osVersionTokens[1]);
                }
            }
        }
        catch (NumberFormatException e) {
            osVersionMinor = 0;
            osVersionMajor = 0;
        }
    }

    public static String getOsVersion() {
        return osVersion;
    }

    public static int getOsVersionMajor() {
        if (osVersionMajor == -1) {
            Platform.init_version();
        }
        return osVersionMajor;
    }

    public static int getOsVersionMinor() {
        if (osVersionMinor == -1) {
            Platform.init_version();
        }
        return osVersionMinor;
    }

    public static boolean isDebugBuild() {
        return jdkDebug.toLowerCase(Locale.ROOT).contains("debug");
    }

    public static boolean isSlowDebugBuild() {
        return jdkDebug.toLowerCase(Locale.ROOT).equals("slowdebug");
    }

    public static boolean isFastDebugBuild() {
        return jdkDebug.toLowerCase(Locale.ROOT).equals("fastdebug");
    }

    public static String getVMVersion() {
        return vmVersion;
    }

    public static boolean isMusl() {
        try {
            ProcessBuilder pb = new ProcessBuilder("ldd", "--version");
            pb.redirectErrorStream(true);
            Process p = pb.start();
            BufferedReader b = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String l = b.readLine();
            if (l != null && l.contains("musl")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isAArch64() {
        return Platform.isArch("aarch64");
    }

    public static boolean isARM() {
        return Platform.isArch("arm.*");
    }

    public static boolean isRISCV64() {
        return Platform.isArch("riscv64");
    }

    public static boolean isPPC() {
        return Platform.isArch("ppc.*");
    }

    public static boolean isS390x() {
        return Platform.isArch("s390.*") || Platform.isArch("s/390.*") || Platform.isArch("zArch_64");
    }

    public static boolean isX64() {
        return Platform.isArch("(amd64)|(x86_64)");
    }

    public static boolean isX86() {
        return Platform.isArch("(i386)|(x86(?!_64))");
    }

    public static String getOsArch() {
        return osArch;
    }

    public static boolean isRoot() {
        return userName.equals("root");
    }

    public static boolean hasSA() {
        if (Platform.isZero()) {
            return false;
        }
        if (Platform.isAix()) {
            return false;
        }
        return !Platform.isLinux() || !Platform.isS390x() && !Platform.isARM();
    }

    private static Process launchCodesignOnJavaBinary() throws IOException {
        String jdkPath = System.getProperty("java.home");
        Path javaPath = Paths.get(jdkPath + "/bin/java", new String[0]);
        String javaFileName = javaPath.toAbsolutePath().toString();
        if (Files.notExists(javaPath, new LinkOption[0])) {
            throw new FileNotFoundException("Could not find file " + javaFileName);
        }
        ProcessBuilder pb = new ProcessBuilder("codesign", "--display", "--verbose", javaFileName);
        pb.redirectErrorStream(true);
        Process codesignProcess = pb.start();
        return codesignProcess;
    }

    public static boolean hasOSXPlistEntries() throws IOException {
        String line;
        Process codesignProcess = Platform.launchCodesignOnJavaBinary();
        BufferedReader is = new BufferedReader(new InputStreamReader(codesignProcess.getInputStream()));
        while ((line = is.readLine()) != null) {
            System.out.println("STDOUT: " + line);
            if (line.indexOf("Info.plist=not bound") != -1) {
                return false;
            }
            if (line.indexOf("Info.plist entries=") == -1) continue;
            return true;
        }
        System.out.println("No matching Info.plist entry was found");
        return false;
    }

    public static boolean isHardenedOSX() throws IOException {
        String line;
        if (Platform.getOsVersionMajor() == 10 && Platform.getOsVersionMinor() < 14) {
            return false;
        }
        Process codesignProcess = Platform.launchCodesignOnJavaBinary();
        BufferedReader is = new BufferedReader(new InputStreamReader(codesignProcess.getInputStream()));
        boolean isHardened = false;
        boolean hardenedStatusConfirmed = false;
        while ((line = is.readLine()) != null) {
            System.out.println("STDOUT: " + line);
            if (line.indexOf("flags=0x10000(runtime)") != -1) {
                hardenedStatusConfirmed = true;
                isHardened = true;
                System.out.println("Target JDK is hardened. Some tests may be skipped.");
                continue;
            }
            if (line.indexOf("flags=0x20002(adhoc,linker-signed)") != -1) {
                hardenedStatusConfirmed = true;
                isHardened = false;
                System.out.println("Target JDK is adhoc linker-signed, but not hardened.");
                continue;
            }
            if (line.indexOf("flags=0x2(adhoc)") != -1) {
                hardenedStatusConfirmed = true;
                isHardened = false;
                System.out.println("Target JDK is adhoc signed, but not hardened.");
                continue;
            }
            if (line.indexOf("code object is not signed at all") == -1) continue;
            hardenedStatusConfirmed = true;
            isHardened = false;
            System.out.println("Target JDK is not signed, therefore not hardened.");
        }
        if (!hardenedStatusConfirmed) {
            System.out.println("Could not confirm if TargetJDK is hardened. Assuming not hardened.");
            isHardened = false;
        }
        try {
            if (!codesignProcess.waitFor(10L, TimeUnit.SECONDS)) {
                System.err.println("Timed out waiting for the codesign process to complete. Assuming not hardened.");
                codesignProcess.destroyForcibly();
                return false;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return isHardened;
    }

    private static boolean isArch(String archnameRE) {
        return Pattern.compile(archnameRE, 2).matcher(osArch).matches();
    }

    public static boolean isOracleLinux7() {
        Pattern p;
        Matcher m;
        if (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("linux") && System.getProperty("os.version").toLowerCase(Locale.ROOT).contains("el") && (m = (p = Pattern.compile("el(\\d+)")).matcher(System.getProperty("os.version"))).find()) {
            try {
                return Integer.parseInt(m.group(1)) <= 7;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static String sharedLibraryExt() {
        if (Platform.isWindows()) {
            return "dll";
        }
        if (Platform.isOSX()) {
            return "dylib";
        }
        return "so";
    }

    public static String sharedLibraryPrefix() {
        if (Platform.isWindows()) {
            return "";
        }
        return "lib";
    }

    public static String buildSharedLibraryName(String name) {
        return Platform.sharedLibraryPrefix() + name + "." + Platform.sharedLibraryExt();
    }

    public static String sharedLibraryPathVariableName() {
        if (Platform.isWindows()) {
            return "PATH";
        }
        if (Platform.isOSX()) {
            return "DYLD_LIBRARY_PATH";
        }
        if (Platform.isAix()) {
            return "LIBPATH";
        }
        return "LD_LIBRARY_PATH";
    }

    public static Path libDir() {
        return Platform.libDir(Paths.get(testJdk, new String[0])).toAbsolutePath();
    }

    public static Path libDir(Path image) {
        if (Platform.isWindows()) {
            return image.resolve("bin");
        }
        return image.resolve("lib");
    }

    public static Path jvmLibDir() {
        return Platform.libDir().resolve(Platform.variant());
    }

    private static String variant() {
        if (Platform.isServer()) {
            return "server";
        }
        if (Platform.isClient()) {
            return "client";
        }
        if (Platform.isMinimal()) {
            return "minimal";
        }
        if (Platform.isZero()) {
            return "zero";
        }
        throw new Error("TESTBUG: unsupported vm variant");
    }

    public static boolean isDefaultCDSArchiveSupported() {
        return Platform.is64bit() && Platform.isServer() && (Platform.isLinux() || Platform.isOSX() || Platform.isWindows()) && !Platform.isZero() && !Platform.isMinimal() && !Platform.isARM();
    }

    public static boolean areCustomLoadersSupportedForCDS() {
        return Platform.is64bit() && (Platform.isLinux() || Platform.isOSX() || Platform.isWindows());
    }

    public static boolean isOnWayland() {
        return System.getenv("WAYLAND_DISPLAY") != null;
    }
}

