/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac;

import com.sun.source.util.JavacTask;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.api.MultiTaskListener;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.file.CacheFSInfo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Stream;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.CompilerConfiguration;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.builder.SourceFile;
import org.eclipse.jdt.internal.javac.BuildNotifierCompilationProgress;
import org.eclipse.jdt.internal.javac.JavacClassFile;
import org.eclipse.jdt.internal.javac.JavacCompilationResult;
import org.eclipse.jdt.internal.javac.JavacConfig;
import org.eclipse.jdt.internal.javac.JavacProblem;
import org.eclipse.jdt.internal.javac.JavacProblemConverter;
import org.eclipse.jdt.internal.javac.JavacTaskListener;
import org.eclipse.jdt.internal.javac.JavacUtils;
import org.eclipse.jdt.internal.javac.ProceedOnErrorGen;
import org.eclipse.jdt.internal.javac.ProceedOnErrorTransTypes;

public class JavacCompiler
extends Compiler {
    public static final Context.Key<Set<JavaFileObject>> FILES_WITH_ERRORS_KEY = new Context.Key();
    JavacConfig compilerConfig;
    IProblemFactory problemFactory;
    Map<JavaFileObject, ICompilationUnit> fileObjectToCUMap = new HashMap<JavaFileObject, ICompilationUnit>();

    public JavacCompiler(INameEnvironment environment, IErrorHandlingPolicy policy, CompilerConfiguration compilerConfig, ICompilerRequestor requestor, IProblemFactory problemFactory) {
        super(environment, policy, compilerConfig.compilerOptions(), requestor, problemFactory);
        this.compilerConfig = JavacConfig.createFrom(compilerConfig);
        this.problemFactory = problemFactory;
        this.progress = new BuildNotifierCompilationProgress(requestor);
    }

    public void compile(ICompilationUnit[] sourceUnits) {
        HashMap javacProblems = new HashMap();
        IJavaProject javaProject = Stream.of(sourceUnits).filter(SourceFile.class::isInstance).map(SourceFile.class::cast).map(source -> source.resource).map(IResource::getProject).filter(JavaProject::hasJavaNature).map(JavaCore::create).findFirst().orElse(null);
        java.util.List<ICompilationUnit> toCompile = Arrays.stream(sourceUnits).filter(unit -> {
            if (unit instanceof SourceFile) {
                SourceFile sf = (SourceFile)unit;
                File sourceFile = sf.resource.getLocation().toFile();
                if (this.compilerConfig != null && !JavacUtils.isEmpty(this.compilerConfig.generatedSourcePaths())) {
                    return !this.compilerConfig.generatedSourcePaths().stream().anyMatch(path -> sourceFile.toPath().startsWith(Path.of(path, new String[0])));
                }
            }
            return true;
        }).toList();
        JavacTaskListener javacListener = new JavacTaskListener(this, this.compilerConfig, this.problemFactory, this.fileObjectToCUMap);
        int unitIndex = 0;
        JavaCompiler tool = ToolProvider.getSystemJavaCompiler();
        Context javacContext = new Context();
        CacheFSInfo.preRegister(javacContext);
        ProceedOnErrorTransTypes.preRegister(javacContext);
        ProceedOnErrorGen.preRegister(javacContext);
        final JavacProblemConverter problemConverter = new JavacProblemConverter(this.compilerConfig.compilerOptions(), javacContext);
        HashSet sourceWithErrors = new HashSet();
        javacContext.put(FILES_WITH_ERRORS_KEY, sourceWithErrors);
        javacContext.put(DiagnosticListener.class, diagnostic -> {
            Object patt0$temp = diagnostic.getSource();
            if (patt0$temp instanceof JavaFileObject) {
                JavacProblem javacProblem;
                JavaFileObject fileObject = (JavaFileObject)patt0$temp;
                if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                    sourceWithErrors.add(fileObject);
                }
                if ((javacProblem = problemConverter.createJavacProblem(diagnostic)) != null) {
                    ICompilationUnit originalUnit = this.fileObjectToCUMap.get(fileObject);
                    if (originalUnit == null) {
                        return;
                    }
                    ArrayList<JavacProblem> previous = (ArrayList<JavacProblem>)javacProblems.get(originalUnit);
                    if (previous == null) {
                        previous = new ArrayList<JavacProblem>();
                        javacProblems.put(originalUnit, previous);
                    }
                    previous.add(javacProblem);
                }
            }
        });
        MultiTaskListener mtl = MultiTaskListener.instance(javacContext);
        mtl.add(javacListener);
        mtl.add(new TaskListener(){
            final /* synthetic */ JavacCompiler this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void finished(TaskEvent e) {
                ICompilationUnit iCompilationUnit;
                if (e.getSourceFile() != null && (iCompilationUnit = this.this$0.fileObjectToCUMap.get(e.getSourceFile())) instanceof JCTree.JCCompilationUnit) {
                    JCTree.JCCompilationUnit u = (JCTree.JCCompilationUnit)iCompilationUnit;
                    problemConverter.registerUnit(e.getSourceFile(), u);
                }
            }
        });
        JavacUtils.configureJavacContext(javacContext, this.compilerConfig, javaProject, javacListener.tempDir.toFile(), true);
        Options javacOptions = Options.instance(javacContext);
        javacOptions.remove(Option.XDOCLINT.primaryName);
        javacOptions.remove(Option.XDOCLINT_CUSTOM.primaryName);
        javacContext.put(com.sun.tools.javac.main.JavaCompiler.compilerKey, c -> new com.sun.tools.javac.main.JavaCompiler(this, c){
            boolean isInGeneration = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void generate(Queue<Pair<Env<AttrContext>, JCTree.JCClassDecl>> queue, Queue<JavaFileObject> results) {
                try {
                    this.isInGeneration = true;
                    super.generate(queue, results);
                }
                catch (AbortCompilation abort) {
                    throw abort;
                }
                catch (Throwable ex) {
                    ILog.get().error(ex.getMessage(), ex);
                }
                finally {
                    this.isInGeneration = false;
                }
            }

            @Override
            protected void desugar(Env<AttrContext> env, Queue<Pair<Env<AttrContext>, JCTree.JCClassDecl>> results) {
                try {
                    super.desugar(env, results);
                }
                catch (AbortCompilation abort) {
                    throw abort;
                }
                catch (Throwable ex) {
                    ILog.get().error(ex.getMessage(), ex);
                }
            }

            @Override
            public int errorCount() {
                return this.isInGeneration ? 0 : super.errorCount();
            }
        });
        JavacFileManager fileManager = (JavacFileManager)javacContext.get(JavaFileManager.class);
        try {
            List<JavaFileObject> sourceFiles = List.from(toCompile.stream().filter(SourceFile.class::isInstance).map(SourceFile.class::cast).map(source -> {
                IResource asResource = javaProject.getProject().getParent().findMember(new String(source.getFileName()));
                File unitFile = asResource != null ? asResource.getLocation().toFile() : new File(new String(source.getFileName()));
                JavaFileObject jfo = fileManager.getJavaFileObject(unitFile.getAbsolutePath());
                this.fileObjectToCUMap.put(jfo, (ICompilationUnit)source);
                return jfo;
            }).toList());
            JavacTask task = ((JavacTool)tool).getTask(null, fileManager, null, java.util.List.of(), java.util.List.of(), sourceFiles, javacContext);
            task.generate();
        }
        catch (Throwable e) {
            ILog.get().error("compilation failed", e);
        }
        for (ICompilationUnit in : toCompile) {
            CompilationResult result = new CompilationResult(in, unitIndex, sourceUnits.length, Integer.MAX_VALUE);
            ArrayList<CategorizedProblem> problems = new ArrayList<CategorizedProblem>();
            if (javacListener.getResults().containsKey(in)) {
                result = javacListener.getResults().get(in);
                ((JavacCompilationResult)result).migrateReferenceInfo();
                result.unitIndex = unitIndex;
                result.totalUnitsKnown = sourceUnits.length;
                java.util.List<CategorizedProblem> additionalProblems = ((JavacCompilationResult)result).getAdditionalProblems();
                if (additionalProblems != null && !additionalProblems.isEmpty()) {
                    problems.addAll(additionalProblems);
                }
            }
            if (javacProblems.containsKey(in)) {
                problems.addAll((Collection)javacProblems.get(in));
            }
            result.problems = problems.toArray(new CategorizedProblem[0]);
            result.problemCount = problems.size();
            this.requestor.acceptResult(result);
            if (result.compiledTypes != null) {
                for (Object type : result.compiledTypes.values()) {
                    JavacClassFile classFile;
                    if (!(type instanceof JavacClassFile) || (classFile = (JavacClassFile)((Object)type)).getBytes().length != 0) continue;
                    classFile.deleteExpectedClassFile();
                }
            }
            ++unitIndex;
        }
    }

    public void reportProgress(String taskDecription) {
        super.reportProgress(taskDecription);
    }
}

