/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.codeassist.impl.AssistOptions;

public class ExpectedTypes {
    private static final Set<StructuralPropertyDescriptor> CONDITION_LOCATIONS = Set.of(IfStatement.EXPRESSION_PROPERTY, WhileStatement.EXPRESSION_PROPERTY, DoStatement.EXPRESSION_PROPERTY, ForStatement.EXPRESSION_PROPERTY, ConditionalExpression.EXPRESSION_PROPERTY);
    private final int offset;
    private Collection<TypeFilter> expectedTypesFilters = Set.of(TypeFilter.SUPERTYPE, TypeFilter.SUBTYPE);
    private final Collection<ITypeBinding> expectedTypes = new LinkedHashSet<ITypeBinding>();
    private final Collection<ITypeBinding> uninterestingBindings = new LinkedHashSet<ITypeBinding>();
    private final Collection<ITypeBinding> forbiddenBindings = new LinkedHashSet<ITypeBinding>();
    private final AssistOptions options;
    private final ASTNode node;
    private boolean isReady;

    public ExpectedTypes(AssistOptions options, ASTNode toComplete, int offset) {
        this.offset = offset;
        this.options = options;
        this.node = toComplete;
    }

    /*
     * Unable to fully structure code
     */
    private void computeExpectedTypes() {
        parent2 = this.node;
        while (parent2 != null) {
            if (parent2 instanceof VariableDeclarationFragment && this.offset > (fragment = (VariableDeclarationFragment)parent2).getName().getStartPosition() + fragment.getName().getLength() && (variable = fragment.resolveBinding()) != null) {
                this.expectedTypes.add(variable.getType());
            }
            if (parent2 instanceof MethodInvocation && this.offset > (method = (MethodInvocation)parent2).getName().getStartPosition() + method.getName().getLength() || parent2 instanceof InfixExpression || parent2 instanceof ReturnStatement || parent2 instanceof Block || parent2 instanceof LambdaExpression) break;
            if (parent2 instanceof Assignment && this.offset > (assign = (Assignment)parent2).getLeftHandSide().getStartPosition() + assign.getLeftHandSide().getLength()) {
                this.expectedTypes.add(assign.resolveTypeBinding());
                return;
            }
            if (parent2 instanceof ClassInstanceCreation && this.offset > (newObj = (ClassInstanceCreation)parent2).getType().getStartPosition() + newObj.getType().getLength()) break;
            if (parent2 instanceof CastExpression && this.offset > (cast = (CastExpression)parent2).getType().getStartPosition() + cast.getType().getLength()) {
                this.expectedTypes.add(cast.getType().resolveBinding());
                return;
            }
            if (parent2.getLocationInParent() != null && ExpectedTypes.CONDITION_LOCATIONS.contains(parent2.getLocationInParent())) {
                this.expectedTypes.add(parent2.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
                return;
            }
            if (parent2.getLocationInParent() == ParameterizedType.TYPE_ARGUMENTS_PROPERTY && (var8_7 = parent2.getParent()) instanceof ParameterizedType) {
                parameterized = (ParameterizedType)var8_7;
                index = parameterized.typeArguments().indexOf(parent2);
                parameterizedType = parameterized.resolveBinding();
                if (parameterizedType != null && index >= 0) {
                    if (parameterizedType.getTypeDeclaration() != null) {
                        parameterizedType = parameterizedType.getTypeDeclaration();
                    }
                    if ((typeParameters = parameterizedType.getTypeParameters()).length > index) {
                        expectedType = typeParameters[index];
                        if (expectedType != null) {
                            if (expectedType.isTypeVariable() || expectedType.isWildcardType()) {
                                if (expectedType.getSuperclass() != null) {
                                    this.expectedTypes.add(expectedType.getSuperclass());
                                }
                                this.expectedTypes.addAll(Arrays.asList(expectedType.getInterfaces()));
                            } else {
                                this.expectedTypes.add(expectedType);
                            }
                        }
                        if (this.expectedTypes.isEmpty()) {
                            this.expectedTypes.add(parent2.getAST().resolveWellKnownType(Object.class.getName()));
                        }
                    }
                }
                return;
            }
            if (parent2 instanceof SwitchCase) {
                switchCase = (SwitchCase)parent2;
                typeParameters = switchCase.getParent();
                if (typeParameters instanceof SwitchStatement) {
                    stmt = (SwitchStatement)typeParameters;
                    this.expectedTypes.add(stmt.getExpression().resolveTypeBinding());
                    return;
                }
                var13_14 = switchCase.getParent();
                if (var13_14 instanceof SwitchExpression) {
                    expr = (SwitchExpression)var13_14;
                    this.expectedTypes.add(expr.getExpression().resolveTypeBinding());
                    return;
                }
            }
            if (parent2 instanceof ArrayInitializer) {
                array = (ArrayInitializer)parent2;
                arrayType = array.resolveTypeBinding();
                if (arrayType == null || !arrayType.isArray()) break;
                this.expectedTypes.add(arrayType.getElementType());
                break;
            }
            if (parent2.getLocationInParent() == MemberValuePair.VALUE_PROPERTY && (expr = parent2.getParent()) instanceof MemberValuePair && (binding = (mvp = (MemberValuePair)expr).resolveMemberValuePairBinding()) != null && (methodBinding = binding.getMethodBinding()) != null) {
                this.expectedTypes.add(methodBinding.getReturnType());
                break;
            }
            parent2 = parent2.getParent();
        }
        if ((parent = parent2) == null) {
            return;
        }
        this.expectedTypesFilters = Set.of(TypeFilter.SUBTYPE);
        if (!(parent instanceof VariableDeclaration)) ** GOTO lbl-1000
        variable = (VariableDeclaration)parent;
        if (!(parent instanceof TypeParameter) && this.offset > variable.getName().getStartPosition() + variable.getName().getLength()) {
            binding = variable.resolveBinding().getType();
            if (binding != null) {
                if (!(variable.getInitializer() instanceof ArrayInitializer)) {
                    this.expectedTypes.add(binding);
                } else {
                    this.expectedTypes.add(binding.getComponentType());
                }
            }
        } else if (parent instanceof Assignment) {
            assignment = (Assignment)parent;
            binding = assignment.resolveTypeBinding();
            if (binding != null) {
                this.expectedTypes.add(binding);
            }
        } else if (parent instanceof ReturnStatement) {
            ExpectedTypes.findLambda(parent).map((Function<LambdaExpression, IMethodBinding>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, resolveMethodBinding(), (Lorg/eclipse/jdt/core/dom/LambdaExpression;)Lorg/eclipse/jdt/core/dom/IMethodBinding;)()).or((Supplier<Optional>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$1(org.eclipse.jdt.core.dom.ASTNode ), ()Ljava/util/Optional;)((ASTNode)parent)).map((Function<IMethodBinding, ITypeBinding>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getReturnType(), (Lorg/eclipse/jdt/core/dom/IMethodBinding;)Lorg/eclipse/jdt/core/dom/ITypeBinding;)()).ifPresent((Consumer<ITypeBinding>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Lorg/eclipse/jdt/core/dom/ITypeBinding;)V)(this.expectedTypes));
        } else if (parent instanceof LambdaExpression) {
            lambda = (LambdaExpression)parent;
            if (lambda.getBody() == this.node) {
                Optional.ofNullable(lambda.resolveMethodBinding()).map((Function<IMethodBinding, ITypeBinding>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getReturnType(), (Lorg/eclipse/jdt/core/dom/IMethodBinding;)Lorg/eclipse/jdt/core/dom/ITypeBinding;)()).ifPresent((Consumer<ITypeBinding>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Lorg/eclipse/jdt/core/dom/ITypeBinding;)V)(this.expectedTypes));
            }
        } else if (parent instanceof CastExpression) {
            castExpression = (CastExpression)parent;
            binding = castExpression.resolveTypeBinding();
            if (binding != null) {
                this.expectedTypes.add(binding);
                this.expectedTypesFilters = Set.of(TypeFilter.SUBTYPE, TypeFilter.SUPERTYPE);
            }
        } else if (parent instanceof MethodInvocation) {
            messageSend = (MethodInvocation)parent;
            if (messageSend.getExpression() != null) {
                currentBinding = initialBinding = messageSend.getExpression().resolveTypeBinding();
                methodBinding = messageSend.getExpression();
                isStatic = methodBinding instanceof Name != false && (name = (Name)methodBinding).resolveBinding() instanceof ITypeBinding != false;
                while (currentBinding != null) {
                    this.computeExpectedTypesForMessageSend(currentBinding, messageSend.getName().toString(), messageSend.arguments(), initialBinding, messageSend, isStatic);
                    this.computeExpectedTypesForMessageSendForInterface(currentBinding, messageSend.getName().toString(), messageSend.arguments(), initialBinding, messageSend, isStatic);
                    currentBinding = currentBinding.getSuperclass();
                }
            } else {
                methodBinding = messageSend.resolveMethodBinding();
                if (this.node != parent) {
                    cursor = this.node;
                    while (cursor != null && cursor.getParent() != messageSend) {
                        cursor = cursor.getParent();
                    }
                    if (cursor != null && methodBinding != null) {
                        i = messageSend.arguments().indexOf(cursor);
                        if (i >= 0 && i < methodBinding.getParameterTypes().length) {
                            this.expectedTypes.add(methodBinding.getParameterTypes()[i]);
                        } else if (i >= 0 && methodBinding.isVarargs()) {
                            this.expectedTypes.add(methodBinding.getParameterTypes()[methodBinding.getParameterTypes().length - 1]);
                        }
                    }
                }
            }
        } else if (parent instanceof ClassInstanceCreation) {
            allocationExpression = (ClassInstanceCreation)parent;
            binding = allocationExpression.resolveTypeBinding();
            if (binding != null) {
                this.computeExpectedTypesForAllocationExpression(binding, allocationExpression.arguments(), allocationExpression);
            }
        } else if (parent instanceof InstanceofExpression) {
            e = (InstanceofExpression)parent;
            binding = e.getLeftOperand().resolveTypeBinding();
            if (binding != null) {
                this.expectedTypes.add(binding);
                this.expectedTypesFilters = Set.of(TypeFilter.SUBTYPE, TypeFilter.SUPERTYPE);
            }
        } else if (parent instanceof InfixExpression) {
            binaryExpression = (InfixExpression)parent;
            operator = binaryExpression.getOperator();
            if (operator == InfixExpression.Operator.EQUALS || operator == InfixExpression.Operator.NOT_EQUALS) {
                binding = binaryExpression.getLeftOperand().resolveTypeBinding();
                if (binding != null) {
                    this.expectedTypes.add((ITypeBinding)binding);
                    this.expectedTypesFilters = Set.of(TypeFilter.SUBTYPE, TypeFilter.SUPERTYPE);
                }
            } else if (operator == InfixExpression.Operator.PLUS) {
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.SHORT.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.INT.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.LONG.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.FLOAT.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.DOUBLE.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.CHAR.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BYTE.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(String.class.getName()));
            } else if (operator == InfixExpression.Operator.CONDITIONAL_AND || operator == InfixExpression.Operator.CONDITIONAL_OR || operator == InfixExpression.Operator.XOR) {
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
            } else {
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.SHORT.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.INT.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.LONG.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.FLOAT.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.DOUBLE.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.CHAR.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BYTE.toString()));
            }
            if (operator == InfixExpression.Operator.LESS && (var15_20 = binaryExpression.getLeftOperand()) instanceof Name) {
                binding = (Name)var15_20;
            }
        } else if (parent instanceof PrefixExpression) {
            prefixExpression = (PrefixExpression)parent;
            operator = prefixExpression.getOperator();
            if (operator == PrefixExpression.Operator.NOT) {
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
            } else if (operator == PrefixExpression.Operator.COMPLEMENT) {
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.SHORT.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.INT.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.LONG.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.CHAR.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BYTE.toString()));
            } else if (operator == PrefixExpression.Operator.PLUS || operator == PrefixExpression.Operator.MINUS || operator == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT) {
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.SHORT.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.INT.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.LONG.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.FLOAT.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.DOUBLE.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.CHAR.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BYTE.toString()));
            }
        } else if (parent instanceof ArrayAccess) {
            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.SHORT.toString()));
            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.INT.toString()));
            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.LONG.toString()));
        } else if (parent instanceof DoStatement) {
            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
        } else if (parent instanceof MemberValuePair) {
            pair = (MemberValuePair)parent;
            Optional.ofNullable(pair.resolveMemberValuePairBinding()).map((Function<IMemberValuePairBinding, IMethodBinding>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getMethodBinding(), (Lorg/eclipse/jdt/core/dom/IMemberValuePairBinding;)Lorg/eclipse/jdt/core/dom/IMethodBinding;)()).map((Function<IMethodBinding, ITypeBinding>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getReturnType(), (Lorg/eclipse/jdt/core/dom/IMethodBinding;)Lorg/eclipse/jdt/core/dom/ITypeBinding;)()).map((Function<ITypeBinding, ITypeBinding>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getComponentType(), (Lorg/eclipse/jdt/core/dom/ITypeBinding;)Lorg/eclipse/jdt/core/dom/ITypeBinding;)()).ifPresent((Consumer<ITypeBinding>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Lorg/eclipse/jdt/core/dom/ITypeBinding;)V)(this.expectedTypes));
        } else if (parent instanceof WhileStatement) {
            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
        } else if (parent instanceof IfStatement) {
            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
        } else if (parent instanceof AssertStatement) {
            assertStatement = (AssertStatement)parent;
            if (assertStatement.getExpression() == this.node) {
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
            }
        } else if (parent instanceof ForStatement) {
            forStatement = (ForStatement)parent;
            if (forStatement.getExpression().equals(this.node)) {
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
            }
        } else if (parent instanceof Javadoc) {
            ExpectedTypes.findMethod(parent).map((Function<MethodDeclaration, IMethodBinding>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, resolveBinding(), (Lorg/eclipse/jdt/core/dom/MethodDeclaration;)Lorg/eclipse/jdt/core/dom/IMethodBinding;)()).map((Function<IMethodBinding, ITypeBinding[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getExceptionTypes(), (Lorg/eclipse/jdt/core/dom/IMethodBinding;)[Lorg/eclipse/jdt/core/dom/ITypeBinding;)()).map((Function<ITypeBinding[], Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, stream(T[] ), ([Lorg/eclipse/jdt/core/dom/ITypeBinding;)Ljava/util/stream/Stream;)()).orElseGet((Supplier<Stream>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$18(), ()Ljava/util/stream/Stream;)()).forEach((Consumer<ITypeBinding>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Lorg/eclipse/jdt/core/dom/ITypeBinding;)V)(this.expectedTypes));
        } else if (parent instanceof ConditionalExpression) {
            conditionalExpr = (ConditionalExpression)parent;
            if (conditionalExpr.getExpression() == this.node) {
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
            } else {
                typeBinding = conditionalExpr.resolveTypeBinding();
                if (typeBinding != null && !typeBinding.isRecovered()) {
                    this.expectedTypes.add(typeBinding);
                }
            }
        }
        this.isReady = true;
    }

    private void computeExpectedTypesForAllocationExpression(ITypeBinding binding, List<Expression> arguments, ASTNode invocationSite) {
        IMethodBinding[] methods;
        if (arguments == null) {
            return;
        }
        IMethodBinding[] iMethodBindingArray = methods = (IMethodBinding[])this.avaiableMethods(binding).toArray(IMethodBinding[]::new);
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                ITypeBinding[] parameters;
                IMethodBinding method = iMethodBindingArray[n2];
                if (method.isConstructor() && !method.isSynthetic() && (parameters = method.getParameterTypes()).length >= arguments.size()) {
                    ITypeBinding expectedType;
                    int length = arguments.size() - 1;
                    int j = 0;
                    while (j < length) {
                        Expression argument = arguments.get(j);
                        ITypeBinding argType = argument.resolveTypeBinding();
                        if (argType == null || argType.isSubTypeCompatible(parameters[j])) {
                            ++j;
                            continue;
                        }
                        break block6;
                    }
                    if (arguments.size() > 0 && (expectedType = method.getParameterTypes()[arguments.size() - 1]) != null) {
                        this.expectedTypes.add(expectedType);
                    }
                }
            }
            ++n2;
        }
    }

    private void computeExpectedTypesForMessageSend(ITypeBinding binding, String selector, List<Expression> arguments, ITypeBinding receiverType, ASTNode invocationSite, boolean isStatic) {
        IMethodBinding[] methods;
        if (arguments == null) {
            return;
        }
        IMethodBinding[] iMethodBindingArray = methods = (IMethodBinding[])this.avaiableMethods(binding).toArray(IMethodBinding[]::new);
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                ITypeBinding[] parameters;
                IMethodBinding method = iMethodBindingArray[n2];
                if (!(method.isSynthetic() || method.isConstructor() || isStatic && !Modifier.isStatic(method.getModifiers()) || !Objects.equals(method.getName(), selector) || (parameters = method.getParameterTypes()).length < arguments.size())) {
                    if (arguments.isEmpty() && parameters.length > 0) {
                        this.expectedTypes.add(parameters[0]);
                    } else {
                        ITypeBinding expectedType;
                        int length = arguments.size() - 1;
                        int completionArgIndex = arguments.size() - 1;
                        int j = 0;
                        while (j < length) {
                            Expression argument = arguments.get(j);
                            ITypeBinding argType = argument.resolveTypeBinding();
                            if (argType == null || argType.getErasure().isSubTypeCompatible(parameters[j].getErasure())) {
                                ++j;
                                continue;
                            }
                            break block8;
                        }
                        if (completionArgIndex >= 0 && (expectedType = method.getParameterTypes()[completionArgIndex]) != null) {
                            this.expectedTypes.add(expectedType);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private void computeExpectedTypesForMessageSendForInterface(ITypeBinding binding, String selector, List<Expression> arguments, ITypeBinding receiverType, ASTNode invocationSite, boolean isStatic) {
        ITypeBinding[] itsInterfaces = binding.getInterfaces();
        int itsLength = itsInterfaces.length;
        ITypeBinding[] interfacesToVisit = itsInterfaces;
        int nextPosition = interfacesToVisit.length;
        int i = 0;
        while (i < nextPosition) {
            ITypeBinding currentType = interfacesToVisit[i];
            this.computeExpectedTypesForMessageSend(currentType, selector, arguments, receiverType, invocationSite, isStatic);
            itsInterfaces = currentType.getInterfaces();
            itsLength = itsInterfaces.length;
            if (nextPosition + itsLength >= interfacesToVisit.length) {
                ITypeBinding[] iTypeBindingArray = interfacesToVisit;
                interfacesToVisit = new ITypeBinding[nextPosition + itsLength + 5];
                System.arraycopy(iTypeBindingArray, 0, interfacesToVisit, 0, nextPosition);
            }
            int a = 0;
            while (a < itsLength) {
                block5: {
                    ITypeBinding next = itsInterfaces[a];
                    int b = 0;
                    while (b < nextPosition) {
                        if (!Objects.equals(next, interfacesToVisit[b])) {
                            ++b;
                            continue;
                        }
                        break block5;
                    }
                    interfacesToVisit[nextPosition++] = next;
                }
                ++a;
            }
            ++i;
        }
    }

    private static Optional<MethodDeclaration> findMethod(ASTNode node) {
        while (node != null && !(node instanceof MethodDeclaration)) {
            node = node.getParent();
        }
        return Optional.ofNullable((MethodDeclaration)node);
    }

    private static Optional<LambdaExpression> findLambda(ASTNode node) {
        while (node != null && !(node instanceof LambdaExpression)) {
            node = node.getParent();
        }
        return Optional.ofNullable((LambdaExpression)node);
    }

    private Set<IMethodBinding> avaiableMethods(ITypeBinding typeBinding) {
        HashSet<IMethodBinding> res = new HashSet<IMethodBinding>();
        res.addAll(Arrays.asList(typeBinding.getDeclaredMethods()));
        ITypeBinding[] iTypeBindingArray = typeBinding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding interfac = iTypeBindingArray[n2];
            res.addAll(this.avaiableMethods(interfac));
            ++n2;
        }
        if (typeBinding.getSuperclass() != null) {
            res.addAll(this.avaiableMethods(typeBinding.getSuperclass()));
        }
        return res;
    }

    public List<ITypeBinding> getExpectedTypes() {
        if (!this.isReady) {
            this.computeExpectedTypes();
        }
        return new ArrayList<ITypeBinding>(this.expectedTypes);
    }

    public boolean allowsSubtypes() {
        return this.expectedTypesFilters.contains((Object)TypeFilter.SUBTYPE);
    }

    public boolean allowsSupertypes() {
        return this.expectedTypesFilters.contains((Object)TypeFilter.SUPERTYPE);
    }

    private static /* synthetic */ Optional lambda$1(ASTNode aSTNode) {
        return ExpectedTypes.findMethod(aSTNode).map(MethodDeclaration::resolveBinding);
    }

    private static /* synthetic */ Stream lambda$18() {
        return Stream.of(new ITypeBinding[0]);
    }

    private static enum TypeFilter {
        SUPERTYPE,
        SUBTYPE;

    }
}

