/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.codeassist.ICompletionEngineProvider;

class CompletionEngineProviderDiscovery {
    private static final String SELECTED_SYSPROP = "ICompletionEngineProvider";
    private static final String CODE_ASSIST_PROVIDER_EXTPOINT_ID = "completionEngineProvider";
    private static boolean ERROR_LOGGED = false;
    private static String lastId;
    private static IConfigurationElement lastExtension;

    CompletionEngineProviderDiscovery() {
    }

    public static ICompletionEngineProvider getInstance() {
        block4: {
            String id = System.getProperty(SELECTED_SYSPROP);
            IConfigurationElement configElement = CompletionEngineProviderDiscovery.getConfigurationElement(id);
            lastId = id;
            lastExtension = configElement;
            if (configElement != null) {
                try {
                    Object executableExtension = configElement.createExecutableExtension("class");
                    if (executableExtension instanceof ICompletionEngineProvider) {
                        ICompletionEngineProvider icep = (ICompletionEngineProvider)executableExtension;
                        return icep;
                    }
                }
                catch (CoreException e) {
                    if (CompletionEngineProviderDiscovery.setErrorLogged()) break block4;
                    ILog.get().error("Could not instantiate ICompletionEngineProvider: '" + id + "' with class: " + configElement.getAttribute("class"), (Throwable)e);
                }
            }
        }
        return CompletionEngine::new;
    }

    private static IConfigurationElement getConfigurationElement(String id) {
        if (id == null || id.isBlank()) {
            return null;
        }
        if (lastExtension != null && Objects.equals(id, lastId)) {
            return lastExtension;
        }
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jdt.core", CODE_ASSIST_PROVIDER_EXTPOINT_ID);
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = ext.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    String elementId = configElement.getAttribute("id");
                    if (id.equals(elementId) && "resolver".equals(configElement.getName())) {
                        return configElement;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    private static synchronized boolean setErrorLogged() {
        boolean prev = ERROR_LOGGED;
        ERROR_LOGGED = true;
        return prev;
    }
}

