/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class SafeFileTable {
    protected IPath location;
    protected Properties table;
    private Workspace workspace;

    public SafeFileTable(String pluginId, Workspace workspace) throws CoreException {
        this.workspace = workspace;
        this.location = this.getWorkspace().getMetaArea().getSafeTableLocationFor(pluginId);
        this.restore();
    }

    public IPath[] getFiles() {
        Set<Object> set = this.table.keySet();
        String[] keys = set.toArray(new String[set.size()]);
        IPath[] files = new IPath[keys.length];
        int i = 0;
        while (i < keys.length) {
            files[i] = IPath.fromOSString(keys[i]);
            ++i;
        }
        return files;
    }

    protected Workspace getWorkspace() {
        return this.workspace;
    }

    public IPath lookup(IPath file) {
        String result = this.table.getProperty(file.toOSString());
        return result == null ? null : IPath.fromOSString(result);
    }

    public void map(IPath file, IPath aLocation) {
        if (aLocation == null) {
            this.table.remove(file);
        } else {
            this.table.setProperty(file.toOSString(), aLocation.toOSString());
        }
    }

    public void restore() throws CoreException {
        File target = this.location.toFile();
        this.table = new Properties();
        if (!target.exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream input = new FileInputStream(target);){
                this.table.load(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            String message = Messages.resources_exSafeRead;
            throw new ResourceException(566, null, message, e);
        }
    }

    public void save() throws CoreException {
        File target = this.location.toFile();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream output = new FileOutputStream(target);){
                this.table.store(output, "safe table");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            String message = Messages.resources_exSafeSave;
            throw new ResourceException(566, null, message, e);
        }
    }

    public void setLocation(IPath location) {
        if (location != null) {
            this.location = location;
        }
    }
}

