/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.util.gradle;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharSource;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.util.gradle.GradleVersion;
import org.gradle.api.UncheckedIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PublishedGradleVersions {
    private static final String VERSIONS_URL = "https://services.gradle.org/versions/all";
    private static final String MINIMUM_SUPPORTED_GRADLE_VERSION = "2.6";
    private static final String VERSION = "version";
    private static final String SNAPSHOT = "snapshot";
    private static final String ACTIVE_RC = "activeRc";
    private static final String RC_FOR = "rcFor";
    private static final String BROKEN = "broken";
    private static final Logger LOG = LoggerFactory.getLogger(PublishedGradleVersions.class);
    private final List<Map<String, String>> versions;

    private PublishedGradleVersions(List<Map<String, String>> versions) {
        this.versions = ImmutableList.copyOf(versions);
    }

    public List<GradleVersion> getVersions() {
        return FluentIterable.from(this.versions).filter((Predicate)new Predicate<Map<String, String>>(){

            public boolean apply(Map<String, String> input) {
                return (Boolean.valueOf(input.get(PublishedGradleVersions.ACTIVE_RC)) != false || input.get(PublishedGradleVersions.RC_FOR).equals("")) && Boolean.valueOf(input.get(PublishedGradleVersions.BROKEN)) == false && Boolean.valueOf(input.get(PublishedGradleVersions.SNAPSHOT)) == false;
            }
        }).transform((Function)new Function<Map<String, String>, GradleVersion>(){

            public GradleVersion apply(Map<String, String> input) {
                return GradleVersion.version(input.get(PublishedGradleVersions.VERSION));
            }
        }).filter((Predicate)new Predicate<GradleVersion>(){

            public boolean apply(GradleVersion input) {
                return input.compareTo(GradleVersion.version(PublishedGradleVersions.MINIMUM_SUPPORTED_GRADLE_VERSION)) >= 0;
            }
        }).toList();
    }

    public static PublishedGradleVersions create(LookupStrategy lookupStratgy) {
        if (lookupStratgy == LookupStrategy.REMOTE) {
            LOG.info("Gradle version information caching disabled. Remote download required.");
            String json = PublishedGradleVersions.downloadVersionInformation();
            return PublishedGradleVersions.create(json);
        }
        File cacheFile = PublishedGradleVersions.getCacheFile();
        if (!cacheFile.isFile() || !cacheFile.exists()) {
            LOG.info("Gradle version information cache is not available. Remote download required.");
            return PublishedGradleVersions.tryToDownloadAndCacheVersions(cacheFile, lookupStratgy);
        }
        if (cacheFile.lastModified() > System.currentTimeMillis() - TimeUnit.DAYS.toMillis(1L)) {
            LOG.info("Gradle version information cache is up-to-date. Trying to read.");
            return PublishedGradleVersions.tryToReadUpToDateVersionsFile(cacheFile, lookupStratgy);
        }
        LOG.info("Gradle version information cache is out-of-date. Trying to update.");
        return PublishedGradleVersions.tryToUpdateOutdatedVersionsFile(cacheFile, lookupStratgy);
    }

    private static PublishedGradleVersions tryToReadUpToDateVersionsFile(File cacheFile, LookupStrategy lookupStratgy) {
        Optional<String> cachedVersions = PublishedGradleVersions.readCacheVersionsFile(cacheFile);
        if (cachedVersions.isPresent()) {
            return PublishedGradleVersions.create((String)cachedVersions.get());
        }
        LOG.error("Cannot read Gradle version information cache. Remote download required.");
        return PublishedGradleVersions.tryToDownloadAndCacheVersions(cacheFile, lookupStratgy);
    }

    private static PublishedGradleVersions tryToUpdateOutdatedVersionsFile(File cacheFile, LookupStrategy lookupStratgy) {
        try {
            return PublishedGradleVersions.tryToDownloadAndCacheVersions(cacheFile, lookupStratgy);
        }
        catch (RuntimeException e) {
            Optional<String> cachedVersions = PublishedGradleVersions.readCacheVersionsFile(cacheFile);
            if (cachedVersions.isPresent()) {
                LOG.info("Updating Gradle version information cache failed. Using outdated cache.");
                return PublishedGradleVersions.create((String)cachedVersions.get());
            }
            throw new IllegalStateException("Cannot collect Gradle version information remotely nor locally.", e);
        }
    }

    private static PublishedGradleVersions tryToDownloadAndCacheVersions(File cacheFile, LookupStrategy lookupStratgy) {
        if (lookupStratgy == LookupStrategy.CACHED_ONLY) {
            throw new IllegalStateException("Could not get Gradle version information from cache and remote update was disabled");
        }
        String json = PublishedGradleVersions.downloadVersionInformation();
        PublishedGradleVersions.storeCacheVersionsFile(json, cacheFile);
        return PublishedGradleVersions.create(json);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String downloadVersionInformation() {
        String string;
        HttpURLConnection connection = null;
        InputStreamReader reader = null;
        try {
            URL url = PublishedGradleVersions.createURL(VERSIONS_URL);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            reader = new InputStreamReader(connection.getInputStream(), Charsets.UTF_8);
            string = CharStreams.toString((Readable)reader);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException("Cannot download published Gradle versions.", (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    Closeables.close(reader, (boolean)false);
                }
                catch (IOException e2) {
                    LOG.warn("Can't close stream after downloading published Gradle versions", (Throwable)e2);
                }
                if (connection != null) {
                    connection.disconnect();
                }
                throw throwable;
            }
        }
        try {
            Closeables.close((Closeable)reader, (boolean)false);
        }
        catch (IOException e) {
            LOG.warn("Can't close stream after downloading published Gradle versions", (Throwable)e);
        }
        if (connection != null) {
            connection.disconnect();
        }
        return string;
    }

    private static void storeCacheVersionsFile(String json, File cacheFile) {
        cacheFile.getParentFile().mkdirs();
        try {
            CharSource.wrap((CharSequence)json).copyTo(Files.asCharSink((File)cacheFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]));
        }
        catch (IOException e) {
            LOG.error("Cannot write Gradle version information cache file.", (Throwable)e);
        }
    }

    private static Optional<String> readCacheVersionsFile(File cacheFile) {
        try {
            return Optional.of((Object)Files.toString((File)cacheFile, (Charset)Charsets.UTF_8));
        }
        catch (IOException e) {
            LOG.error("Cannot read found Gradle version information cache file.", (Throwable)e);
            return Optional.absent();
        }
    }

    private static PublishedGradleVersions create(String json) {
        Gson gson = new GsonBuilder().create();
        TypeToken<List<Map<String, String>>> typeToken = new TypeToken<List<Map<String, String>>>(){};
        List versions = (List)gson.fromJson(json, typeToken.getType());
        return new PublishedGradleVersions(versions);
    }

    private static URL createURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL: " + url, e);
        }
    }

    private static File getCacheFile() {
        String xdgCache = System.getenv("XDG_CACHE_HOME");
        if (xdgCache != null) {
            return new File(xdgCache, "tooling/gradle/versions.json");
        }
        return CorePlugin.getInstance().getStateLocation().append("gradle").append("versions.json").toFile();
    }

    public static enum LookupStrategy {
        CACHED_ONLY,
        REMOTE_IF_NOT_CACHED,
        REMOTE;

    }
}

