/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EventListener {
    private List<String> events = new ArrayList<String>();
    private Set<String> interestingEvents = new HashSet<String>();

    public EventListener() {
    }

    public EventListener(String key) {
        this.interestingEvents.add(key);
    }

    public EventListener(String ... keys) {
        if (keys != null) {
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String k = stringArray[n2];
                this.interestingEvents.add(k);
                ++n2;
            }
        }
    }

    public void record(String event) {
        String key = event.substring(0, event.indexOf(58)).toLowerCase();
        if (!this.interestingEvents.isEmpty() && !this.interestingEvents.contains(key)) {
            return;
        }
        this.events.add(event);
    }

    public void clear() {
        this.events.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String event : this.events) {
            sb.append(event).append("\n");
        }
        return sb.toString();
    }

    public int eventCount() {
        return this.events.size();
    }

    public List<String> getEvents() {
        return Collections.unmodifiableList(this.events);
    }
}

