/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.watson;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import org.eclipse.core.internal.dtree.DataTreeWriter;
import org.eclipse.core.internal.dtree.DeltaDataTree;
import org.eclipse.core.internal.dtree.IDataFlattener;
import org.eclipse.core.internal.resources.SaveManager;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.IElementComparator;
import org.eclipse.core.internal.watson.IElementInfoFlattener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;

public class ElementTreeWriter {
    public static final int CURRENT_FORMAT = 1;
    public static final int D_INFINITE = -1;
    protected DataTreeWriter dataTreeWriter;

    public ElementTreeWriter(final IElementInfoFlattener flattener) {
        IDataFlattener f = new IDataFlattener(){

            @Override
            public void writeData(IPath path, Object data, DataOutput output) throws IOException {
                if (!IPath.ROOT.equals(path)) {
                    flattener.writeElement(path, data, output);
                }
            }

            @Override
            public Object readData(IPath path, DataInput input) {
                return null;
            }
        };
        this.dataTreeWriter = new DataTreeWriter(f);
    }

    protected ElementTree[] writeSortedTrees(ElementTree[] trees, DataOutput output) throws IOException {
        ElementTree[] sorted = SaveManager.sortTrees(trees);
        if (sorted == null) {
            throw new IOException("Unable to save workspace - Trees in ambiguous order (Bug 352867)");
        }
        int numTrees = trees.length;
        HashMap<ElementTree, Deque> indicesByTree = new HashMap<ElementTree, Deque>();
        int i = 0;
        while (i < numTrees) {
            indicesByTree.computeIfAbsent(trees[i], k -> new ArrayDeque()).push(i);
            ++i;
        }
        i = 0;
        while (i < numTrees) {
            Integer order = (Integer)((Deque)indicesByTree.get(sorted[i])).pop();
            this.writeNumber(order, output);
            ++i;
        }
        return sorted;
    }

    public void writeDelta(ElementTree olderTree, ElementTree newerTree, IPath path, int depth, DataOutput output, IElementComparator comparator) throws IOException {
        this.writeNumber(1, output);
        DeltaDataTree completeTree = newerTree.getDataTree();
        DeltaDataTree derivedTree = olderTree.getDataTree();
        DeltaDataTree deltaToWrite = completeTree.forwardDeltaWith(derivedTree, comparator);
        Assert.isTrue(deltaToWrite.isImmutable());
        this.dataTreeWriter.writeTree(deltaToWrite, path, depth, output);
    }

    public void writeDeltaChain(ElementTree[] trees, IPath path, int depth, DataOutput output, IElementComparator comparator) throws IOException {
        this.writeNumber(1, output);
        int treeCount = trees.length;
        this.writeNumber(treeCount, output);
        if (treeCount <= 0) {
            return;
        }
        ElementTree[] sortedTrees = this.writeSortedTrees(trees, output);
        this.writeTree(sortedTrees[0], path, depth, output);
        int i = 1;
        while (i < treeCount) {
            this.writeDelta(sortedTrees[i], sortedTrees[i - 1], path, depth, output, comparator);
            ++i;
        }
    }

    protected void writeNumber(int number, DataOutput output) throws IOException {
        if (number >= 0 && number < 255) {
            output.writeByte(number);
        } else {
            output.writeByte(255);
            output.writeInt(number);
        }
    }

    public void writeTree(ElementTree tree, IPath path, int depth, DataOutput output) throws IOException {
        this.writeNumber(1, output);
        DeltaDataTree subtree = new DeltaDataTree(tree.getDataTree().copyCompleteSubtree(IPath.ROOT));
        this.dataTreeWriter.writeTree(subtree, path, depth, output);
    }
}

