/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.AbstractLineTracker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension2;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.MultiStringMatcher;
import org.eclipse.jface.text.TypedRegion;

public class TextUtilities {
    public static final String[] DELIMITERS = new String[]{"\n", "\r", "\r\n"};
    @Deprecated
    public static final String[] fgDelimiters = DELIMITERS;

    public static String determineLineDelimiter(String text, String hint) {
        String delimiter = TextUtilities.nextDelimiter((CharSequence)text, (int)0).delimiter;
        return delimiter != null ? delimiter : hint;
    }

    @Deprecated
    public static int[] indexOf(String[] searchStrings, String text, int offset) {
        MultiStringMatcher.Match match;
        Objects.requireNonNull(searchStrings);
        String[] stringArray = searchStrings;
        int n = searchStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String searchString = stringArray[n2];
            Objects.requireNonNull(searchString);
            ++n2;
        }
        if (offset < 0) {
            offset = 0;
        }
        if ((match = MultiStringMatcher.indexOf(text, offset, searchStrings)) != null) {
            i = 0;
            while (i < searchStrings.length) {
                if (match.getText().equals(searchStrings[i])) {
                    return new int[]{match.getOffset(), i};
                }
                ++i;
            }
        } else {
            i = searchStrings.length - 1;
            while (i >= 0) {
                if (searchStrings[i].length() == 0) {
                    int[] nArray = new int[2];
                    nArray[1] = i;
                    return nArray;
                }
                --i;
            }
        }
        return new int[]{-1, -1};
    }

    public static int endsWith(String[] searchStrings, String text) {
        int index = -1;
        int i = 0;
        while (i < searchStrings.length) {
            if (text.endsWith(searchStrings[i]) && (index == -1 || searchStrings[i].length() > searchStrings[index].length())) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static int startsWith(String[] searchStrings, String text) {
        int index = -1;
        int i = 0;
        while (i < searchStrings.length) {
            if (text.startsWith(searchStrings[i]) && (index == -1 || searchStrings[i].length() > searchStrings[index].length())) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static int equals(String[] compareStrings, String text) {
        int i = 0;
        while (i < compareStrings.length) {
            if (text.equals(compareStrings[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static DocumentEvent mergeUnprocessedDocumentEvents(IDocument unprocessedDocument, List<? extends DocumentEvent> documentEvents) throws BadLocationException {
        if (documentEvents.isEmpty()) {
            return null;
        }
        Iterator<? extends DocumentEvent> iterator = documentEvents.iterator();
        DocumentEvent firstEvent = iterator.next();
        IDocument document = unprocessedDocument;
        int offset = firstEvent.getOffset();
        int length = firstEvent.getLength();
        StringBuilder text = new StringBuilder(firstEvent.getText() == null ? "" : firstEvent.getText());
        while (iterator.hasNext()) {
            String eventText;
            int delta = text.length() - length;
            DocumentEvent event = iterator.next();
            int eventOffset = event.getOffset();
            int eventLength = event.getLength();
            String string = eventText = event.getText() == null ? "" : event.getText();
            if (eventOffset > offset + length + delta) {
                String string2 = document.get(offset + length, eventOffset - delta - (offset + length));
                text.append(string2);
                text.append(eventText);
                length = eventOffset - delta + eventLength - offset;
                continue;
            }
            if (eventOffset + eventLength < offset) {
                String string3 = document.get(eventOffset + eventLength, offset - (eventOffset + eventLength));
                text.insert(0, string3);
                text.insert(0, eventText);
                length = offset + length - eventOffset;
                offset = eventOffset;
                continue;
            }
            int start = Math.max(0, eventOffset - offset);
            int end = Math.min(text.length(), eventLength + eventOffset - offset);
            text.replace(start, end, eventText);
            offset = Math.min(offset, eventOffset);
            int totalDelta = delta + eventText.length() - eventLength;
            length = text.length() - totalDelta;
        }
        return new DocumentEvent(document, offset, length, text.toString());
    }

    public static DocumentEvent mergeProcessedDocumentEvents(List<? extends DocumentEvent> documentEvents) throws BadLocationException {
        if (documentEvents.isEmpty()) {
            return null;
        }
        ListIterator<? extends DocumentEvent> iterator = documentEvents.listIterator(documentEvents.size());
        DocumentEvent firstEvent = iterator.previous();
        IDocument document = firstEvent.getDocument();
        int offset = firstEvent.getOffset();
        int length = firstEvent.getLength();
        int textLength = firstEvent.getText() == null ? 0 : firstEvent.getText().length();
        while (iterator.hasPrevious()) {
            int eventTextLength;
            int delta = length - textLength;
            DocumentEvent event = iterator.previous();
            int eventOffset = event.getOffset();
            int eventLength = event.getLength();
            int n = eventTextLength = event.getText() == null ? 0 : event.getText().length();
            if (eventOffset > offset + textLength + delta) {
                length = eventOffset - delta - (offset + textLength) + length + eventLength;
                textLength = eventOffset - delta + eventTextLength - offset;
                continue;
            }
            if (eventOffset + eventTextLength < offset) {
                length = offset - (eventOffset + eventTextLength) + length + eventLength;
                textLength = offset + textLength - eventOffset;
                offset = eventOffset;
                continue;
            }
            int start = Math.max(0, eventOffset - offset);
            int end = Math.min(length, eventTextLength + eventOffset - offset);
            offset = Math.min(offset, eventOffset);
            int totalDelta = delta + eventLength - eventTextLength;
            textLength = (length += eventLength - (end - start)) - totalDelta;
        }
        String text = document.get(offset, textLength);
        return new DocumentEvent(document, offset, length, text);
    }

    public static Map<String, IDocumentPartitioner> removeDocumentPartitioners(IDocument document) {
        HashMap<String, IDocumentPartitioner> partitioners = new HashMap<String, IDocumentPartitioner>();
        if (document instanceof IDocumentExtension3) {
            String[] partitionings;
            IDocumentExtension3 extension3 = (IDocumentExtension3)((Object)document);
            String[] stringArray = partitionings = extension3.getPartitionings();
            int n = partitionings.length;
            int n2 = 0;
            while (n2 < n) {
                String partitioning = stringArray[n2];
                IDocumentPartitioner partitioner = extension3.getDocumentPartitioner(partitioning);
                if (partitioner != null) {
                    extension3.setDocumentPartitioner(partitioning, null);
                    partitioner.disconnect();
                    partitioners.put(partitioning, partitioner);
                }
                ++n2;
            }
        } else {
            IDocumentPartitioner partitioner = document.getDocumentPartitioner();
            if (partitioner != null) {
                document.setDocumentPartitioner(null);
                partitioner.disconnect();
                partitioners.put("__dftl_partitioning", partitioner);
            }
        }
        return partitioners;
    }

    public static void addDocumentPartitioners(IDocument document, Map<String, ? extends IDocumentPartitioner> partitioners) {
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)((Object)document);
            for (Map.Entry<String, ? extends IDocumentPartitioner> entry : partitioners.entrySet()) {
                String partitioning = entry.getKey();
                IDocumentPartitioner partitioner = entry.getValue();
                partitioner.connect(document);
                extension3.setDocumentPartitioner(partitioning, partitioner);
            }
            partitioners.clear();
        } else {
            IDocumentPartitioner partitioner = partitioners.get("__dftl_partitioning");
            partitioner.connect(document);
            document.setDocumentPartitioner(partitioner);
        }
    }

    public static String getContentType(IDocument document, String partitioning, int offset, boolean preferOpenPartitions) throws BadLocationException {
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)((Object)document);
            try {
                return extension3.getContentType(partitioning, offset, preferOpenPartitions);
            }
            catch (BadPartitioningException badPartitioningException) {
                return "__dftl_partition_content_type";
            }
        }
        return document.getContentType(offset);
    }

    public static ITypedRegion getPartition(IDocument document, String partitioning, int offset, boolean preferOpenPartitions) throws BadLocationException {
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)((Object)document);
            try {
                return extension3.getPartition(partitioning, offset, preferOpenPartitions);
            }
            catch (BadPartitioningException badPartitioningException) {
                return new TypedRegion(0, document.getLength(), "__dftl_partition_content_type");
            }
        }
        return document.getPartition(offset);
    }

    public static ITypedRegion[] computePartitioning(IDocument document, String partitioning, int offset, int length, boolean includeZeroLengthPartitions) throws BadLocationException {
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)((Object)document);
            try {
                return extension3.computePartitioning(partitioning, offset, length, includeZeroLengthPartitions);
            }
            catch (BadPartitioningException badPartitioningException) {
                return new ITypedRegion[0];
            }
        }
        return document.computePartitioning(offset, length);
    }

    public static String[] computePartitionManagingCategories(IDocument document) {
        IDocumentExtension3 extension3;
        String[] partitionings;
        if (document instanceof IDocumentExtension3 && (partitionings = (extension3 = (IDocumentExtension3)((Object)document)).getPartitionings()) != null) {
            HashSet categories = new HashSet();
            String[] stringArray = partitionings;
            int n = partitionings.length;
            int n2 = 0;
            while (n2 < n) {
                IDocumentPartitionerExtension2 extension2;
                String[] c;
                String partitioning = stringArray[n2];
                IDocumentPartitioner p = extension3.getDocumentPartitioner(partitioning);
                if (p instanceof IDocumentPartitionerExtension2 && (c = (extension2 = (IDocumentPartitionerExtension2)((Object)p)).getManagingPositionCategories()) != null) {
                    Collections.addAll(categories, c);
                }
                ++n2;
            }
            String[] result = new String[categories.size()];
            categories.toArray(result);
            return result;
        }
        return null;
    }

    public static String getDefaultLineDelimiter(IDocument document) {
        String lineDelimiter = null;
        if (document instanceof IDocumentExtension4 && (lineDelimiter = ((IDocumentExtension4)((Object)document)).getDefaultLineDelimiter()) != null) {
            return lineDelimiter;
        }
        try {
            lineDelimiter = document.getLineDelimiter(0);
        }
        catch (BadLocationException badLocationException) {}
        if (lineDelimiter != null) {
            return lineDelimiter;
        }
        String sysLineDelimiter = System.lineSeparator();
        String[] delimiters = document.getLegalLineDelimiters();
        Assert.isTrue(delimiters.length > 0);
        String[] stringArray = delimiters;
        int n = delimiters.length;
        int n2 = 0;
        while (n2 < n) {
            String delimiter = stringArray[n2];
            if (delimiter.equals(sysLineDelimiter)) {
                lineDelimiter = sysLineDelimiter;
                break;
            }
            ++n2;
        }
        if (lineDelimiter == null) {
            lineDelimiter = delimiters[0];
        }
        return lineDelimiter;
    }

    public static boolean overlaps(IRegion left, IRegion right) {
        if (left == null || right == null) {
            return false;
        }
        int rightEnd = right.getOffset() + right.getLength();
        int leftEnd = left.getOffset() + left.getLength();
        if (right.getLength() > 0) {
            if (left.getLength() > 0) {
                return left.getOffset() < rightEnd && right.getOffset() < leftEnd;
            }
            return right.getOffset() <= left.getOffset() && left.getOffset() < rightEnd;
        }
        if (left.getLength() > 0) {
            return left.getOffset() <= right.getOffset() && right.getOffset() < leftEnd;
        }
        return left.getOffset() == right.getOffset();
    }

    public static String[] copy(String[] array) {
        if (array != null) {
            String[] copy = new String[array.length];
            System.arraycopy(array, 0, copy, 0, array.length);
            return copy;
        }
        return null;
    }

    public static int[] copy(int[] array) {
        if (array != null) {
            int[] copy = new int[array.length];
            System.arraycopy(array, 0, copy, 0, array.length);
            return copy;
        }
        return null;
    }

    public static AbstractLineTracker.DelimiterInfo nextDelimiter(CharSequence text, int offset) {
        AbstractLineTracker.DelimiterInfo info = new AbstractLineTracker.DelimiterInfo();
        int length = text.length();
        int i = offset;
        while (i < length) {
            char ch = text.charAt(i);
            if (ch == '\r') {
                info.delimiterIndex = i;
                if (i + 1 < length && text.charAt(i + 1) == '\n') {
                    info.delimiter = DELIMITERS[2];
                    break;
                }
                info.delimiter = DELIMITERS[1];
                break;
            }
            if (ch == '\n') {
                info.delimiterIndex = i;
                info.delimiter = DELIMITERS[0];
                break;
            }
            ++i;
        }
        if (info.delimiter == null) {
            info.delimiterIndex = -1;
        } else {
            info.delimiterLength = info.delimiter.length();
        }
        return info;
    }
}

