/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.CleanUpConstants;
import org.eclipse.jdt.internal.corext.fix.StringConcatToTextBlockFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;

public class StringConcatToTextBlockCleanUpCore
extends AbstractCleanUp {
    public StringConcatToTextBlockCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public StringConcatToTextBlockCleanUpCore() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        return new CleanUpRequirements(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.stringconcat_to_textblock");
    }

    @Override
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null || !this.isEnabled("cleanup.stringconcat_to_textblock")) {
            return null;
        }
        return StringConcatToTextBlockFixCore.createCleanUp(compilationUnit, this.isEnabled(CleanUpConstants.STRINGCONCAT_STRINGBUFFER_STRINGBUILDER));
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.stringconcat_to_textblock")) {
            if (this.isEnabled(CleanUpConstants.STRINGCONCAT_STRINGBUFFER_STRINGBUILDER)) {
                return new String[]{MultiFixMessages.StringConcatToTextBlockStringBuffer_description};
            }
            return new String[]{MultiFixMessages.StringConcatToTextBlockCleanUp_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        StringBuilder bld = new StringBuilder();
        if (this.isEnabled("cleanup.stringconcat_to_textblock")) {
            bld.append("String buf = \"\"\"\n");
            bld.append("    public class A {\n");
            bld.append("        public void foo() {\n");
            bld.append("        }\n");
            bld.append("    }\n");
            bld.append("    \"\"\";\n");
        } else {
            bld.append("String buf = \"\" +\n");
            bld.append("    \"public class A {\" +\n");
            bld.append("    \"    public void foo() {\" +\n");
            bld.append("    \"    }\" + \n");
            bld.append("    \"}\";\n");
        }
        bld.append("\n");
        if (this.isEnabled("cleanup.stringconcat_to_textblock") && this.isEnabled(CleanUpConstants.STRINGCONCAT_STRINGBUFFER_STRINGBUILDER)) {
            bld.append("String k = \"\"\"\n");
            bld.append("    public void foo() {\n");
            bld.append("        return null;\n");
            bld.append("    }\n");
            bld.append("    \"\"\";\n");
        } else {
            bld.append("StringBuffer buf= new StringBuffer();\n");
            bld.append("buf.append(\"public void foo() {\\n\");\n");
            bld.append("buf.append(\"    return null;\\n\");\n");
            bld.append("buf.append(\"}\\n\");\n");
            bld.append("String k = buf.toString();\n");
        }
        return bld.toString();
    }
}

