/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.Arrays;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.search.LocatorResponse;
import org.eclipse.jdt.internal.core.search.matching.DOMPatternLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;
import org.eclipse.jdt.internal.core.search.matching.PackageReferenceLocator;

public class DOMPackageReferenceLocator
extends DOMPatternLocator {
    private PackageReferenceLocator locator;

    public DOMPackageReferenceLocator(PackageReferenceLocator locator) {
        super((SearchPattern)locator.pattern);
        this.locator = locator;
    }

    @Override
    public LocatorResponse match(Annotation node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.match(node.getTypeName(), nodeSet, locator);
    }

    @Override
    public LocatorResponse match(ASTNode node, NodeSetWrapper nodeSet, MatchLocator locator) {
        if (node instanceof ImportDeclaration) {
            ImportDeclaration decl = (ImportDeclaration)node;
            return this.match(decl.getName(), nodeSet, locator);
        }
        return this.toResponse(0);
    }

    @Override
    public LocatorResponse match(Name node, NodeSetWrapper nodeSet, MatchLocator locator) {
        char[][] arr = (char[][])Arrays.stream(node.getFullyQualifiedName().split("\\.")).map(String::toCharArray).toArray(x$0 -> new char[x$0][]);
        int level = nodeSet.addMatch((ASTNode)node, this.locator.matchLevelForTokens(arr));
        return this.toResponse(level, true);
    }

    @Override
    public LocatorResponse match(Type node, NodeSetWrapper nodeSet, MatchLocator locator) {
        if (node instanceof ArrayType) {
            ArrayType att = (ArrayType)node;
            return this.match(att.getElementType(), nodeSet, locator);
        }
        Name typePkg = null;
        if (node instanceof SimpleType) {
            Name name;
            SimpleType stt = (SimpleType)node;
            Name n = stt.getName();
            if (n instanceof QualifiedName) {
                QualifiedName qn = (QualifiedName)n;
                name = qn.getQualifier();
            } else {
                name = n;
            }
            typePkg = name;
        } else if (node instanceof QualifiedType) {
            Name name;
            QualifiedType qt3 = (QualifiedType)node;
            Type t1 = qt3.getQualifier();
            if (t1 instanceof SimpleType) {
                SimpleType sttt = (SimpleType)t1;
                name = sttt.getName();
            } else {
                name = null;
            }
            typePkg = name;
        } else if (node instanceof NameQualifiedType) {
            NameQualifiedType qt = (NameQualifiedType)node;
            typePkg = qt.getQualifier();
        }
        return typePkg != null ? this.match(typePkg, nodeSet, locator) : this.toResponse(0);
    }

    @Override
    public LocatorResponse resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        IPackageBinding ipb;
        String n;
        String patternName;
        if (binding instanceof IPackageBinding && (patternName = new String(this.locator.pattern.pkgName)).equals(n = (ipb = (IPackageBinding)binding).getName())) {
            return this.toResponse(3);
        }
        return this.toResponse(0);
    }
}

