/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import org.gradle.internal.Factory;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.UnknownServiceException;

public interface ServiceRegistry
extends ServiceLookup {
    public static final ServiceRegistry EMPTY = new ServiceRegistry(){

        @Override
        public <T> T get(Class<T> serviceType) throws UnknownServiceException, ServiceLookupException {
            throw this.emptyServiceRegistryException(serviceType);
        }

        @Override
        public <T> List<T> getAll(Class<T> serviceType) throws ServiceLookupException {
            return ImmutableList.of();
        }

        @Override
        public Object get(Type serviceType) throws UnknownServiceException, ServiceLookupException {
            throw this.emptyServiceRegistryException(serviceType);
        }

        @Override
        public Object find(Type serviceType) throws ServiceLookupException {
            return null;
        }

        @Override
        public <T> Factory<T> getFactory(Class<T> type) throws UnknownServiceException, ServiceLookupException {
            throw this.emptyServiceRegistryException(type);
        }

        private UnknownServiceException emptyServiceRegistryException(Type type) {
            return new UnknownServiceException(type, "Nothing is available in the empty service registry.");
        }

        @Override
        public <T> T newInstance(Class<T> type) throws UnknownServiceException, ServiceLookupException {
            throw this.emptyServiceRegistryException(type);
        }

        @Override
        public Object get(Type serviceType, Class<? extends Annotation> annotatedWith) throws UnknownServiceException, ServiceLookupException {
            throw this.emptyServiceRegistryException(serviceType);
        }
    };

    public <T> T get(Class<T> var1) throws UnknownServiceException, ServiceLookupException;

    public <T> List<T> getAll(Class<T> var1) throws ServiceLookupException;

    @Override
    public Object get(Type var1) throws UnknownServiceException, ServiceLookupException;

    @Override
    public Object find(Type var1) throws ServiceLookupException;

    public <T> Factory<T> getFactory(Class<T> var1) throws UnknownServiceException, ServiceLookupException;

    public <T> T newInstance(Class<T> var1) throws UnknownServiceException, ServiceLookupException;
}

